/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.tabnine.eclipse.shared.api.binary.BinaryProcessRequester;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessRequesterProvider;
import com.tabnine.eclipse.shared.api.binary.BinaryRequest;
import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineDeadException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryRequestFacade {
    static Logger logger = LogManager.getLogger(BinaryRequestFacade.class);
    public static final int COMPLETION_TIME_THRESHOLD = 2000;
    private final BinaryProcessRequesterProvider binaryProcessRequesterProvider;
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    public BinaryRequestFacade(BinaryProcessRequesterProvider binaryProcessRequesterProvider) {
        this.binaryProcessRequesterProvider = binaryProcessRequesterProvider;
    }

    public Long pid() {
        return this.binaryProcessRequesterProvider.get().pid();
    }

    public <R> R executeRequest(BinaryRequest<R> binaryRequest) {
        return this.executeRequest(binaryRequest, 2000);
    }

    public <R> R executeRequest(BinaryRequest<R> binaryRequest, int n2) {
        BinaryProcessRequester binaryProcessRequester = this.binaryProcessRequesterProvider.get();
        try {
            Object object = this.executor.submit(() -> binaryProcessRequester.request(binaryRequest)).get(n2, TimeUnit.MILLISECONDS);
            if (object != null) {
                this.binaryProcessRequesterProvider.onSuccessfulRequest();
            }
            binaryRequest.onSuccess(object);
            return (R)object;
        }
        catch (TimeoutException timeoutException) {
            this.binaryProcessRequesterProvider.onTimeout();
        }
        catch (ExecutionException executionException) {
            ExecutionException executionException2 = executionException;
            if (executionException.getCause() instanceof TabNineDeadException) {
                this.binaryProcessRequesterProvider.onDead(executionException2.getCause());
            } else {
                logger.warn("Tabnine's threw an unknown error during request.", (Throwable)executionException2);
            }
        }
        catch (CancellationException cancellationException) {
        }
        catch (Exception exception) {
            logger.debug("Tabnine's threw an unknown error.", (Throwable)exception);
        }
        return null;
    }
}

