/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.fetch;

import com.tabnine.eclipse.shared.api.binary.fetch.BinaryFetchUtils;
import com.tabnine.eclipse.shared.api.binary.fetch.BinaryVersion;
import com.tabnine.eclipse.shared.api.binary.fetch.GeneralDownloader;
import com.tabnine.eclipse.shared.api.binary.fetch.TempBundleValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BundleDownloader {
    static Logger logger = LogManager.getLogger(BundleDownloader.class);
    private final TempBundleValidator validator;
    private final GeneralDownloader downloader;

    public BundleDownloader(TempBundleValidator tempBundleValidator, GeneralDownloader generalDownloader) {
        this.validator = tempBundleValidator;
        this.downloader = generalDownloader;
    }

    public Optional<BinaryVersion> downloadAndExtractBundle(String string) {
        String string2;
        String string3 = String.join((CharSequence)"/", BinaryFetchUtils.getBundleServerUrl(), string, BinaryFetchUtils.TARGET_NAME, "TabNine.zip");
        if (this.downloader.download(string3, string2 = BinaryFetchUtils.bundleFullPath(string), this.validator)) {
            try {
                this.unzipFile(string2);
                Paths.get(string2, new String[0]).toFile().delete();
                return Optional.of(new BinaryVersion(BinaryFetchUtils.versionFullPath(string), string));
            }
            catch (IOException iOException) {
                logger.warn("error unzipping file", (Throwable)iOException);
            }
        }
        return Optional.empty();
    }

    private void unzipFile(String object) {
        File file = new File((String)object).getParentFile();
        byte[] byArray = new byte[1024];
        object = new ZipInputStream(new FileInputStream((String)object));
        Object object2 = ((ZipInputStream)object).getNextEntry();
        while (object2 != null) {
            int n2;
            File file2 = this.newFile(file, (ZipEntry)object2);
            object2 = new FileOutputStream(file2);
            while ((n2 = ((FilterInputStream)object).read(byArray)) > 0) {
                ((FileOutputStream)object2).write(byArray, 0, n2);
            }
            ((FileOutputStream)object2).close();
            object2 = ((ZipInputStream)object).getNextEntry();
            file2.setExecutable(true);
        }
        ((ZipInputStream)object).closeEntry();
        ((ZipInputStream)object).close();
    }

    private File newFile(File object, ZipEntry zipEntry) {
        File file = new File((File)object, zipEntry.getName());
        object = ((File)object).getCanonicalPath();
        String string = file.getCanonicalPath();
        if (!string.startsWith(String.valueOf(object) + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return file;
    }
}

