/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.cleanup;

import java.util.Map;
import org.eclipse.core.runtime.Assert;

public final class CleanUpRequirements {
    protected final boolean fRequiresAST;
    protected final Map<String, String> fCompilerOptions;
    protected final boolean fRequiresFreshAST;
    protected final boolean fRequiresChangedRegions;
    protected final boolean fRequiresSeparateOptions;

    public CleanUpRequirements(boolean requiresAST, boolean requiresFreshAST, boolean requiresChangedRegions, Map<String, String> compilerOptions) {
        this(requiresAST, requiresFreshAST, requiresChangedRegions, false, compilerOptions);
    }

    public CleanUpRequirements(boolean requiresAST, boolean requiresFreshAST, boolean requiresChangedRegions, boolean requiresSeparateOptions, Map<String, String> compilerOptions) {
        Assert.isLegal((!requiresFreshAST || requiresAST ? 1 : 0) != 0, (String)"Must not request fresh AST if no AST is required");
        Assert.isLegal((compilerOptions == null || requiresAST ? 1 : 0) != 0, (String)"Must not provide options if no AST is required");
        Assert.isLegal((!requiresSeparateOptions || requiresFreshAST ? 1 : 0) != 0, (String)"Must not require separate options if fresh AST not required");
        this.fRequiresAST = requiresAST;
        this.fRequiresFreshAST = requiresFreshAST;
        this.fRequiresChangedRegions = requiresChangedRegions;
        this.fRequiresSeparateOptions = requiresSeparateOptions;
        this.fCompilerOptions = compilerOptions;
        if (this.fCompilerOptions != null && !"error".equals(this.fCompilerOptions.get("org.eclipse.jdt.core.compiler.problem.unusedWarningToken"))) {
            this.fCompilerOptions.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "disabled");
        }
    }

    public boolean requiresAST() {
        return this.fRequiresAST;
    }

    public boolean requiresFreshAST() {
        return this.fRequiresFreshAST;
    }

    public boolean requiresSeparateOptions() {
        return this.fRequiresSeparateOptions;
    }

    public Map<String, String> getCompilerOptions() {
        return this.fCompilerOptions;
    }

    public boolean requiresChangedRegions() {
        return this.fRequiresChangedRegions;
    }
}

