/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.prop;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.RunMode;
import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.server.ServerShell;
import com.iizix.server.db.GroupInfo;
import java.io.File;
import java.io.Serializable;
import java.nio.file.InvalidPathException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerAppConfig
extends PropCnr {
    public static final String FILENAME = "fileName";
    public static final String GROUPS = "groups";
    private String[] a;
    private GroupInfo[] a;

    public ServerAppConfig() {
    }

    public ServerAppConfig(Atom atom) {
        super(atom);
    }

    public File getServerDirectory() {
        ServerShell serverShell = ServerShell.getInstance();
        return serverShell != null ? serverShell.getCurrentDirectory() : Utilities.getCanonicalFile((File)new File("."));
    }

    protected void onPropInvalidateCache() {
        this.a = null;
        this.a = null;
    }

    public ServerAppConfig clone() {
        try {
            ServerAppConfig serverAppConfig = (ServerAppConfig)super.clone();
            serverAppConfig.a = null;
            serverAppConfig.a = null;
            return serverAppConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getFileName() {
        return this.getString(FILENAME);
    }

    public String getDescription() {
        return this.getString(Atom.DESCR);
    }

    public String getGroupsString() {
        return this.getString(GROUPS);
    }

    public String[] getGroupNames() {
        String[] stringArray = this.a;
        if (stringArray == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            String string = this.getString(GROUPS);
            if (string != null) {
                String[] stringArray2 = string.split(",");
                int n = stringArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2;
                    String string3 = stringArray2[n2];
                    if (!(string3 = string3.trim()).isEmpty() && hashSet.add(string2 = string3.toLowerCase())) {
                        arrayList.add(string3);
                    }
                    ++n2;
                }
            }
            this.a = arrayList.toArray(new String[arrayList.size()]);
            stringArray = this.a;
        }
        return stringArray;
    }

    public GroupInfo[] getGroups(boolean bl) throws NotFoundException, SQLException {
        GroupInfo[] groupInfoArray = this.a;
        if (bl || groupInfoArray == null) {
            String[] stringArray = this.getGroupNames();
            this.a = GroupInfo.getGroups(stringArray, bl);
            groupInfoArray = this.a;
        }
        return groupInfoArray;
    }

    public boolean verify(PropVerification propVerification) {
        Object object;
        String string;
        Serializable serializable;
        Object object2;
        String string2;
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = (StringProp)this.getProp(FILENAME, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.WARNING, "Jar file name", (GProp)this, "Jar file name must be defined", new String[0]));
        } else {
            string2 = stringProp.getString();
            if (string2.isEmpty()) {
                propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.WARNING, "Jar file name", (GProp)stringProp, "Jar file name must be specified", new String[0]));
            } else {
                if (!string2.endsWith(".jar")) {
                    propVerification.add(new PropVerificationError("ext", PropVerificationError.Severity.WARNING, "Jar file name", (GProp)stringProp, "File extension must be \".jar\"", new String[0]));
                }
                if ((object2 = this.getServerDirectory()) == null || !((File)object2).isDirectory()) {
                    ILog.WARNING(((Object)((Object)this)).getClass(), (String)("Server directory \"" + (object2 != null ? ((File)object2).getPath() : "<undefined>") + "\" does not exist"));
                } else {
                    try {
                        serializable = ((File)object2).toPath().resolve(string2).toFile();
                        if (!((File)serializable).isFile()) {
                            propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.ERROR, "Jar file name", (GProp)stringProp, "Jar file \"" + ((File)serializable).getAbsolutePath() + "\" does not exist", new String[0]));
                        }
                    }
                    catch (InvalidPathException invalidPathException) {
                        propVerification.add(new PropVerificationError("fn", PropVerificationError.Severity.ERROR, "Jar file name", (GProp)stringProp, "Jar file \"" + string2 + "\", invalid path: " + invalidPathException.getMessage(), new String[0]));
                    }
                }
            }
        }
        string2 = PropVerificationError.Severity.ERROR;
        object2 = null;
        serializable = new HashSet();
        stringProp = (StringProp)this.getProp(GROUPS, StringProp.class);
        String string3 = string = stringProp != null ? stringProp.getString() : null;
        if (string == null) {
            object2 = "If all groups are allowed, specify wild card \"*\"";
            string2 = PropVerificationError.Severity.WARNING;
        } else {
            String[] stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                if (((String)(object = ((String)object).trim())).isEmpty()) {
                    object2 = "Group name cannot be empty";
                    break;
                }
                String string4 = ((String)object).toLowerCase();
                if (!((HashSet)serializable).add(string4)) {
                    object2 = "Group name \"" + (String)object + "\" is already specified";
                    break;
                }
                ++n2;
            }
        }
        if (object2 == null && RunMode.isAnyServerRunMode()) {
            try {
                object = GroupInfo.getGroups(((HashSet)serializable).toArray(new String[((HashSet)serializable).size()]), false);
            }
            catch (Exception exception) {
                object2 = "Failed checking groups: " + exception.getMessage();
                ILog.WARNING(((Object)((Object)this)).getClass(), (String)object2);
            }
        }
        if (object2 != null) {
            if (stringProp == null) {
                propVerification.add(new PropVerificationError((PropCnr)this, GROUPS, (PropVerificationError.Severity)string2, "User groups", (String)object2, new String[0]));
            } else {
                propVerification.add(new PropVerificationError("gn", (PropVerificationError.Severity)string2, "User groups", (GProp)stringProp, (String)object2, new String[0]));
            }
        }
        return true;
    }
}

