/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.iizix.NotFoundException;
import com.iizix.mail.MailSender;
import com.iizix.server.IAppLoader;
import com.iizix.server.IEndPoint;
import com.iizix.server.IEndPointListener;
import com.iizix.server.IServerDisposeListener;
import com.iizix.server.api.IWebServerRequestPrinter;
import com.iizix.server.app.AppDefinition;
import com.iizix.server.modules.IServerModule;
import com.iizix.server.prop.ServerApplicationSetupException;
import com.iizix.server.prop.ServerProps;
import com.iizix.text.IEnumLocaleString;
import com.iizix.txp.ITXPCoordinator;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.internet.AddressException;
import java.io.IOException;

public interface IServer
extends IAppLoader {
    public static final int MAX_VALID_APP_ID_LENGTH = 64;

    public static InvalidAppID validateAppID(String string) {
        int n = string.length();
        if (n == 0) {
            return InvalidAppID.EMPTY;
        }
        if (n > 64) {
            return InvalidAppID.TOO_LONG;
        }
        char c2 = string.charAt(0);
        if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
            return InvalidAppID.INVALID_FIRST_CHAR;
        }
        int n2 = 1;
        while (n2 < n) {
            if ((c2 = string.charAt(n2++)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '_') continue;
            return InvalidAppID.INVALID_CHAR;
        }
        return null;
    }

    public boolean addDisposeListener(IServerDisposeListener var1);

    public boolean removeDisposeListener(IServerDisposeListener var1);

    public void startServer() throws Throwable;

    public void onStartServer() throws Throwable;

    public void loadApplications() throws Throwable;

    public AppDefinition registerApplication(String var1, AppDefinition var2) throws ServerApplicationSetupException;

    public boolean dispose();

    public State getState();

    public ServerProps getServerProperties();

    public MailSender getDefaultMailSender() throws NotFoundException, AddressException, NoSuchProviderException, IOException;

    public MailSender getMailSender(String var1) throws NotFoundException, AddressException, NoSuchProviderException, IOException;

    public boolean addModule(IServerModule<?> var1);

    public boolean removeModule(IServerModule<?> var1);

    public IEndPoint[] getEndPointsInstances();

    public void onEndPointDisposed(IEndPoint var1);

    public IEndPoint[] addEndPointListener(IEndPointListener var1);

    public boolean removeEndPointListener(IEndPointListener var1);

    public ITXPCoordinator getTXPCoordinator();

    public String getRootDirectory();

    public boolean registerRequestPrinter(String var1, IWebServerRequestPrinter var2);

    public boolean unregisterRequestPrinter(String var1, IWebServerRequestPrinter var2);

    public static enum InvalidAppID implements IEnumLocaleString
    {
        EMPTY("App ID is empty"),
        TOO_LONG("App ID is too long, maximum 64 characters is allowed"),
        INVALID_FIRST_CHAR("App ID invalid first character, must be A-Z or a-z"),
        INVALID_CHAR("App ID contains an invalid character, only A-Z, a-z, 0-9, . (dot), and _ (underscore) are allowed");

        public final String englishText;
        public final String textID = "server.appid." + this.name().toLowerCase();

        private InvalidAppID(String string2) {
            this.englishText = string2;
        }

        public String getID() {
            return this.textID;
        }

        public String getFallback() {
            return this.englishText;
        }
    }

    public static enum State {
        NOT_STARTED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

