/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.SendTransaction;
import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.FixedVirtualizedAbstractReference;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropReference;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.ReferenceString;
import com.iizix.prop.font.FontConsumed;
import com.iizix.prop.font.IFontConsumer;
import com.iizix.prop.image.ClientImageData;
import com.iizix.prop.image.IImageTarget;
import com.iizix.prop.image.RuntimeImageDefinition;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class ImageReference
extends FixedVirtualizedAbstractReference<IImageTarget>
implements IFontConsumer {
    private int[] a;

    protected ImageReference() {
    }

    public ImageReference(Atom atom) {
        super(atom);
    }

    public ImageReference(Atom atom, String string) {
        super(atom, string);
    }

    public void setImageTypes(int ... nArray) {
        block5: {
            if (nArray != null) {
                if (nArray.length == 0) {
                    nArray = null;
                } else {
                    int[] nArray2 = nArray;
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray2[n3];
                        if (n4 < 0) {
                            nArray = null;
                            break block5;
                        }
                        ++n3;
                    }
                    nArray = (int[])nArray.clone();
                }
            }
        }
        this.a = nArray;
    }

    @Override
    protected void initializeProp(Element element) throws PropException {
        int[] nArray;
        block5: {
            nArray = null;
            String string = element.getAttribute("imageTypes").trim();
            String string2 = "";
            try {
                StringTokenizer stringTokenizer;
                int n2;
                if (string.isEmpty() || (n2 = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) <= 0) break block5;
                nArray = new int[n2];
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    int n4 = Integer.parseInt(string2);
                    if (n4 == -1) {
                        nArray = null;
                        break;
                    }
                    if (n4 < 0 || n4 > 127) {
                        throw new PropException(this, "Invalid image type \"" + string2 + "\" value is out of range in: " + string);
                    }
                    nArray[n3] = n4;
                    ++n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new PropException(this, "Invalid image type \"" + string2 + "\" in: " + string);
            }
        }
        this.a = nArray;
        super.initializeProp(element);
    }

    @Override
    protected void initializeElement(Element element) {
        int n2;
        super.initializeElement(element);
        int[] nArray = this.a;
        if (nArray != null && (n2 = nArray.length) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(nArray[n3]);
                ++n3;
            }
            element.setAttribute("imageTypes", stringBuilder.toString());
        }
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.Image;
    }

    @Override
    public Class<?> getPropertyClass() {
        return IImageTarget.class;
    }

    @Override
    public boolean isReferenceValid(GProp<?> gProp) {
        return !gProp.isDisposed() && gProp instanceof IImageTarget && ((IImageTarget)((Object)gProp)).isImageTargetValid();
    }

    public boolean setImage(IImageTarget iImageTarget) {
        if (this.fixedTarget == iImageTarget) {
            return false;
        }
        this.fixedTarget = iImageTarget;
        ReferenceString referenceString = new ReferenceString(iImageTarget.getReferencePropName());
        referenceString.setObject(iImageTarget.getClientImageData());
        if (iImageTarget instanceof RuntimeImageDefinition) {
            this.setPropValueIncognito(referenceString);
            this.setChanged();
            return true;
        }
        try {
            return this.setPropValue(referenceString);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientImageData getClientImageData() {
        ClientImageData clientImageData = null;
        IImageTarget iImageTarget = (IImageTarget)this.getTargetReference();
        if (iImageTarget != null) {
            if (iImageTarget instanceof RuntimeImageDefinition) {
                RuntimeImageDefinition runtimeImageDefinition = (RuntimeImageDefinition)iImageTarget;
                clientImageData = runtimeImageDefinition.getClientImageData();
            } else {
                ReferenceString referenceString = this.getReferenceString();
                ImageReference imageReference = this;
                synchronized (imageReference) {
                    if (referenceString != null && (clientImageData = (ClientImageData)referenceString.getObject()) == null) {
                        clientImageData = iImageTarget.getClientImageData();
                        referenceString.setObject(clientImageData);
                    }
                }
            }
        }
        return clientImageData;
    }

    private void d() {
        ReferenceString referenceString;
        if (this.isPropReferenceTreeValid() && (referenceString = this.getReferenceString()) != null) {
            referenceString.setObject(null);
        }
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        if (!this.isDisposed()) {
            IImageTarget iImageTarget = (IImageTarget)this.fixedTarget;
            if (iImageTarget instanceof RuntimeImageDefinition && !iImageTarget.isDisposed()) {
                return;
            }
            if (gEvent.isClearCacheEvent()) {
                this.d();
                this.getClientImageData();
            }
        }
        super.onEventSelf(gEvent);
    }

    @Override
    protected void informResolved() {
        this.d();
        this.getClientImageData();
    }

    @Override
    protected void informError() {
        this.d();
    }

    @Override
    public ImageReference clone() {
        this.getClientImageData();
        ImageReference imageReference = (ImageReference)super.clone();
        return imageReference;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        ClientImageData clientImageData = null;
        IImageTarget iImageTarget = (IImageTarget)this.fixedTarget;
        if (iImageTarget instanceof RuntimeImageDefinition && !iImageTarget.isDisposed()) {
            clientImageData = iImageTarget.getClientImageData();
        } else {
            ReferenceString referenceString = (ReferenceString)object;
            if (referenceString != null) {
                clientImageData = (ClientImageData)referenceString.getObject();
            }
        }
        if (clientImageData != null) {
            double d2 = propMgr.getEnvironment().getDPR();
            clientImageData.append(propMgr, sendTransaction, d2);
        } else {
            ClientImageData.appendNoData(sendTransaction);
        }
    }

    @Override
    public void collectConsumedFonts(Set<FontConsumed> set) {
        IImageTarget iImageTarget = (IImageTarget)this.getTargetReference();
        if (iImageTarget instanceof IFontConsumer) {
            ((IFontConsumer)((Object)iImageTarget)).collectConsumedFonts(set);
        }
    }
}

