/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.image;

import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.Utilities;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.resizers.DefaultResizerFactory;
import net.coobird.thumbnailator.resizers.Resizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CachedImage {
    private final String a;
    private final String b;
    private final String c;
    private final String d;
    private byte[] a;
    private final BufferedImage a;

    private CachedImage(BufferedImage bufferedImage, String string, String string2, String string3, String string4) {
        this.a = null;
        this.a = bufferedImage;
        this.a = string;
        this.b = string2;
        this.c = string3;
        this.d = string4;
    }

    public CachedImage(File file) throws IOException {
        this(file, false);
    }

    public CachedImage(File file, boolean bl) throws IOException {
        block17: {
            this.c = file.getPath();
            if (!file.isFile()) {
                throw new FileNotFoundException("Image file not found: " + this.c);
            }
            String string = file.getName();
            int n2 = string.lastIndexOf(46);
            this.d = n2 >= 0 ? string.substring(n2 + 1).toLowerCase(Locale.ENGLISH) : null;
            this.a = n2 < 0 ? string : string.substring(0, n2);
            this.b = n2 < 0 ? this.c : this.c.substring(0, n2 + this.c.length() - string.length());
            this.a = null;
            file = Utilities.getCanonicalFile(file);
            if (bl) {
                this.a = Files.readAllBytes(file.toPath());
                try {
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.a);){
                        this.a = ImageIO.read(byteArrayInputStream);
                        break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    this.a = null;
                    throw iOException;
                }
                catch (Throwable throwable) {
                    this.a = null;
                    ILog.SEVERE(this.getClass(), "Failed loading image from file: " + String.valueOf(file), throwable);
                    throw new IOException("Failed loading image from file: " + String.valueOf(file), throwable);
                }
            }
            try {
                this.a = ImageIO.read(file);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), "Failed loading image from file: " + String.valueOf(file), throwable);
                throw new IOException("Failed loading image from file: " + String.valueOf(file), throwable);
            }
        }
    }

    public BufferedImage getBufferedImage() {
        return this.a;
    }

    public String getFileName() {
        return this.c;
    }

    public String getFileExtension() {
        return this.d;
    }

    public Size getSize() {
        return new Size(this.a.getWidth(), this.a.getHeight());
    }

    public byte[] getData() {
        try {
            byte[] byArray = this.a;
            if (byArray != null) {
                return (byte[])byArray.clone();
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Failed cloning file data, file name: " + this.c, throwable);
        }
        return null;
    }

    public void writeTo(File file) throws IOException {
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing file name extension: " + String.valueOf(file));
        }
        String string2 = string.substring(n2 + 1).toLowerCase(Locale.ENGLISH);
        file = file.getCanonicalFile();
        try {
            ImageIO.write((RenderedImage)this.a, string2, file);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            String string3 = "Failed writing image to file: " + String.valueOf(file);
            ILog.SEVERE(this.getClass(), string3, throwable);
            throw new IOException(string3, throwable);
        }
    }

    public CachedImage scale(double d2, String string) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("DPR must be greater than 0: dpr=" + d2);
        }
        int n2 = this.a.getWidth();
        int n3 = this.a.getHeight();
        int n4 = Math.max(1, (int)Math.round((double)n2 * d2));
        int n5 = Math.max(1, (int)Math.round((double)n3 * d2));
        Resizer resizer = DefaultResizerFactory.getInstance().getResizer(new Dimension(n2, n3), new Dimension(n4, n5));
        BufferedImage bufferedImage = new BufferedImage(n4, n5, this.a.getType());
        resizer.resize(this.a, bufferedImage);
        String string2 = this.a + string;
        String string3 = this.b + string;
        String string4 = string3 + "." + this.d;
        return new CachedImage(bufferedImage, string2, string3, string4, this.d);
    }

    public CachedImage scale(int n2, int n3, String string) {
        if (n2 < 1 || n3 < 1) {
            throw new IllegalArgumentException("Width and height must be greater than 1: width=" + n2 + ", height=" + n3);
        }
        int n4 = this.a.getWidth();
        int n5 = this.a.getHeight();
        double d2 = (double)n2 / (double)n4;
        double d3 = (double)n3 / (double)n5;
        return this.scale(Math.min(d2, d3), string);
    }
}

