/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server;

import com.iizigo.Activator;
import com.iizigo.editor.PropHelper;
import com.iizigo.server.IServerConfigFileListener;
import com.iizigo.server.config.EditorServerProps;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.swt.InvokeSWTLater;
import com.iizix.GenericListener;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.text.IKStringInfoProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerConfigFile
extends GenericListener<IServerConfigFileListener> {
    private static final HashMap<File, ServerConfigFile> a = new HashMap();
    private final File a;
    private final EditorServerSettings a;
    private final EditorServerProps a;
    private int a;
    private EditorServerSettings b;
    private boolean b;
    private InvokeSWTLater a = new InvokeSWTLater(300, () -> this.a());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerConfigFile open(String string) throws IOException, PropException {
        File file = new File(string);
        if (!file.isFile()) {
            throw new FileNotFoundException("Server Configuration file '" + file.getAbsolutePath() + "' is not found");
        }
        file = file.getCanonicalFile();
        HashMap<File, ServerConfigFile> hashMap = a;
        synchronized (hashMap) {
            ServerConfigFile serverConfigFile = a.get(file);
            if (serverConfigFile != null) {
                ++serverConfigFile.a;
                ServerConfigFile.a(file);
                return serverConfigFile;
            }
            EditorServerSettings editorServerSettings = ServerConfigFile.loadFile(file);
            serverConfigFile = new ServerConfigFile(file, editorServerSettings);
            a.put(file, serverConfigFile);
            return serverConfigFile;
        }
    }

    public static EditorServerSettings loadFile(File file) throws IOException, PropException {
        PropCnr propCnr = Activator.loadPropertiesFile(file);
        if (propCnr instanceof EditorServerSettings) {
            EditorServerSettings editorServerSettings = (EditorServerSettings)propCnr;
            file = file.getCanonicalFile();
            editorServerSettings.assignConfigFile(file);
            editorServerSettings.setFileName(file.getPath());
            ServerConfigFile.a(file);
            return editorServerSettings;
        }
        throw new PropException((GProp)propCnr, "Property is not a Server Configuration property");
    }

    public static List<File> getHistory() {
        ArrayList<File> arrayList = new ArrayList<File>();
        IPreferenceStore iPreferenceStore = Activator.getInstance().getPreferenceStore();
        String string = iPreferenceStore.getString("com.iizigo.serverConfig.history");
        if (string != null) {
            String[] stringArray = string.split("\t");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                try {
                    File file = new File(string2).getCanonicalFile();
                    if (file.isFile()) {
                        arrayList.add(file);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n3;
            }
        }
        return arrayList;
    }

    private ServerConfigFile(File file, EditorServerSettings editorServerSettings) {
        super(IServerConfigFileListener.class);
        this.a = file;
        this.a = editorServerSettings;
        this.b = editorServerSettings.clone();
        this.a = EditorServerProps.createServerProps(Activator.designerPropertyManager);
        this.a.removeProp2(Atom.SETTINGS);
        this.a.addProp2((IGProp)editorServerSettings);
        editorServerSettings.assignConfigFile(file);
        editorServerSettings.onServerSettingsChanged();
        IKStringInfoProvider iKStringInfoProvider = Activator.getInstance().getKStringInfoProvider((GProp<?>)this.a);
        PropHelper.doVerify((PropCnr)this.a, iKStringInfoProvider);
        this.a.addPropListener(gEvent -> {
            boolean bl;
            if (gEvent.isVerifyEvent()) {
                PropHelper.queueVerify((PropCnr)this.a, iKStringInfoProvider, () -> this.a());
            }
            boolean bl2 = bl = !this.b.equals(editorServerSettings);
            if (bl != this.b) {
                this.b = bl;
                this.triggerNotify();
            }
        });
    }

    public String getNameNoExt() {
        String string = this.a.getName();
        int n2 = string.lastIndexOf(46);
        return n2 < 0 ? string : string.substring(0, n2);
    }

    public String getPath() {
        return this.a.getPath();
    }

    public boolean isDirty() {
        return this.b;
    }

    public void triggerNotify() {
        this.a.trigger();
    }

    private void a() {
        this.forEach(iServerConfigFileListener -> iServerConfigFileListener.onServerConfigFileUpdated(this));
    }

    public boolean doSave(Shell shell, IProgressMonitor iProgressMonitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.a);){
                fileOutputStream.write(Activator.createInputData((PropCnr)this.a));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            iProgressMonitor.setCanceled(true);
            Activator.openError(shell, "Server Configuration", "Failed saving the Server configuration file '" + this.a.getPath() + "'.", exception);
            return false;
        }
        this.b = this.a.clone();
        this.b = false;
        this.a();
        return true;
    }

    public EditorServerSettings getSettings() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        HashMap<File, ServerConfigFile> hashMap = a;
        synchronized (hashMap) {
            if (--this.a == 0) {
                ServerConfigFile serverConfigFile = a.remove(this.a);
                assert (serverConfigFile == this) : "Wrong global ServerConfigFile instance";
                this.a.dispose();
            }
        }
    }

    public void updateHistory() {
        ServerConfigFile.a(this.a);
    }

    private static void a(File file) {
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(ServerConfigFile.getHistory());
        linkedHashSet.remove(file);
        linkedHashSet.add(file);
        StringBuilder stringBuilder = new StringBuilder();
        for (File object2 : linkedHashSet) {
            if (!object2.isFile()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\t');
            }
            stringBuilder.append(object2.getPath());
        }
        IPreferenceStore iPreferenceStore = Activator.getInstance().getPreferenceStore();
        iPreferenceStore.setValue("com.iizigo.serverConfig.history", stringBuilder.toString());
    }
}

