/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.image.ImageHelper;
import com.iizigo.image.LastVerified;
import com.iizigo.image.prop.EditorImageStylesResolution;
import com.iizigo.image.prop.EditorStyledImageDefinition;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.image.prop.ImageDesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizix.Position;
import com.iizix.Size;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.ImageStyleLocation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class EditorImageStyleLocation
extends ImageStyleLocation
implements IEditorImage,
IPropDesigner {
    private ImageDesignerProp a = new ImageDesignerProp((PropCnr)this);

    public EditorImageStyleLocation() {
    }

    public EditorImageStyleLocation(Atom atom) {
        super(atom);
    }

    @Override
    public ImageDesignerProp getDesigner() {
        return this.a;
    }

    public EditorImageStyleLocation clone() throws CloneNotSupportedException {
        EditorImageStyleLocation editorImageStyleLocation = (EditorImageStyleLocation)super.clone();
        editorImageStyleLocation.a = new ImageDesignerProp((PropCnr)editorImageStyleLocation);
        return editorImageStyleLocation;
    }

    public String getTypeString() {
        return ImageHelper.getTypeString((PropCnr)this);
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageImageLocation;
    }

    @Override
    public String getCNType() {
        return "Location";
    }

    @Override
    public String getCNText(int n2) {
        if (n2 == 0) {
            String string = "location " + this.getInt("xo") + "," + this.getInt("yo");
            String string2 = this.getString(Atom.DESCR);
            if (string2 != null && !string2.isEmpty()) {
                string = string2 + ", " + string;
            }
            return string;
        }
        return n2 == 2 ? this.getTypeString() : "";
    }

    @Override
    public Composite createTooltip(Composite composite) {
        AssetReference assetReference = null;
        Size size = null;
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof EditorStyledImageDefinition) {
            EditorStyledImageDefinition editorStyledImageDefinition = (EditorStyledImageDefinition)propCnr;
            assetReference = editorStyledImageDefinition.getAssetReference();
            size = editorStyledImageDefinition.getImageSize();
        } else if (propCnr instanceof EditorImageStylesResolution) {
            EditorImageStylesResolution editorImageStylesResolution = (EditorImageStylesResolution)propCnr;
            assetReference = editorImageStylesResolution.getAssetReference();
            size = editorImageStylesResolution.getImageSize();
        }
        Rectangle rectangle = null;
        Position position = this.getLocation();
        if (size != null && position != null) {
            rectangle = new Rectangle(position.x, position.y, size.width, size.height);
        }
        return ImageHelper.createImageTooltip((PropCnr)this, composite, assetReference, this.getCNImage(), this.getCNType(), this.getCNText(0), rectangle);
    }

    public boolean verify(PropVerification propVerification) {
        IntProp intProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        IntProp intProp2 = (IntProp)this.getProp("xo", IntProp.class);
        if (intProp2 == null) {
            propVerification.add(new PropVerificationError("xo.undef", PropVerificationError.Severity.ERROR, "X offset", (GProp)this, "X offset must be defined", new String[0]));
        }
        if ((intProp = (IntProp)this.getProp("yo", IntProp.class)) == null) {
            propVerification.add(new PropVerificationError("yo.undef", PropVerificationError.Severity.ERROR, "Y offset", (GProp)this, "Y offset must be defined", new String[0]));
        }
        Size size = null;
        LastVerified lastVerified = null;
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof EditorStyledImageDefinition) {
            EditorStyledImageDefinition editorStyledImageDefinition = (EditorStyledImageDefinition)propCnr;
            lastVerified = editorStyledImageDefinition.getLastVerified();
            size = editorStyledImageDefinition.getImageSize();
        } else if (propCnr instanceof EditorImageStylesResolution) {
            EditorImageStylesResolution editorImageStylesResolution = (EditorImageStylesResolution)propCnr;
            lastVerified = editorImageStylesResolution.getLastVerified();
            size = editorImageStylesResolution.getImageSize();
        }
        if (size != null && lastVerified != null && lastVerified.success) {
            int n2;
            if (intProp2 != null && ((n2 = intProp2.getInt()) < 0 || n2 > lastVerified.width + size.width)) {
                propVerification.add(new PropVerificationError("xo.range", PropVerificationError.Severity.ERROR, "X offset", (GProp)intProp2, "X offset range is outside image horizontally", new String[0]));
            }
            if (intProp != null && ((n2 = intProp.getInt()) < 0 || n2 > lastVerified.height + size.height)) {
                propVerification.add(new PropVerificationError("yo.range", PropVerificationError.Severity.ERROR, "Y offset", (GProp)intProp, "Y offset range is outside image vertically", new String[0]));
            }
        }
        return true;
    }
}

