/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.image.ImageInfo;
import com.iizigo.image.LastVerified;
import com.iizigo.image.SingleImageControl;
import com.iizigo.image.prop.ILastVerified;
import com.iizigo.prop.FilePropCnr;
import com.iizix.ILog;
import com.iizix.Position;
import com.iizix.Utilities;
import com.iizix.js.JSFiles;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.AbstractImageDefinition;
import com.iizix.prop.image.AbstractImageResolution;
import com.iizix.prop.image.IImageStyle;
import com.iizix.prop.image.SVGInfo;
import com.iizix.swt.SWTHelper;
import com.iizix.swt.widget.IZ_Label;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ImageHelper {
    private static final Set<String> a = Set.of("jpg", "jpeg", "png", "gif");
    private static final String[] a = new String[]{"RTL", "LTR", "disabled", "enabled", "pressed", "released", "selected", "unselected", "focused", "unfocused", "hovering", "outside", "captured", "uncaptured"};

    public static boolean isImageExtension(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        return a.contains(string = string.toLowerCase()) || bl && string.equals("svg");
    }

    public static boolean isImageExtension(IResource iResource, boolean bl) {
        return iResource != null && iResource.getType() == 1 && ImageHelper.isImageExtension(iResource.getFileExtension(), bl);
    }

    public static boolean isImageExtension(FilePropCnr filePropCnr, boolean bl) {
        return ImageHelper.isImageExtension((IResource)filePropCnr.getIFile(), bl);
    }

    public static Image loadImage(IFile iFile, StringBuilder stringBuilder) {
        InputStream inputStream = null;
        try {
            inputStream = iFile.getContents();
            Image image = new Image((Device)Display.getDefault(), inputStream);
            return image;
        }
        catch (CoreException coreException) {
            if (stringBuilder != null) {
                stringBuilder.append(coreException.getMessage());
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static Composite createImageTooltip(Composite composite, IFile iFile, Image image, String string, String string2) {
        if (iFile == null) {
            return null;
        }
        if (ImageHelper.isImageExtension((IResource)iFile, true)) {
            if ("svg".equalsIgnoreCase(iFile.getFileExtension())) {
                Composite composite2;
                block22: {
                    ApplicationUI applicationUI = ApplicationUI.getInstance();
                    Font font = applicationUI.getBoldFont();
                    int n2 = applicationUI.s8();
                    int n3 = n2 / 2;
                    composite2 = new Composite(composite, 0);
                    GridLayout gridLayout = new GridLayout(2, false);
                    gridLayout.verticalSpacing = n3 / 2;
                    gridLayout.marginHeight = n3;
                    gridLayout.horizontalSpacing = gridLayout.marginWidth = n2;
                    composite2.setLayout((Layout)gridLayout);
                    CLabel cLabel = new CLabel(composite2, 0);
                    cLabel.setText(string + ":");
                    cLabel.setFont(font);
                    cLabel.setImage(image);
                    cLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
                    GridData gridData = new GridData(4, 128, true, false, 2, 1);
                    gridData.heightHint = applicationUI.s10();
                    Label label = new Label(composite2, 258);
                    label.setLayoutData((Object)gridData);
                    try {
                        int n4;
                        int n5;
                        SVGInfo sVGInfo = SVGInfo.fromDefinition((File)iFile.getLocation().toFile());
                        if (sVGInfo == null) break block22;
                        boolean bl = false;
                        double d2 = sVGInfo.getWidth();
                        double d3 = sVGInfo.getHeight();
                        if (d2 < 250.0 && d3 < 250.0) {
                            n5 = (int)Math.ceil(d2);
                            n4 = (int)Math.ceil(d3);
                        } else {
                            bl = true;
                            if (d2 > d3) {
                                n5 = 250;
                                n4 = (int)Math.ceil(d3 * 250.0 / Math.max(1.0, d2));
                            } else {
                                n5 = (int)Math.ceil(d2 * 250.0 / Math.max(1.0, d3));
                                n4 = 250;
                            }
                            sVGInfo.setScale(n5, n4);
                        }
                        String string3 = sVGInfo.getSVGForHTML();
                        if (string3 != null) {
                            Color color = applicationUI.widgetBackground;
                            StringBuilder stringBuilder = new StringBuilder("<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><style>html,body{width:100%;height:100%;overflow:hidden;margin:0;padding:0;background-color:rgb(").append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(")}#a{display:inline-block;border:1px solid #a0a0a0;padding:5px}#b{background-image:url('").append(JSFiles.getFileUrl((String)"svgDefinition/square-transparent-bg.png")).append("');width:").append(n5).append("px;height:").append(n4).append("px}</style></head><body><div id=a><div id=b>").append(string3).append("</div></div></body></html>");
                            try {
                                File file = File.createTempFile("iizi-svg-preview-", ".html");
                                Throwable throwable = null;
                                Object var27_28 = null;
                                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                                    fileOutputStream.write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                gridData = new GridData(0x1000000, 0x1000000, false, false, 2, 1);
                                gridData.verticalIndent = n3;
                                gridData.widthHint = applicationUI.cx(n5 + 12);
                                gridData.heightHint = applicationUI.cy(n4 + 12);
                                throwable = SWTHelper.createBrowser(composite2, color);
                                throwable.setLayoutData(gridData);
                                throwable.setUrl(file.toURI().toURL().toExternalForm());
                                throwable.addListener(12, event -> {
                                    boolean bl = file.delete();
                                });
                                if (bl) {
                                    gridData = new GridData(16384, 0x1000000, false, false, 2, 1);
                                    gridData.verticalIndent = n2;
                                    label = new Label(composite2, 0);
                                    label.setText("Image is scaled down to " + n5 + " x " + n4 + " pixels.");
                                    label.setLayoutData((Object)gridData);
                                    label.setFont(applicationUI.getItalicFont());
                                }
                            }
                            catch (IOException iOException) {
                                ILog.SEVERE(ImageHelper.class, (String)"Failed creating temporary SVG preview file", (Throwable)iOException);
                            }
                            gridData = new GridData(16384, 0x1000000, false, false);
                            gridData.verticalIndent = n2;
                            label = new Label(composite2, 0);
                            label.setText("SVG size in HTML:");
                            label.setLayoutData((Object)gridData);
                            gridData = new GridData(16384, 0x1000000, false, false);
                            gridData.verticalIndent = n2;
                            label = new Label(composite2, 0);
                            label.setText(Activator.getByteSize(string3.length()));
                            label.setLayoutData((Object)gridData);
                        }
                        gridData = new GridData(16384, 0x1000000, false, false);
                        gridData.verticalIndent = n2;
                        label = new Label(composite2, 0);
                        label.setText("Width:");
                        label.setLayoutData((Object)gridData);
                        gridData = new GridData(16384, 0x1000000, false, false);
                        gridData.verticalIndent = n2;
                        label = new Label(composite2, 0);
                        label.setText(Utilities.getShortestDouble((double)d2));
                        label.setLayoutData((Object)gridData);
                        label = new Label(composite2, 0);
                        label.setText("Height:");
                        label = new Label(composite2, 0);
                        label.setText(Utilities.getShortestDouble((double)d3));
                    }
                    catch (Throwable throwable) {
                        ILog.WARNING(ImageHelper.class, (String)"Failed creating SVG preview", (Throwable)throwable);
                    }
                }
                ImageHelper.addImageTooltipBottomPart(null, composite2, null, iFile, string2, null, null);
                return composite2;
            }
            return ImageHelper.a(null, composite, null, iFile, image, string, string2, null);
        }
        return null;
    }

    public static Composite createImageTooltip(PropCnr propCnr, Composite composite, AssetReference assetReference, Image image, String string, String string2) {
        return ImageHelper.a(propCnr, composite, assetReference, null, image, string, string2, null);
    }

    public static Composite createImageTooltip(PropCnr propCnr, Composite composite, AssetReference assetReference, Image image, String string, String string2, Rectangle rectangle) {
        return ImageHelper.a(propCnr, composite, assetReference, null, image, string, string2, rectangle);
    }

    public static Composite createImageTooltipTopPart(Composite composite, Image image, String string, String string2) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Font font = applicationUI.getBoldFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = applicationUI.s4();
        gridLayout.verticalSpacing = gridLayout.marginHeight / 2;
        gridLayout.horizontalSpacing = gridLayout.marginWidth = applicationUI.s8();
        composite2.setLayout((Layout)gridLayout);
        CLabel cLabel = new CLabel(composite2, 0);
        cLabel.setText(string + ":");
        cLabel.setFont(font);
        cLabel.setImage(image);
        cLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        gridData.heightHint = applicationUI.s10();
        Label label = new Label(composite2, 258);
        label.setLayoutData((Object)gridData);
        return composite2;
    }

    public static SingleImageControl addImageTooltipImagePart(Composite composite, AssetReference assetReference, IFile iFile, Rectangle rectangle) {
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        SingleImageControl singleImageControl = null;
        if (assetReference == null && iFile == null) {
            IZ_Label iZ_Label = new IZ_Label(composite, 0);
            iZ_Label.setText("(No file or asset reference)");
            iZ_Label.setBackground(applicationUI.errorBackground);
            iZ_Label.setForeground(applicationUI.errorForeground);
            GridData gridData = new GridData(0x1000000, 128, true, false, 2, 1);
            gridData.verticalIndent = applicationUI.s8();
            iZ_Label.setLayoutData(gridData);
        } else {
            singleImageControl = assetReference == null ? new SingleImageControl(composite, 2048, iFile, rectangle) : new SingleImageControl(composite, 2048, 1, assetReference, null, rectangle);
            singleImageControl.scaleToMax(500, 200);
            GridData gridData = new GridData(0x1000000, 128, true, false, 2, 1);
            gridData.verticalIndent = applicationUI.s8();
            singleImageControl.setLayoutData(gridData);
        }
        return singleImageControl;
    }

    public static void addImageTooltipBottomPart(PropCnr propCnr, Composite composite, AssetReference assetReference, IFile iFile, String string, Rectangle rectangle, SingleImageControl singleImageControl) {
        String string2;
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        GridData gridData2 = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = gridData2.verticalIndent = ApplicationUI.getInstance().s8();
        Label label = new Label(composite, 0);
        label.setText("ID:");
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(string.replace("&", "&&"));
        label.setLayoutData((Object)gridData2);
        if (propCnr != null) {
            label = new Label(composite, 0);
            label.setText("Reference: ");
            label = new Label(composite, 0);
            label.setText(propCnr.getReferencePropName().replace("&", "&&"));
            string2 = propCnr.getString(Atom.DESCR);
            if (string2 != null && !string2.isEmpty()) {
                label = new Label(composite, 0);
                label.setText("Description:");
                label = new Label(composite, 0);
                label.setText(string2.replace("&", "&&"));
            }
        }
        if (assetReference != null) {
            label = new Label(composite, 0);
            label.setText("File reference:");
            label = new Label(composite, 0);
            label.setText(assetReference.getReference().replace("&", "&&"));
        }
        if (iFile == null && singleImageControl != null) {
            iFile = singleImageControl.a.getFile();
        }
        if (iFile != null) {
            string2 = iFile.getFullPath().toString();
            try {
                File file = iFile.getLocation().toFile();
                string2 = file.getCanonicalPath();
                string2 = file.getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            label = new Label(composite, 0);
            label.setText("File path:");
            label = new Label(composite, 0);
            label.setText(string2.replace("&", "&&"));
            label = new Label(composite, 0);
            label.setText("File size:");
            label = new Label(composite, 0);
            label.setText(ImageHelper.getSizeString(iFile));
        }
        if (singleImageControl != null && singleImageControl.a.isValid()) {
            label = new Label(composite, 0);
            label.setText("Device pixels:");
            label = new Label(composite, 0);
            label.setText(singleImageControl.a.getWidth() + " x " + singleImageControl.a.getHeight());
        }
        if (rectangle != null) {
            label = new Label(composite, 0);
            label.setText("Location:");
            label = new Label(composite, 0);
            label.setText(rectangle.x + "," + rectangle.y);
            label = new Label(composite, 0);
            label.setText("Size:");
            label = new Label(composite, 0);
            label.setText(rectangle.width + " x " + rectangle.height);
        }
    }

    private static Composite a(PropCnr propCnr, Composite composite, AssetReference assetReference, IFile iFile, Image image, String string, String string2, Rectangle rectangle) {
        Composite composite2 = ImageHelper.createImageTooltipTopPart(composite, image, string, string2);
        SingleImageControl singleImageControl = ImageHelper.addImageTooltipImagePart(composite2, assetReference, iFile, rectangle);
        ImageHelper.addImageTooltipBottomPart(propCnr, composite2, assetReference, iFile, string2, rectangle, singleImageControl);
        return composite2;
    }

    public static void addImageTooltipPreviews(Composite composite, ArrayList<AssetReference> arrayList, ArrayList<Position> arrayList2, int n2, int n3, SingleImageControl singleImageControl) {
        int n4 = arrayList.size();
        if (n4 == 0) {
            return;
        }
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        int n5 = applicationUI.s8();
        int n6 = n5 / 2;
        GridData gridData = new GridData(4, 4, true, false, 2, 1);
        gridData.verticalIndent = n6;
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.marginWidth = 0;
        rowLayout.marginHeight = n6;
        rowLayout.spacing = n5;
        gridData = new GridData(4, 4, true, false, 2, 1);
        int n7 = singleImageControl != null && singleImageControl.a.isValid() ? singleImageControl.a.getWidth() + 20 : 0;
        int n8 = Math.min(1, 472 / (n2 + 12));
        n7 = Math.max(n7, n8 * (n2 + 12) + 28);
        gridData.widthHint = Math.min(n7, 500);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)rowLayout);
        composite2.setLayoutData((Object)gridData);
        int n9 = 0;
        while (n9 < n4) {
            AssetReference assetReference = arrayList.get(n9);
            ImageInfo imageInfo = ImageInfo.grab(assetReference, assetReference);
            Rectangle rectangle = null;
            if (arrayList2 != null) {
                Position position = arrayList2.get(n9);
                rectangle = new Rectangle(position.x, position.y, n2, n3);
            }
            singleImageControl = new SingleImageControl(composite2, 2048, imageInfo, rectangle);
            ++n9;
        }
    }

    public static String getSizeString(IFile iFile) {
        return IDEResourceInfoUtils.getSizeString((IResource)iFile);
    }

    public static boolean verify(PropCnr propCnr, PropVerification propVerification) {
        boolean bl = false;
        LastVerified lastVerified = ((ILastVerified)propCnr).getLastVerified();
        AssetReference assetReference = (AssetReference)propCnr.getProp("fileName", AssetReference.class);
        String string = null;
        if (assetReference != null) {
            string = assetReference.getReference();
        }
        if (assetReference == null || string == null) {
            propVerification.add(new PropVerificationError(propCnr, "fileName", PropVerificationError.Severity.ERROR, "File name", "Missing file name", new String[0]));
        } else if (string.isEmpty()) {
            propVerification.add(new PropVerificationError("fileName", PropVerificationError.Severity.ERROR, "File name", (GProp)assetReference, "File name is empty", new String[0]));
        } else {
            FilePropCnr filePropCnr = (FilePropCnr)assetReference.getFileURIPropCnr();
            if (filePropCnr != null) {
                Object object;
                PropCnr propCnr2;
                boolean bl2 = false;
                string = filePropCnr.getFileName();
                if (!string.equals(lastVerified.fileName)) {
                    lastVerified.fileName = string;
                    bl2 = true;
                    lastVerified.againstBaseFile = null;
                    lastVerified.baseStamp = -1L;
                } else {
                    long l2 = filePropCnr.getModificationStamp();
                    if (l2 != lastVerified.stamp) {
                        bl2 = true;
                        lastVerified.againstBaseFile = null;
                        lastVerified.baseStamp = -1L;
                    }
                }
                LastVerified lastVerified2 = null;
                boolean bl3 = propCnr instanceof AbstractImageResolution;
                if (bl3 || propCnr instanceof ILastVerified) {
                    propCnr2 = propCnr.getParent();
                    while (propCnr2 != null && !(propCnr2 instanceof FilePropCnr)) {
                        if (propCnr2 instanceof ILastVerified) {
                            object = (ILastVerified)propCnr2;
                            lastVerified2 = object.getLastVerified();
                            if (lastVerified.againstBaseFile != null && lastVerified.againstBaseFile.equals((Object)lastVerified2.file) && lastVerified.baseStamp == lastVerified2.file.getModificationStamp()) break;
                            bl2 = true;
                            break;
                        }
                        propCnr2 = propCnr2.getParent();
                    }
                }
                lastVerified.file = filePropCnr.getIFile();
                if (bl2 && ImageHelper.a(propCnr, lastVerified, propVerification) && lastVerified2 != null && lastVerified2.success && lastVerified.success) {
                    propCnr2 = PropVerificationError.Severity.ERROR;
                    object = null;
                    if (bl3) {
                        if (lastVerified2.width > 0) {
                            double d2 = (double)lastVerified.width / (double)lastVerified2.width;
                            if ((double)lastVerified.height != d2 * (double)lastVerified2.height) {
                                object = "Device pixel ratio does not equally apply to width and height compared to default image";
                            } else if (d2 < 0.5 || d2 > 4.0) {
                                object = "Device pixel ratio is outside normal range (0.5 to 4.0)";
                                propCnr2 = PropVerificationError.Severity.WARNING;
                            }
                            ((AbstractImageResolution)propCnr).setDevicePixelRatio(Double.valueOf(d2));
                        }
                    } else if (lastVerified.width != lastVerified2.width) {
                        object = "Different width (" + lastVerified.width + ") compared to default image (" + lastVerified2.width + ")";
                    } else if (lastVerified.height != lastVerified2.height) {
                        object = "Different height (" + lastVerified.height + ") compared to default image (" + lastVerified2.height + ")";
                    }
                    if (object != null) {
                        propVerification.add(new PropVerificationError("fileName", (PropVerificationError.Severity)propCnr2, "Image file name", (GProp)propCnr, (String)object, new String[0]));
                    } else {
                        lastVerified.againstBaseFile = lastVerified2.file;
                        lastVerified.baseStamp = lastVerified2.stamp;
                    }
                }
            }
        }
        return bl;
    }

    private static boolean a(PropCnr propCnr, LastVerified lastVerified, PropVerification propVerification) {
        if (propCnr.isDisposed()) {
            return true;
        }
        Display display = Display.getDefault();
        if (display.getThread() != Thread.currentThread()) {
            boolean[] blArray = new boolean[1];
            display.syncExec(() -> {
                blArray[0] = ImageHelper.a(propCnr, lastVerified, propVerification);
            });
            return blArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        Image image = ImageHelper.loadImage(lastVerified.file, stringBuilder);
        lastVerified.stamp = lastVerified.file.getModificationStamp();
        lastVerified.success = false;
        if (image != null) {
            try {
                ImageData imageData = image.getImageData();
                int n2 = imageData.width;
                int n3 = imageData.height;
                if (n2 == 0) {
                    stringBuilder.append("image width in file is zero");
                } else if (n3 == 0) {
                    stringBuilder.append("image height in file is zero");
                } else {
                    if (propCnr.getInt("width") != n2) {
                        propCnr.setInt("width", n2);
                    }
                    if (propCnr.getInt("height") != n3) {
                        propCnr.setInt("height", n3);
                    }
                    lastVerified.success = true;
                    lastVerified.width = n2;
                    lastVerified.height = n3;
                }
            }
            finally {
                image.dispose();
            }
        }
        if (stringBuilder.length() == 0) {
            return true;
        }
        propVerification.add(new PropVerificationError("fileName", PropVerificationError.Severity.ERROR, "Image file name", (GProp)propCnr, "Image error: " + String.valueOf(stringBuilder), new String[0]));
        return false;
    }

    public static void flagVerification(PropCnr propCnr) {
        while (propCnr != null && !(propCnr instanceof FilePropCnr)) {
            if (propCnr instanceof AbstractImageDefinition) {
                PropHelper.queueVerify(propCnr);
                break;
            }
            propCnr = propCnr.getParent();
        }
    }

    public static int getTypeValue(String string) {
        if (string.equalsIgnoreCase("all")) {
            return -1;
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = IImageStyle.TYPES.length;
            while (--n3 >= 0) {
                if (string2.equals(IImageStyle.TYPES[n3])) break;
            }
            if (n3 < 0) {
                throw new InternalError("Invalid string '" + string + "' item: " + string2);
            }
            if (n3 <= 0) continue;
            n2 |= 1 << n3 - 1;
        }
        return n2;
    }

    public static String getTypeString(PropCnr propCnr) {
        Object object = "";
        int n2 = 1;
        int n3 = IImageStyle.TYPES.length;
        while (n2 < n3) {
            BoolProp boolProp = (BoolProp)propCnr.getProp(IImageStyle.TYPES[n2], BoolProp.class);
            if (boolProp != null) {
                if (!((String)object).isEmpty()) {
                    object = (String)object + ", ";
                }
                object = (String)object + a[boolProp.getBool() ? (n2 - 1) * 2 : (n2 - 1) * 2 + 1];
            }
            ++n2;
        }
        return ((String)object).isEmpty() ? "(default)" : object;
    }

    public static String getSize(LastVerified lastVerified) {
        return lastVerified.success ? lastVerified.width + " x " + lastVerified.height : "?";
    }
}

