/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class LocalTimeValue
extends TermporalAccessorValue<LocalTime> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.LocalTime;
    }

    @Override
    public Class<LocalTime> getValueClass() {
        return LocalTime.class;
    }

    @Override
    public String getDescription() {
        return "Time without time-zone in the ISO-8601 calendar system, such as 10:15:30";
    }

    @Override
    public LocalTime createDefault() {
        return LocalTime.MIDNIGHT;
    }

    @Override
    public LocalTime parse(String string) throws ParseException, Exception {
        try {
            return LocalTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalTime parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return LocalTime.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalTime convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof LocalTime) {
            return (LocalTime)object;
        }
        if (object instanceof Number) {
            return LocalTime.from(Instant.ofEpochMilli(((Number)object).longValue()));
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return offsetTime.toLocalTime();
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return localDateTime.toLocalTime();
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toLocalTime();
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toLocalTime();
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            int n2 = gregorianCalendar.get(11);
            int n3 = gregorianCalendar.get(12);
            int n4 = gregorianCalendar.get(13);
            int n5 = gregorianCalendar.get(14) % 1000;
            return LocalTime.of(n2, n3, n4, n5 * 1000000);
        }
        if (object instanceof Clock) {
            Clock clock = (Clock)object;
            return LocalTime.from(clock.instant());
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return LocalTime.of(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds(), (int)(date.getTime() % 1000L) * 1000000);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return LocalTime.from(Instant.ofEpochMilli(l2));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return LocalTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(LocalTime localTime, LocaleInfo localeInfo) {
        return localTime.toNanoOfDay() / 1000000L;
    }
}

