/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.RunMode;
import com.iizix.Size;
import com.iizix.event.GEvent;
import com.iizix.event.PropCnrEvent;
import com.iizix.event.PropValueEvent;
import com.iizix.event.RemoteEvent;
import com.iizix.image.ImageType;
import com.iizix.prop.Atom;
import com.iizix.prop.ByteArrayProp;
import com.iizix.prop.GProp;
import com.iizix.prop.GRect;
import com.iizix.prop.GSize;
import com.iizix.prop.ImageReference;
import com.iizix.prop.Int4Prop;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ReferenceString;
import com.iizix.prop.SizeProp;
import com.iizix.prop.StringProp;
import com.iizix.prop.image.ClientImageData;
import com.iizix.prop.image.IImageTarget;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.IUIImage2Listener;
import com.iizix.prop.ui.ImageOrientation;
import com.iizix.prop.ui.UIComp;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UIImage2
extends UIComp
implements IUIContextMenuOwner,
IUIFocusComp {
    static boolean a = false;
    public static final GSize DEFAULT_VIEWPORT_SIZE = new GSize(100, 100);
    public static final String DEFAULT_SUPPORTED_IMAGE_TYPES = ".jpg,.jpeg,image/jpeg,.png,image/png";
    private volatile GenericListener<IUIImage2Listener> a;
    private static final Set<String> a;
    private static final Set<String> b;

    static {
        a = Set.of("type", "name", "$value", "cx", "cy", "points", "zoom", "orient");
        b = Set.of("$icon", "$value", "type", "points", "zoom", "orient");
    }

    public UIImage2() {
    }

    public UIImage2(Atom atom) {
        super(atom);
    }

    public UIImage2(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public UIImage2 clone() {
        UIImage2 uIImage2 = (UIImage2)super.clone();
        return uIImage2;
    }

    @Override
    protected boolean shouldSerializeToXML(int n2, GProp<?> gProp) {
        return !a.contains(gProp.getPropName());
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return false;
    }

    private void d() {
        int n2;
        ImageType imageType;
        boolean bl = this.a;
        String string = this.getString("name");
        String string2 = this.getString("type");
        ByteArrayProp byteArrayProp = this.getProp(Atom.VALUE, ByteArrayProp.class);
        int n3 = this.getInt("cx");
        int n4 = this.getInt("cy");
        int n5 = this.getInt("orient", 1);
        double d2 = this.getNumber("zoom", 1.0);
        Int4Prop int4Prop = this.getProp("points", Int4Prop.class);
        if (string == null || string2 == null || byteArrayProp == null || n3 == 0 || n4 == 0 || n5 == 0 || d2 == 0.0 || int4Prop == null) {
            ILog.SEVERE(this.getClass(), "UImage2: missing property values for user selected image");
            return;
        }
        if (d2 <= 0.0) {
            ILog.SEVERE(this.getClass(), "UImage2: invalid zoom level = " + d2);
            return;
        }
        switch (string2) {
            case "png": {
                imageType = ImageType.PNG;
                break;
            }
            case "jpeg": {
                imageType = ImageType.JPEG;
                break;
            }
            default: {
                ILog.SEVERE(this.getClass(), "UImage2: unknown image type for user selected image: \"" + string2 + "\"");
                return;
            }
        }
        Object object = byteArrayProp.getByteArray();
        if (object == null) {
            ILog.SEVERE(this.getClass(), "UImage2: missing image data for user selected image, property value \"value\" as ByteArrayProp");
            return;
        }
        ImageOrientation imageOrientation = ImageOrientation.from(n5);
        if (imageOrientation == ImageOrientation.UNDEFINED) {
            ILog.SEVERE(this.getClass(), "UImage2: undefined image orientation for user selected image");
            return;
        }
        int n6 = (Integer)int4Prop.getPropValue(0);
        int n7 = (Integer)int4Prop.getPropValue(1);
        int n8 = (Integer)int4Prop.getPropValue(2);
        int n9 = (Integer)int4Prop.getPropValue(3);
        int n10 = Math.min(n6, n8);
        GRect gRect = new GRect(n10, n2 = Math.min(n7, n9), Math.max(n6, n8) - n10, Math.max(n7, n9) - n2);
        if (gRect.getCX() == 0 || gRect.getCY() == 0) {
            ILog.SEVERE(this.getClass(), "UImage2: crop rectangle size is zero = " + String.valueOf(gRect));
            return;
        }
        boolean bl2 = this.getBool("circle");
        System.err.println("UIImage2: onImageSelection(name=" + string + ",type=" + String.valueOf((Object)imageType) + ",dataSize=" + ((Object)object).length + ",width=" + n3 + ",height=" + n4 + ",orient=" + String.valueOf((Object)imageOrientation) + ",zoom=" + d2 + ",rect=" + String.valueOf(gRect) + ",circle=" + bl2);
        if (bl != null) {
            bl.forEach(arg_0 -> this.a(string, imageType, (byte[])object, n3, n4, imageOrientation, d2, gRect, bl2, arg_0));
        }
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        block29: {
            Object object;
            super.onEventSelf(gEvent);
            if (this.isDisposed()) {
                return;
            }
            if (RunMode.isDesignerRunMode() && this.isPropCommunicating()) {
                return;
            }
            if (a) {
                System.err.println("UImage2: event[" + gEvent.getEventTarget().getPropName() + "] - " + String.valueOf(gEvent));
            }
            if (!gEvent.isPropertyChangeIn(this)) {
                return;
            }
            String string = gEvent.getEventTarget().getPropName();
            if (!b.contains(string)) break block29;
            Object object2 = null;
            switch (gEvent.getEventID()) {
                case 1: {
                    object = (PropValueEvent)gEvent;
                    object2 = ((PropValueEvent)object).getNewValue();
                    break;
                }
                case 2: {
                    object2 = ((PropCnrEvent)gEvent).getProperty().getPropValue();
                }
            }
            object = this.a;
            switch (string) {
                case "$icon": {
                    IImageTarget iImageTarget;
                    IImageTarget iImageTarget2 = iImageTarget = object2 != null ? (IImageTarget)((ImageReference)object2).getTargetReference() : null;
                    if (object == null) break;
                    ((GenericListener)object).forEach(iUIImage2Listener -> iUIImage2Listener.onImageChanged(this, iImageTarget));
                    break;
                }
                case "$value": {
                    if (!a) break;
                    if (object2 == null) {
                        System.err.println("UImage2: $value removed");
                        break;
                    }
                    System.err.println("UImage2: $value added, image file size = " + ((byte[])object2).length);
                    break;
                }
                case "points": {
                    int n2;
                    if (object2 == null) break;
                    Object[] objectArray = (Object[])object2;
                    int n3 = objectArray[0] != null ? (Integer)objectArray[0] : 0;
                    int n4 = objectArray[1] != null ? (Integer)objectArray[1] : n3;
                    int n5 = objectArray[2] != null ? (Integer)objectArray[2] : n3;
                    int n6 = objectArray[3] != null ? (Integer)objectArray[3] : n3;
                    int n7 = objectArray[4] != null ? (Integer)objectArray[4] : n3;
                    int n8 = Math.min(n4, n6);
                    GRect gRect = new GRect(n8, n2 = Math.min(n5, n7), Math.max(n4, n6) - n8, Math.max(n5, n7) - n2);
                    if (gRect.getCX() == 0 || gRect.getCY() == 0) {
                        ILog.SEVERE(this.getClass(), "UImage2: crop rectangle size is zero = " + String.valueOf(gRect));
                        return;
                    }
                    if (!a) break;
                    System.err.println("UImage2: crop = " + String.valueOf(gRect));
                    break;
                }
                case "zoom": {
                    if (!a || object2 == null) break;
                    double d2 = (Double)object2;
                    System.err.println("UImage2: zoom = " + d2);
                    break;
                }
                case "orient": {
                    if (!a || object2 == null) break;
                    ImageOrientation imageOrientation = ImageOrientation.from((Integer)object2);
                    System.err.println("UImage2: orientation = " + String.valueOf(object2) + " -> " + String.valueOf((Object)imageOrientation));
                }
            }
        }
    }

    @Override
    public void onRemoteEvent(RemoteEvent remoteEvent) {
        switch (remoteEvent.getLocalID()) {
            case 1: {
                this.d();
                break;
            }
            case 2: {
                boolean bl = this.a;
                if (bl != null) {
                    int n2;
                    Int4Prop int4Prop = this.getProp("points", Int4Prop.class);
                    if (int4Prop == null) {
                        ILog.SEVERE(this.getClass(), "UImage2: changed - crop rectangle missing");
                        return;
                    }
                    int n3 = (Integer)int4Prop.getPropValue(0);
                    int n4 = (Integer)int4Prop.getPropValue(1);
                    int n5 = (Integer)int4Prop.getPropValue(2);
                    int n6 = (Integer)int4Prop.getPropValue(3);
                    int n7 = Math.min(n3, n5);
                    GRect gRect = new GRect(n7, n2 = Math.min(n4, n6), Math.max(n3, n5) - n7, Math.max(n4, n6) - n2);
                    if (gRect.getCX() == 0 || gRect.getCY() == 0) {
                        ILog.SEVERE(this.getClass(), "UImage2: changed - crop rectangle size is zero = " + String.valueOf(gRect));
                        return;
                    }
                    ImageOrientation imageOrientation = this.getImageOrientation();
                    if (imageOrientation == ImageOrientation.UNDEFINED) {
                        ILog.SEVERE(this.getClass(), "UImage2: changed - undefined image orientation");
                        return;
                    }
                    double d2 = this.getNumber("zoom", 1.0);
                    if (d2 == 0.0) {
                        ILog.SEVERE(this.getClass(), "UImage2: changed - zoom is zero");
                        return;
                    }
                    bl.forEach(iUIImage2Listener -> iUIImage2Listener.onImageModified(this, imageOrientation, d2, gRect));
                }
                return;
            }
        }
        super.onRemoteEvent(remoteEvent);
    }

    @Override
    public boolean mustHaveWidth() {
        return true;
    }

    @Override
    public boolean mustHaveHeight() {
        return true;
    }

    @Override
    public boolean mustHaveExplicitWidth() {
        return true;
    }

    @Override
    public boolean mustHaveExplicitHeight() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillY() {
        return true;
    }

    @Override
    public boolean canAlignX() {
        return false;
    }

    @Override
    public boolean canAlignY() {
        return false;
    }

    @Override
    public Size getApproximateSize() {
        IImageTarget iImageTarget = this.getImage();
        if (iImageTarget != null) {
            ClientImageData clientImageData = iImageTarget.getClientImageData();
            return new Size(clientImageData.width, clientImageData.height);
        }
        return new Size(200, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(IUIImage2Listener iUIImage2Listener) {
        Object object = this.a;
        if (object == null) {
            UIImage2 uIImage2 = this;
            synchronized (uIImage2) {
                object = this.a;
                if (object == null) {
                    object = new GenericListener<IUIImage2Listener>(IUIImage2Listener.class);
                }
            }
        }
        return object.addListener(iUIImage2Listener);
    }

    public boolean removeListener(IUIImage2Listener iUIImage2Listener) {
        boolean bl = this.a;
        return bl != null ? bl.removeListener(iUIImage2Listener) : false;
    }

    public IImageTarget getImage() {
        ImageReference imageReference = this.getProp(Atom.ICON, ImageReference.class);
        return imageReference != null ? (IImageTarget)imageReference.getTargetReference() : null;
    }

    public boolean setImage(IImageTarget iImageTarget) {
        boolean bl;
        if (iImageTarget == null) {
            bl = this.removeProp2(Atom.ICON);
            bl |= this.removeProp2(Atom.VALUE);
            bl |= this.removeProp2("name");
        } else {
            if (!iImageTarget.getClientImageData().isBitmap()) {
                throw new IllegalArgumentException("Image must be of bitmap type");
            }
            bl = this.setPropValue(Atom.ICON, new ReferenceString(iImageTarget.getReferencePropName()), ImageReference.class);
            ImageReference imageReference = this.getProp(Atom.ICON, ImageReference.class);
            if (imageReference != null) {
                imageReference.setImage(iImageTarget);
            }
            String string = null;
            String string2 = iImageTarget.getClientImageData().getDefaultResource();
            int n2 = string2.lastIndexOf(46);
            if (n2++ >= 0 && string2.indexOf(47, n2) < 0) {
                String string3 = string2.substring(n2).toLowerCase(Locale.ENGLISH);
                if (string3.equals("png")) {
                    string = string3;
                } else if (string3.equals("jpg") || string3.equals("jpeg")) {
                    string = "jpeg";
                }
            }
            if (string != null) {
                this.setString("type", string);
            } else {
                this.removeProp2("type");
            }
            this.removeProp2(Atom.VALUE);
            this.removeProp2("name");
            this.removeProp2("width");
            this.removeProp2("height");
            this.removeProp2("orient");
            this.removeProp2("points");
        }
        return bl;
    }

    public boolean setViewport(GSize gSize) {
        if (gSize == null) {
            return this.removeProp2("view");
        }
        int n2 = gSize.getCX();
        if (n2 < 10 || n2 > 99999) {
            throw new IllegalArgumentException("Width range is invalid (10 to 99999): " + n2);
        }
        n2 = gSize.getCY();
        if (n2 < 10 || n2 > 99999) {
            throw new IllegalArgumentException("Height range is invalid (10 to 99999): " + n2);
        }
        return this.setProp2(new SizeProp(Atom.get("view"), gSize));
    }

    public GSize getViewport() {
        GSize gSize = this.getPropValue("view", GSize.class);
        return gSize != null ? gSize : DEFAULT_VIEWPORT_SIZE;
    }

    public double getZoomFactor() {
        return this.getNumber("zoom", 1.0);
    }

    public boolean setZoomFactor(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Invalid zoom factor: " + d2);
        }
        return this.setNumber("zoom", d2);
    }

    public boolean isCircle() {
        return this.getBool("circle");
    }

    public boolean setCircle(boolean bl) {
        return bl ? this.setBool("circle", true) : this.removeProp2("circle");
    }

    public int getMinimumWidthOrHeight() {
        return this.getInt("min", 50);
    }

    public int getMaximumWidthOrHeight() {
        return this.getInt("max", 4096);
    }

    public boolean setMinMaxWidthOrHeight(int n2, int n3) {
        if (n2 == 0) {
            n2 = 50;
        } else if (n2 < 0) {
            throw new IllegalArgumentException("minimum < 0: " + n2);
        }
        if (n3 == 0) {
            n3 = 4096;
        } else if (n3 < 0) {
            throw new IllegalArgumentException("maximum < 0: " + n3);
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("minimum(" + n2 + ") > maximum(" + n3 + ")");
        }
        boolean bl = n2 != 50 ? this.setInt("min", n2) : this.removeProp2("min");
        return bl |= n2 != 4096 ? this.setInt("max", n2) : this.removeProp2("max");
    }

    public int getMaximumFileSize() {
        return this.getInt("size", 0x500000);
    }

    public boolean setMaximumFileSize(int n2) {
        if (n2 <= 0 || n2 > 0x800000) {
            throw new IllegalArgumentException("Size range 1 to 8_388_608: " + n2);
        }
        return n2 != 0x500000 ? this.setInt("size", n2) : this.removeProp2("size");
    }

    public byte[] getImageFileData() {
        return this.getPropValue(Atom.VALUE, byte[].class);
    }

    public boolean setImageFileData(String string, byte[] byArray) {
        if (byArray == null) {
            boolean bl = this.removeProp2(Atom.VALUE);
            bl |= this.removeProp2(Atom.ICON);
            bl |= this.removeProp2("name");
            bl |= this.removeProp2("width");
            bl |= this.removeProp2("height");
            bl |= this.removeProp2("orient");
            bl |= this.removeProp2("points");
            return bl |= this.removeProp2("zoom");
        }
        if (string == null) {
            throw new NullPointerException("fileName is null");
        }
        ByteArrayProp byteArrayProp = new ByteArrayProp(Atom.VALUE, byArray);
        return this.setProp2(byteArrayProp);
    }

    public int getImageWidth() {
        return this.getInt("width");
    }

    public int getImageHeight() {
        return this.getInt("height");
    }

    public ImageType getImageType() {
        block10: {
            String string = this.getString("type");
            if (string == null) break block10;
            switch (string) {
                case "png": {
                    return ImageType.PNG;
                }
                case "jpeg": {
                    return ImageType.JPEG;
                }
            }
        }
        return ImageType.UNKNOWN;
    }

    public String getSupportedImageTypes() {
        String string = this.getString("types");
        if (string == null || string.isEmpty()) {
            string = DEFAULT_SUPPORTED_IMAGE_TYPES;
        }
        return string;
    }

    public boolean setSupportedImageTypes(String string) {
        if (string == null || string.isEmpty()) {
            return this.removeProp2("types");
        }
        if (!string.toLowerCase(Locale.ENGLISH).equals(string)) {
            throw new IllegalArgumentException("Image type string not in lower case: " + string);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String[] stringArray = string.split(",");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            switch (string2 = stringArray[n3]) {
                case "image/jpeg": 
                case "image/png": 
                case ".jpg": 
                case ".png": 
                case ".jpeg": {
                    if (linkedHashSet.add(string2)) break;
                    throw new IllegalArgumentException("Image type '" + string2 + "' is already specified in '" + string + "'");
                }
                default: {
                    if (string2.startsWith(".")) {
                        throw new IllegalArgumentException("Unsupported image file extension: " + string2);
                    }
                    throw new IllegalArgumentException("Unsupported image media type: " + string2);
                }
            }
            ++n3;
        }
        string = String.join((CharSequence)",", linkedHashSet);
        return string.equals(DEFAULT_SUPPORTED_IMAGE_TYPES) ? this.removeProp2("types") : this.setString("types", string);
    }

    public ImageOrientation getImageOrientation() {
        return ImageOrientation.from(this.getInt("orient", 1));
    }

    public String getOriginalImageFileName() {
        return this.getString("name");
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        int n2;
        double d2;
        double d3;
        Object object;
        Object object2;
        Object object3;
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = this.getProp("types", StringProp.class);
        if (stringProp != null) {
            object3 = PropVerificationError.Severity.WARNING;
            object2 = null;
            HashSet<String> hashSet = new HashSet<String>();
            object = stringProp.getString("").split(",");
            int n3 = ((String[])object).length;
            int n4 = 0;
            while (n4 < n3) {
                String string = object[n4];
                if (string.isEmpty()) {
                    object2 = "Image type is empty";
                    object3 = PropVerificationError.Severity.ERROR;
                    break;
                }
                if (!string.equals(string.toLowerCase(Locale.ENGLISH))) {
                    object2 = "Image type '" + string + "' should be specified in lower case";
                    break;
                }
                if (string.charAt(0) == '.') {
                    if (ImageType.fromExtension(string) == null) {
                        object2 = "Image file extension '" + string + "' is unknown";
                        break;
                    }
                    if (!hashSet.add(string)) {
                        object2 = "Image file extension '" + string + "' is already specified";
                        break;
                    }
                } else {
                    if (ImageType.fromExtension(string) == null) {
                        object2 = "Unknown image media type '" + string + "'";
                        break;
                    }
                    if (!hashSet.add(string)) {
                        object2 = "Media type '" + string + "' is already specified";
                        break;
                    }
                }
                ++n4;
            }
            if (object2 != null && hashSet.isEmpty()) {
                object2 = "At least one of the image type or file extension must be specified";
                object3 = PropVerificationError.Severity.ERROR;
            }
            if (object2 != null) {
                propVerification.add(new PropVerificationError("types", (PropVerificationError.Severity)((Object)object3), "Supported image types", stringProp, (String)object2, new String[]{"DeleteProperty"}));
            }
        }
        if ((d3 = (double)((object3 = this.getProp("min", IntProp.class)) != null ? ((IntProp)object3).getInt(50) : 50)) >= (d2 = (double)((object2 = this.getProp("max", IntProp.class)) != null ? ((IntProp)object2).getInt(4096) : 4096))) {
            if (object2 != null) {
                propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.ERROR, "Maximum width/height", (GProp<?>)object2, "Maximum value (" + d2 + ") must be larger than minimum value (" + d3 + ")", "DeleteProperty"));
            } else if (object3 != null) {
                propVerification.add(new PropVerificationError("range", PropVerificationError.Severity.ERROR, "Minimum width/height", (GProp<?>)object3, "Minimum value (" + d3 + ") must be smaller than maximum value (" + d2 + ")", "DeleteProperty"));
            }
        }
        if (object3 != null && d3 < 0.0) {
            propVerification.add(new PropVerificationError("min", PropVerificationError.Severity.ERROR, "Minimum width/height", (GProp<?>)object3, "Minimum value (" + d3 + ") cannot be negative", "DeleteProperty"));
        }
        if (object2 != null && (d2 < 0.0 || d2 > 50000.0)) {
            propVerification.add(new PropVerificationError("max", PropVerificationError.Severity.ERROR, "Maximum width/height", (GProp<?>)object3, "Maximum value (" + d3 + ") range is 100 to 50000", "DeleteProperty"));
        }
        if ((object = this.getProp("size", IntProp.class)) != null && ((n2 = ((IntProp)object).getInt(0x500000)) < 0 || n2 > 0x800000)) {
            propVerification.add(new PropVerificationError("size", PropVerificationError.Severity.ERROR, "Maximum file size", (GProp<?>)object, "Maximum file size (" + n2 + ") value range is 0 to 8 MB (8_388_608 bytes)", "DeleteProperty"));
        }
        return true;
    }

    private /* synthetic */ void a(String string, ImageType imageType, byte[] byArray, int n2, int n3, ImageOrientation imageOrientation, double d2, GRect gRect, boolean bl, IUIImage2Listener iUIImage2Listener) {
        iUIImage2Listener.onImageSelection(this, string, imageType, byArray, n2, n3, imageOrientation, d2, gRect, bl);
    }
}

