/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.app;

import com.iizigo.app.EclipseIPathFile;
import com.iizix.app.builder.IIDirectory;
import com.iizix.app.builder.IIResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EclipseIPathDirectory
implements IIDirectory {
    private final IPath a;
    private IFileStore a;
    private final IFileInfo a;
    private File a;

    public EclipseIPathDirectory(IPath iPath, IFileStore iFileStore) throws IOException {
        this.a = iPath.makeAbsolute();
        this.a = iFileStore != null ? iFileStore : EFS.getLocalFileSystem().getStore(iPath);
        this.a = this.a.fetchInfo();
        if (!this.a.exists()) {
            throw new FileNotFoundException("File '" + String.valueOf(iPath.makeAbsolute()) + "' is not found");
        }
        if (!this.a.isDirectory()) {
            throw new IOException("File '" + String.valueOf(iPath.makeAbsolute()) + "' is not a directory");
        }
    }

    public String getFullPath() {
        return this.a.toPortableString();
    }

    public File getFile(Object object) throws IOException {
        if (this.a == null) {
            try {
                this.a = this.a.toLocalFile(4096, (IProgressMonitor)object).getCanonicalFile();
            }
            catch (CoreException coreException) {
                throw new IOException("Failed getting file '" + this.a.getName() + "'", coreException);
            }
        }
        return this.a;
    }

    public List<IIResource> listDirectory(Object object) throws IOException {
        ArrayList<IIResource> arrayList = new ArrayList<IIResource>();
        IProgressMonitor iProgressMonitor = (IProgressMonitor)object;
        try {
            IFileStore[] iFileStoreArray = this.a.childStores(0, iProgressMonitor);
            int n2 = iFileStoreArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IFileStore iFileStore = iFileStoreArray[n3];
                IPath iPath = this.a.append(iFileStore.getName());
                IFileInfo iFileInfo = this.a.fetchInfo(0, iProgressMonitor);
                if (iFileInfo.exists()) {
                    if (iFileInfo.isDirectory()) {
                        arrayList.add((IIResource)new EclipseIPathDirectory(iPath, iFileStore));
                    } else {
                        arrayList.add((IIResource)new EclipseIPathFile(iPath, iFileStore));
                    }
                }
                ++n3;
            }
        }
        catch (CoreException coreException) {
            throw new IOException("Failed getting directory '" + this.getFullPath() + "' contents");
        }
        return arrayList;
    }

    public boolean isDirectory() {
        return true;
    }

    public String getName() {
        return this.a.getName();
    }

    public boolean equals(Object object) {
        try {
            IIResource iIResource;
            return object instanceof IIResource && (iIResource = (IIResource)object).getFullPath().equals(this.getFullPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

