/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeCompletionProposal;
import org.eclipse.pde.internal.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.swt.graphics.Image;

public class BuildPropertiesContentAssistProcessor
extends TypePackageCompletionProcessor {
    protected PDESourcePage fSourcePage;

    public BuildPropertiesContentAssistProcessor(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = this.fSourcePage.getDocumentProvider().getDocument((Object)this.fSourcePage.getInputContext().getInput());
        try {
            Field[] properties;
            int lineNum = doc.getLineOfOffset(offset);
            int lineStart = doc.getLineOffset(lineNum);
            String value = doc.get(lineStart, offset - lineStart);
            ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
            Field[] fieldArray = properties = IBuildPropertiesConstants.class.getFields();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    String element;
                    Field f = fieldArray[n2];
                    String key = f.getName();
                    try {
                        element = (String)f.get(key);
                    }
                    catch (IllegalAccessException e) {
                        break block6;
                    }
                    if (element.regionMatches(true, 0, value, 0, value.length())) {
                        Image img = this.getImage(element);
                        TypeCompletionProposal proposal = new TypeCompletionProposal(element, img, element, lineStart, value.length());
                        completions.add(proposal);
                    }
                }
                ++n2;
            }
            return (ICompletionProposal[])completions.toArray(ICompletionProposal[]::new);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public Image getImage(String element) {
        ImageDescriptor desc = switch (element) {
            case ".folder.", "source.", "src.additionalRoots", "bin.includes", "folder.", "src.includes", "link", "root", ".link", "root.", "javacDefaultEncoding.", ".permissions.", "bin.excludes", "javacCustomEncodings.", "permissions", "sourceFileExtensions", "src.excludes" -> PDEPluginImages.DESC_CATEGORY_OBJ;
            case ".jar", "jars.compile.order", "jars.extra.classpath" -> PDEPluginImages.DESC_JAR_LIB_OBJ;
            case "javacProjectSettings" -> PDEPluginImages.DESC_SETTINGS_OBJ;
            case "javacErrors." -> PDEPluginImages.DESC_ERROR_ST_OBJ;
            case "significantVersionDigits", "generatedVersionLength" -> PDEPluginImages.DESC_INFO_ST_OBJ;
            case "javacWarnings." -> PDEPluginImages.DESC_ALERT_OBJ;
            case "jre.compilation.profile" -> PDEPluginImages.DESC_TARGET_ENVIRONMENT;
            case "manifest." -> PDEPluginImages.DESC_FOLDER_OBJ;
            default -> PDEPluginImages.DESC_DEFAULT_OBJ;
        };
        return desc != null ? desc.createImage() : null;
    }
}

