/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.Arrays;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected final int targetOffset;
    protected final String methodName;
    protected final int paramCount;
    protected final Class<?>[] paramTypes;
    protected boolean useExactMatch = false;

    public CallMethodRule(String methodName, int paramCount) {
        this(0, methodName, paramCount);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            this.paramTypes = new Class[]{String.class};
        } else {
            this.paramTypes = new Class[paramCount];
            Arrays.fill(this.paramTypes, String.class);
        }
    }

    public CallMethodRule(String methodName) {
        this(0, methodName, 0, null);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, Class<?>[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            Arrays.fill(this.paramTypes, String.class);
        } else {
            this.paramTypes = new Class[paramTypes.length];
            System.arraycopy(paramTypes, 0, this.paramTypes, 0, this.paramTypes.length);
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] parameters = new Object[this.paramCount];
            this.digester.pushParams(parameters);
        }
    }

    @Override
    public void body(String namespace, String name, String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim().intern();
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        CharSequence sb;
        Object[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
            if (this.digester.log.isTraceEnabled()) {
                int size = parameters.length;
                for (int i = 0; i < size; ++i) {
                    this.digester.log.trace("[CallMethodRule](" + i + ")" + parameters[i]);
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new Object[]{this.bodyText};
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Object param = parameters[i];
            paramValues[i] = null == param && !this.paramTypes[i].isPrimitive() ? null : (param instanceof String && !String.class.isAssignableFrom(this.paramTypes[i]) ? IntrospectionUtils.convert((String)parameters[i], this.paramTypes[i]) : parameters[i]);
        }
        Object target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            sb = "[CallMethodRule]{" + this.digester.match + "} Call target is null (targetOffset=" + this.targetOffset + ",stackdepth=" + this.digester.getCount() + ')';
            throw new SAXException((String)sb);
        }
        if (this.digester.log.isTraceEnabled()) {
            sb = new StringBuilder("[CallMethodRule]{");
            ((StringBuilder)sb).append(this.digester.match);
            ((StringBuilder)sb).append("} Call ");
            ((StringBuilder)sb).append(target.getClass().getName());
            ((StringBuilder)sb).append('.');
            ((StringBuilder)sb).append(this.methodName);
            ((StringBuilder)sb).append('(');
            for (int i = 0; i < paramValues.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)sb).append(',');
                }
                if (paramValues[i] == null) {
                    ((StringBuilder)sb).append("null");
                } else {
                    ((StringBuilder)sb).append(paramValues[i].toString());
                }
                ((StringBuilder)sb).append('/');
                if (this.paramTypes[i] == null) {
                    ((StringBuilder)sb).append("null");
                    continue;
                }
                ((StringBuilder)sb).append(this.paramTypes[i].getName());
            }
            ((StringBuilder)sb).append(')');
            this.digester.log.trace(((StringBuilder)sb).toString());
        }
        Object result = IntrospectionUtils.callMethodN(target, this.methodName, paramValues, this.paramTypes);
        this.processMethodCallResult(result);
        StringBuilder code = this.digester.getGeneratedCode();
        if (code != null) {
            code.append(this.digester.toVariableName(target)).append('.').append(this.methodName);
            code.append('(');
            for (int i = 0; i < paramValues.length; ++i) {
                if (i > 0) {
                    code.append(", ");
                }
                if (this.bodyText != null) {
                    code.append("\"").append(IntrospectionUtils.escape(this.bodyText)).append("\"");
                    continue;
                }
                if (paramValues[i] instanceof String) {
                    code.append("\"").append(IntrospectionUtils.escape(paramValues[i].toString())).append("\"");
                    continue;
                }
                code.append(this.digester.toVariableName(paramValues[i]));
            }
            code.append(");");
            code.append(System.lineSeparator());
        }
    }

    @Override
    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object result) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i].getName());
            }
        }
        sb.append('}');
        sb.append(']');
        return sb.toString();
    }
}

