/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.astview.views.DynamicAttributeProperty;
import org.eclipse.jdt.astview.views.DynamicBindingProperty;
import org.eclipse.jdt.astview.views.ExceptionAttribute;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class TrayLabelProvider
extends LabelProvider
implements IColorProvider {
    private Color fBlue;
    private Color fRed;
    private Color fWidgetForeground;
    private Object fViewerElement;

    public TrayLabelProvider() {
        Display display = Display.getCurrent();
        this.fRed = display.getSystemColor(3);
        this.fBlue = display.getSystemColor(10);
        this.fWidgetForeground = display.getSystemColor(21);
    }

    public void setViewerElement(Object viewerElement) {
        if (this.fViewerElement != viewerElement) {
            this.fViewerElement = viewerElement;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public String getText(Object obj) {
        if (obj instanceof DynamicBindingProperty) {
            DynamicBindingProperty dynamicBindingProperty = (DynamicBindingProperty)obj;
            dynamicBindingProperty.setViewerElement(this.fViewerElement instanceof Binding ? (Binding)this.fViewerElement : null);
            return dynamicBindingProperty.getLabel();
        }
        if (obj instanceof DynamicAttributeProperty) {
            DynamicAttributeProperty dynamicAttributeProperty = (DynamicAttributeProperty)obj;
            dynamicAttributeProperty.setViewerElement(this.fViewerElement);
            return dynamicAttributeProperty.getLabel();
        }
        if (obj instanceof ASTAttribute) {
            return ((ASTAttribute)obj).getLabel();
        }
        if (obj instanceof ASTNode) {
            return Signature.getSimpleName((String)obj.getClass().getName());
        }
        return "";
    }

    public Image getImage(Object obj) {
        if (obj instanceof DynamicBindingProperty) {
            DynamicBindingProperty dynamicBindingProperty = (DynamicBindingProperty)obj;
            dynamicBindingProperty.setViewerElement(this.fViewerElement instanceof Binding ? (Binding)this.fViewerElement : null);
            return dynamicBindingProperty.getImage();
        }
        if (obj instanceof DynamicAttributeProperty) {
            DynamicAttributeProperty dynamicAttributeProperty = (DynamicAttributeProperty)obj;
            dynamicAttributeProperty.setViewerElement(this.fViewerElement);
            return dynamicAttributeProperty.getImage();
        }
        if (obj instanceof ASTAttribute) {
            return ((ASTAttribute)obj).getImage();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.fViewerElement = null;
    }

    public Color getForeground(Object element) {
        if (element instanceof Binding) {
            return this.fBlue;
        }
        if (element instanceof ExceptionAttribute) {
            if (element instanceof DynamicBindingProperty) {
                ((DynamicBindingProperty)element).setViewerElement(this.fViewerElement instanceof Binding ? (Binding)this.fViewerElement : null);
            } else if (element instanceof DynamicAttributeProperty) {
                ((DynamicAttributeProperty)element).setViewerElement(this.fViewerElement);
            }
            if (((ExceptionAttribute)element).getException() == null) {
                return this.fWidgetForeground;
            }
            return this.fRed;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

