/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.image.prop.ImageDesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.IPropUndoContext;
import com.iizix.Utilities;
import com.iizix.js.JSFiles;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.SVGDefinition;
import com.iizix.prop.image.SVGInfo;
import com.iizix.swt.SWTHelper;
import java.io.File;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorSVGDefinition
extends SVGDefinition
implements IEditorImage,
IPropDesigner,
IPropUndoContext {
    private ImageDesignerProp a;
    private final UndoContext a = new ImageDesignerProp((PropCnr)this);

    public EditorSVGDefinition() {
    }

    public EditorSVGDefinition(Atom atom) {
        super(atom);
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageSVGDefinition;
    }

    @Override
    public String getCNType() {
        return "SVG definition";
    }

    @Override
    public String getCNText(int n2) {
        if (n2 < 0) {
            return null;
        }
        FilePropCnr filePropCnr = (FilePropCnr)this.getParent(FilePropCnr.class);
        return filePropCnr != null ? filePropCnr.getDesigner().getCNText(0) : "SVG definition";
    }

    @Override
    public Composite createTooltip(Composite composite) {
        String string;
        FilePropCnr filePropCnr;
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Font font = applicationUI.getBoldFont();
        int n2 = applicationUI.s8();
        int n3 = n2 / 2;
        int n4 = applicationUI.s10();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = n3 / 2;
        gridLayout.marginHeight = n3;
        gridLayout.horizontalSpacing = gridLayout.marginWidth = n2;
        composite2.setLayout((Layout)gridLayout);
        CLabel cLabel = new CLabel(composite2, 0);
        cLabel.setText("SVG definition:");
        cLabel.setFont(font);
        cLabel.setImage(this.getCNImage());
        cLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        String string2 = this.getCNText(0);
        if (string2 != null) {
            label.setText(string2.replace("&", "&&"));
        }
        GridData gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.heightHint = n4;
        label = new Label(composite2, 258);
        label.setLayoutData((Object)gridData);
        File file = null;
        SVGInfo sVGInfo = null;
        String string3 = null;
        int n5 = 0;
        int n6 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        AssetReference assetReference = this.getAssetReference();
        if (assetReference != null && (filePropCnr = (FilePropCnr)assetReference.getTargetReference()) != null) {
            file = filePropCnr.getIFile().getFullPath().toFile();
            sVGInfo = this.getSVGInfo();
            if (sVGInfo != null) {
                d2 = sVGInfo.getWidth();
                d3 = sVGInfo.getHeight();
                if (d2 < 400.0 && d3 < 400.0) {
                    n5 = (int)Math.ceil(d2);
                    n6 = (int)Math.ceil(d3);
                } else if (d2 > d3) {
                    n5 = 400;
                    n6 = (int)Math.ceil(d3 * 400.0 / Math.max(1.0, d2));
                    sVGInfo.setScale(400, n6);
                } else {
                    n5 = (int)Math.ceil(d2 * 400.0 / Math.max(1.0, d3));
                    n6 = 400;
                    sVGInfo.setScale(n5, 400);
                }
                string3 = sVGInfo.getSVGForHTML();
            }
        }
        int n7 = n3;
        if (string3 != null) {
            string = JSFiles.getFileUrl((String)"svgDefinition/square-transparent-bg.png");
            String string4 = "<!DOCTYPE html><html><head><style>html,body{width:100%;height:100%;overflow:hidden;margin:0;padding:0;background-color:#fff;}#a{border:1px solid #a0a0a0;padding:5px}#b{background-image:url('" + string + "');width:" + n5 + "px;height:" + n6 + "px}</style></head><body><div id=a><div id=b>" + string3 + "</div></div></body></html>";
            n5 = applicationUI.cx(n5 + 8);
            n6 = applicationUI.cy(n6 + 8);
            gridData = new GridData(16384, 128, false, false, 2, 1);
            gridData.verticalIndent = n3;
            gridData.widthHint = n5;
            gridData.heightHint = n6;
            Browser browser = SWTHelper.createBrowser(composite2, applicationUI.widgetBackground);
            browser.setLayoutData((Object)gridData);
            browser.setText(string4);
            browser.setSize(n5, n6);
            n7 = n2;
        }
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = n7;
        label = new Label(composite2, 0);
        label.setText("ID:");
        label.setLayoutData((Object)gridData);
        gridData = new GridData(16384, 0x1000000, false, false);
        gridData.verticalIndent = n7;
        label = new Label(composite2, 0);
        label.setText(this.getPropName().replace("&", "&&"));
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("Reference:");
        label = new Label(composite2, 0);
        label.setText(this.getReferencePropName().replace("&", "&&"));
        string = this.getString(Atom.DESCR);
        if (string != null) {
            label = new Label(composite2, 0);
            label.setText("Description:");
            label = new Label(composite2, 0);
            label.setText(string.replace("&", "&&"));
        }
        if (assetReference != null) {
            label = new Label(composite2, 0);
            label.setText("File reference:");
            label = new Label(composite2, 0);
            label.setText(assetReference.getReference().replace("&", "&&"));
        }
        n7 = n2;
        if (string3 != null) {
            gridData = new GridData(16384, 0x1000000, false, false);
            gridData.verticalIndent = n2;
            label = new Label(composite2, 0);
            label.setText("SVG size in HTML:");
            label.setLayoutData((Object)gridData);
            gridData = new GridData(16384, 0x1000000, false, false);
            gridData.verticalIndent = n2;
            label = new Label(composite2, 0);
            label.setText(Activator.getByteSize(string3.length()));
            label.setLayoutData((Object)gridData);
            n7 = n3;
        }
        if (sVGInfo != null) {
            gridData = new GridData(16384, 0x1000000, false, false);
            gridData.verticalIndent = n7;
            label = new Label(composite2, 0);
            label.setLayoutData((Object)gridData);
            label.setText("Width:");
            gridData = new GridData(16384, 0x1000000, false, false);
            gridData.verticalIndent = n7;
            label = new Label(composite2, 0);
            label.setLayoutData((Object)gridData);
            label.setText(Utilities.getShortestDouble((double)d2));
            label = new Label(composite2, 0);
            label.setText("Height:");
            label = new Label(composite2, 0);
            label.setText(Utilities.getShortestDouble((double)d3));
        }
        if (file != null) {
            label = new Label(composite2, 0);
            label.setText("File name:");
            label = new Label(composite2, 0);
            label.setText(file.getAbsolutePath().replace("&", "&&"));
        }
        return composite2;
    }

    @Override
    public ImageDesignerProp getDesigner() {
        return this.a;
    }

    @Override
    public IUndoContext getUndoContext() {
        return this.a;
    }

    public EditorSVGDefinition clone() throws CloneNotSupportedException {
        EditorSVGDefinition editorSVGDefinition = (EditorSVGDefinition)super.clone();
        editorSVGDefinition.a = new ImageDesignerProp((PropCnr)editorSVGDefinition);
        return editorSVGDefinition;
    }

    public Class<?>[] getPossibleChildren() {
        return null;
    }

    public boolean verify(PropVerification propVerification) {
        BoolProp boolProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        SVGInfo sVGInfo = this.getSVGInfo();
        if (sVGInfo != null && !sVGInfo.hasViewBox() && (boolProp = (BoolProp)this.getProp("addViewBox", BoolProp.class)) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, "addViewBox", PropVerificationError.Severity.WARNING, "View box", "The SVG file does not include a \"viewbox\" attribute: please choose how to handle this", new String[0]));
        }
        return true;
    }
}

