/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SearchForBuildFilesDialog
extends InputDialog {
    private List<IResource> results = new ArrayList<IResource>();
    private List<IResource> searchScopes = null;
    private Button workingSetScopeButton;
    private Button workspaceScopeButton;
    private Text workingSetText;
    private Button includeErrorResultButton;
    private static IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(SearchForBuildFilesDialog.class)).getDialogSettings();

    static {
        if (settings.get("antview.lastSearchString") == null) {
            settings.put("antview.lastSearchString", "build.xml");
        }
        if (settings.get("antview.lastSearchScope") == null) {
            settings.put("antview.lastSearchScope", "");
        }
    }

    public SearchForBuildFilesDialog() {
        super(Display.getCurrent().getActiveShell(), AntViewActionMessages.SearchForBuildFilesDialog_Search_for_Build_Files_1, AntViewActionMessages.SearchForBuildFilesDialog__Input, settings.get("antview.lastSearchString"), newText -> {
            String trimmedText = newText.trim();
            if (trimmedText.length() == 0) {
                return AntViewActionMessages.SearchForBuildFilesDialog_Build_name_cannot_be_empty_3;
            }
            return null;
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setText(AntViewActionMessages.SearchForBuildFilesDialog__Search_4);
        String workingSetName = settings.get("antview.lastSearchScope");
        if (workingSetName.length() > 0) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName));
        }
        if (!settings.getBoolean("antview.useWorkingSetSearchScope")) {
            this.selectRadioButton(this.workspaceScopeButton);
            this.handleRadioButtonPressed();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createIncludeErrorResultButton(composite, font);
        this.createScopeGroup(composite, font);
        return composite;
    }

    private void createScopeGroup(Composite composite, Font font) {
        Group scope = new Group(composite, 0);
        scope.setText(AntViewActionMessages.SearchForBuildFilesDialog_Scope_5);
        GridData data = new GridData(1808);
        scope.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        scope.setLayout((Layout)layout);
        scope.setFont(font);
        Composite radioComposite = new Composite((Composite)scope, 0);
        GridLayout radioLayout = new GridLayout();
        radioLayout.marginHeight = 0;
        radioComposite.setLayout((Layout)radioLayout);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchForBuildFilesDialog.this.handleRadioButtonPressed();
            }
        };
        this.workspaceScopeButton = new Button(radioComposite, 16);
        this.workspaceScopeButton.setFont(font);
        this.workspaceScopeButton.setText(AntViewActionMessages.SearchForBuildFilesDialog__Workspace_6);
        this.workspaceScopeButton.addSelectionListener((SelectionListener)selectionListener);
        this.workingSetScopeButton = new Button(radioComposite, 16);
        this.workingSetScopeButton.setFont(font);
        this.workingSetScopeButton.setText(AntViewActionMessages.SearchForBuildFilesDialog_Wor_king_Set__7);
        this.workingSetScopeButton.addSelectionListener((SelectionListener)selectionListener);
        this.selectRadioButton(this.workspaceScopeButton);
        this.workingSetText = new Text((Composite)scope, 2048);
        this.workingSetText.setEditable(false);
        data = new GridData(776);
        this.workingSetText.setLayoutData((Object)data);
        this.workingSetText.setFont(font);
        Button chooseButton = new Button((Composite)scope, 8);
        data = new GridData(8);
        chooseButton.setLayoutData((Object)data);
        chooseButton.setFont(font);
        chooseButton.setText(AntViewActionMessages.SearchForBuildFilesDialog__Choose____8);
        chooseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SearchForBuildFilesDialog.this.handleChooseButtonPressed();
            }
        });
    }

    private void selectRadioButton(Button button) {
        if (button == this.workingSetScopeButton) {
            this.workingSetScopeButton.setSelection(true);
            this.workspaceScopeButton.setSelection(false);
        } else if (button == this.workspaceScopeButton) {
            this.workspaceScopeButton.setSelection(true);
            this.workingSetScopeButton.setSelection(false);
        }
    }

    private void handleRadioButtonPressed() {
        IWorkingSet set;
        if (this.workingSetScopeButton.getSelection() && (set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(this.getWorkingSetName())) != null) {
            this.setWorkingSet(set);
            return;
        }
        this.setWorkingSet(null);
    }

    private String getWorkingSetName() {
        return this.workingSetText.getText().trim();
    }

    private void createIncludeErrorResultButton(Composite composite, Font font) {
        this.includeErrorResultButton = new Button(composite, 32);
        this.includeErrorResultButton.setFont(font);
        this.includeErrorResultButton.setText(AntViewActionMessages.SearchForBuildFilesDialog_Include_errors);
        this.includeErrorResultButton.setSelection(settings.getBoolean("antview.includeErrorSearchResults"));
    }

    private void updateForWorkingSetSettings() {
        if (this.workingSetScopeButton.getSelection()) {
            String error = null;
            if (this.searchScopes == null) {
                error = AntViewActionMessages.SearchForBuildFilesDialog_Must_select_a_working_set_10;
            } else if (this.searchScopes.isEmpty()) {
                error = AntViewActionMessages.SearchForBuildFilesDialog_No_searchable;
            }
            if (error != null) {
                this.setErrorMessage(error);
                this.getOkButton().setEnabled(false);
                return;
            }
        }
        this.getOkButton().setEnabled(true);
        this.setErrorMessage(null);
    }

    private void handleChooseButtonPressed() {
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(this.getShell(), false);
        if (dialog.open() == 1) {
            return;
        }
        IWorkingSet[] sets = dialog.getSelection();
        if (sets == null) {
            return;
        }
        if (sets.length == 0) {
            this.setWorkingSet(null);
        } else {
            this.setWorkingSet(sets[0]);
        }
    }

    private void setWorkingSet(IWorkingSet set) {
        if (set == null) {
            this.searchScopes = null;
            this.workingSetText.setText("");
            this.validateInput();
            return;
        }
        this.searchScopes = new ArrayList<IResource>();
        IAdaptable[] iAdaptableArray = set.getElements();
        int n = iAdaptableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            IResource resource = null;
            resource = adaptable instanceof IResource ? (IResource)adaptable : (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                this.searchScopes.add(resource);
            }
            ++n2;
        }
        this.workingSetText.setText(set.getName());
        this.selectRadioButton(this.workingSetScopeButton);
        this.validateInput();
    }

    private String getInput() {
        return this.getText().getText().trim();
    }

    public IFile[] getResults() {
        return this.results.toArray(new IFile[this.results.size()]);
    }

    protected boolean getIncludeErrorResults() {
        return settings.getBoolean("antview.includeErrorSearchResults");
    }

    protected void okPressed() {
        String input = this.getInput();
        settings.put("antview.lastSearchString", input);
        settings.put("antview.includeErrorSearchResults", this.includeErrorResultButton.getSelection());
        settings.put("antview.lastSearchScope", this.getWorkingSetName());
        settings.put("antview.useWorkingSetSearchScope", this.workingSetScopeButton.getSelection());
        this.results = new ArrayList<IResource>();
        ResourceProxyVisitor visitor = new ResourceProxyVisitor();
        if (this.searchScopes == null || this.searchScopes.isEmpty()) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 0);
            }
            catch (CoreException coreException) {}
        } else {
            Iterator<IResource> iter = this.searchScopes.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().accept((IResourceProxyVisitor)visitor, 0);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ant.ui.search_for_buildfiles_dialog_context");
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.getValidator() != null) {
            errorMessage = this.getValidator().isValid(this.getText().getText());
        }
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.updateForWorkingSetSettings();
        }
    }

    class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        Pattern pattern;

        ResourceProxyVisitor() {
            String input = SearchForBuildFilesDialog.this.getInput();
            input = input.replace(".", "\\.");
            input = input.replace("*", ".*");
            input = input.replace("?", ".?");
            this.pattern = Pattern.compile(input);
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.getType() == 1) {
                Matcher matcher = this.pattern.matcher(proxy.getName());
                if (matcher.find()) {
                    SearchForBuildFilesDialog.this.results.add(proxy.requestResource());
                }
                return false;
            }
            return true;
        }
    }
}

