/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.isite.IStatsInfo;
import org.eclipse.pde.internal.core.site.SiteBundle;
import org.eclipse.pde.internal.core.site.SiteFeature;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatsInfo
extends SiteObject
implements IStatsInfo {
    private static final long serialVersionUID = 1L;
    static final String INDENT = "   ";
    public static final String P_URL = "url";
    private String fURL;
    private final Vector<ISiteObject> featureArtifacts = new Vector();
    private final Vector<ISiteObject> bundleArtifacts = new Vector();

    @Override
    public void setURL(String url) throws CoreException {
        String old = this.fURL;
        this.fURL = url;
        this.ensureModelEditable();
        this.firePropertyChanged(P_URL, old, this.fURL);
    }

    @Override
    public String getURL() {
        return this.fURL;
    }

    @Override
    public void addFeatureArtifacts(ISiteFeature[] newFeatures) throws CoreException {
        this.ensureModelEditable();
        ISiteFeature[] iSiteFeatureArray = newFeatures;
        int n = newFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature feature = iSiteFeatureArray[n2];
            ((SiteFeature)feature).setInTheModel(true);
            this.featureArtifacts.add(feature);
            ++n2;
        }
        this.fireStructureChanged(newFeatures, 1);
    }

    @Override
    public void addBundleArtifacts(ISiteBundle[] newBundles) throws CoreException {
        this.ensureModelEditable();
        ISiteBundle[] iSiteBundleArray = newBundles;
        int n = newBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteBundle bundle = iSiteBundleArray[n2];
            ((SiteBundle)bundle).setInTheModel(true);
            this.bundleArtifacts.add(bundle);
            ++n2;
        }
        this.fireStructureChanged(newBundles, 1);
    }

    @Override
    public void removeFeatureArtifacts(ISiteFeature[] newFeatures) throws CoreException {
        this.ensureModelEditable();
        ISiteFeature[] iSiteFeatureArray = newFeatures;
        int n = newFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature feature = iSiteFeatureArray[n2];
            ((SiteFeature)feature).setInTheModel(false);
            this.featureArtifacts.remove(feature);
            ++n2;
        }
        this.fireStructureChanged(newFeatures, 2);
    }

    @Override
    public void removeBundleArtifacts(ISiteBundle[] newBundles) throws CoreException {
        this.ensureModelEditable();
        ISiteBundle[] iSiteBundleArray = newBundles;
        int n = newBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteBundle bundle = iSiteBundleArray[n2];
            ((SiteBundle)bundle).setInTheModel(false);
            this.bundleArtifacts.remove(bundle);
            ++n2;
        }
        this.fireStructureChanged(newBundles, 2);
    }

    @Override
    public ISiteFeature[] getFeatureArtifacts() {
        return this.featureArtifacts.toArray(new ISiteFeature[this.featureArtifacts.size()]);
    }

    @Override
    public ISiteBundle[] getBundleArtifacts() {
        return this.bundleArtifacts.toArray(new ISiteBundle[this.bundleArtifacts.size()]);
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fURL = element.getAttribute("location");
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    this.parseChild(child);
                }
                ++i;
            }
        }
    }

    protected void parseChild(Node child) {
        String tag = child.getNodeName().toLowerCase(Locale.ENGLISH);
        if (tag.equals("feature")) {
            ISiteFeature feature = this.getModel().getFactory().createFeature();
            ((SiteFeature)feature).parse(child);
            ((SiteFeature)feature).setInTheModel(true);
            this.featureArtifacts.add(feature);
        } else if (tag.equals("bundle")) {
            ISiteBundle bundle = this.getModel().getFactory().createBundle();
            ((SiteBundle)bundle).parse(child);
            ((SiteBundle)bundle).setInTheModel(true);
            this.bundleArtifacts.add(bundle);
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.isURLDefined()) {
            IWritable writable;
            writer.print(indent + "<stats location=\"" + this.fURL + "\"");
            writer.println(">");
            String indent2 = indent + INDENT;
            int i = 0;
            while (i < this.featureArtifacts.size()) {
                writable = this.featureArtifacts.get(i);
                writable.write(indent2, writer);
                ++i;
            }
            i = 0;
            while (i < this.bundleArtifacts.size()) {
                writable = this.bundleArtifacts.get(i);
                writable.write(indent2, writer);
                ++i;
            }
            writer.println(indent + "</stats>");
        }
    }

    private boolean isURLDefined() {
        return this.fURL != null && this.fURL.length() > 0;
    }

    @Override
    public boolean isValid() {
        int i = 0;
        while (i < this.featureArtifacts.size()) {
            ISiteFeature feature = (ISiteFeature)this.featureArtifacts.get(i);
            if (!feature.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.bundleArtifacts.size()) {
            ISiteBundle bundle = (ISiteBundle)this.bundleArtifacts.get(i);
            if (!bundle.isValid()) {
                return false;
            }
            ++i;
        }
        return this.isURLDefined();
    }
}

