/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.ibm.icu.util.StringTokenizer;
import com.iizix.prop.Atom;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class CSSClassNamesProp
extends StringProp {
    protected CSSClassNamesProp() {
    }

    public CSSClassNamesProp(Atom atom) {
        super(atom);
    }

    public CSSClassNamesProp(Atom atom, String string) throws PropValidateException {
        super(atom);
        this.setPropValue(string);
    }

    @Override
    public CSSClassNamesProp clone() {
        return (CSSClassNamesProp)super.clone();
    }

    public final List<String> getClassNames() {
        List<String> list = null;
        String string = (String)this.getPropValue();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                ((ArrayList)list).add(string2);
            }
        }
        return list != null ? list : Collections.emptyList();
    }

    public static String getCSSClassNamesString(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : collection) {
            int n2 = 0;
            int n3 = string.length();
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (n2 == 0 && c2 >= '0' && c2 <= '9') {
                    throw new IllegalArgumentException("CSS class name \"" + string + "\" cannot start with a digit '" + c2 + "'");
                }
                if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_')) {
                    throw new IllegalArgumentException("CSS class name \"" + string + "\" contains an invalid character '" + c2 + "'");
                }
                ++n2;
            }
            if (!hashSet.add(string)) continue;
            if (stringBuilder.isEmpty()) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.isEmpty() ? null : stringBuilder.toString();
    }

    @Override
    public final boolean verify(PropVerification propVerification) {
        if (super.verify(propVerification)) {
            int n2 = 0;
            List<String> list = this.getClassNames();
            if (!list.isEmpty()) {
                HashSet<String> hashSet = new HashSet<String>();
                block0: for (String string : list) {
                    if (hashSet.add(string)) {
                        int n3 = 0;
                        int n4 = string.length();
                        while (n3 < n4) {
                            char c2 = string.charAt(n3);
                            if (n3 == 0 && c2 >= '0' && c2 <= '9') {
                                propVerification.add(new PropVerificationError("cn" + ++n2, PropVerificationError.Severity.WARNING, "CSS class names", this, "CSS class name \"" + string + "\" cannot start with a digit '" + c2 + "'", new String[0]));
                                continue block0;
                            }
                            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '_')) {
                                propVerification.add(new PropVerificationError("cn" + ++n2, PropVerificationError.Severity.WARNING, "CSS class names", this, "CSS class name \"" + string + "\" contains an invalid character '" + c2 + "'", new String[0]));
                                continue block0;
                            }
                            ++n3;
                        }
                        continue;
                    }
                    propVerification.add(new PropVerificationError("cn" + ++n2, PropVerificationError.Severity.WARNING, "CSS class names", this, "Duplicate CSS class name \"" + string + "\" specified", new String[0]));
                }
            }
        }
        return false;
    }
}

