/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.comm.IPortController;
import com.iizix.comm.PortConfig;
import com.iizix.prop.IWebServerPortConfig;
import java.io.IOException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class e
implements IPortController {
    private final Server a;
    final IWebServerPortConfig a;
    ServerConnector a;
    PortConfig a;
    Runnable a;
    private final String a;

    e(Server server, IWebServerPortConfig iWebServerPortConfig) {
        this.a = server;
        this.a = iWebServerPortConfig;
        this.a = iWebServerPortConfig.getPortDescription();
    }

    public PortConfig getConfiguration() {
        return this.a;
    }

    public IPortController.State getState() {
        ServerConnector serverConnector = this.a;
        if (serverConnector == null) {
            return IPortController.State.UNINITIALIZED;
        }
        if (serverConnector.isFailed()) {
            return IPortController.State.FAILED;
        }
        if (serverConnector.isOpen()) {
            return IPortController.State.OPEN;
        }
        if (serverConnector.isStarting()) {
            return IPortController.State.STARTING;
        }
        if (serverConnector.isStopping()) {
            return IPortController.State.STOPPING;
        }
        if (serverConnector.isStopped()) {
            return IPortController.State.STOPPED;
        }
        if (serverConnector.isStarted()) {
            return IPortController.State.STARTED;
        }
        return IPortController.State.CLOSED;
    }

    public String start(boolean bl) {
        ServerConnector serverConnector = this.a;
        if (serverConnector == null) {
            return "Connector " + this.a + " not initialized";
        }
        if (serverConnector.isStarting()) {
            return "Cannot start connector " + this.a + ", currently in starting state";
        }
        if (serverConnector.isStarted()) {
            return "Cannot start connector " + this.a + ", already started";
        }
        if (bl) {
            try {
                serverConnector.start();
            }
            catch (Exception exception) {
                String string = "Failed starting connector " + this.a;
                ILog.SEVERE(this.getClass(), (String)string, (Throwable)exception);
                return string + ": " + exception.getMessage();
            }
        }
        return null;
    }

    public String open(boolean bl) {
        ServerConnector serverConnector = this.a;
        if (serverConnector == null) {
            return "Connector " + this.a + " is not initialized";
        }
        if (serverConnector.isOpen()) {
            return "Connector " + this.a + " is already open";
        }
        if (bl) {
            try {
                serverConnector.open();
            }
            catch (IOException iOException) {
                String string = "Failed opening connector " + this.a;
                ILog.SEVERE(this.getClass(), (String)string, (Throwable)iOException);
                return string + ": " + iOException.getMessage();
            }
        }
        return null;
    }

    public String close(boolean bl) {
        ServerConnector serverConnector = this.a;
        if (serverConnector == null) {
            return "Connector " + this.a + " not initialized";
        }
        if (!serverConnector.isOpen()) {
            return "Connector " + this.a + " is not open";
        }
        if (bl) {
            this.a.close();
        }
        return null;
    }

    public void restart() {
        if (this.a != null) {
            this.a.run();
        } else {
            ILog.WARNING(this.getClass(), (String)("The connector " + this.a + " does not support restarting"));
        }
    }

    public String stop(boolean bl) {
        ServerConnector serverConnector = this.a;
        if (serverConnector == null) {
            return "Connector " + this.a + " not initialized";
        }
        if (serverConnector.isStopping()) {
            return "Cannot stop connector " + this.a + ", currently in stopping state";
        }
        if (serverConnector.isStopped()) {
            return "Cannot stop connector " + this.a + ", already stopped";
        }
        if (bl) {
            try {
                serverConnector.stop();
            }
            catch (Exception exception) {
                String string = "Failed stopping connector " + this.a;
                ILog.SEVERE(this.getClass(), (String)string, (Throwable)exception);
                return string + ": " + exception.getMessage();
            }
        }
        return null;
    }

    public void dispose() {
        ServerConnector serverConnector = this.a;
        if (serverConnector != null) {
            if (serverConnector.isRunning()) {
                try {
                    serverConnector.stop();
                }
                catch (Exception exception) {
                    String string = "Failed stopping connector " + this.a;
                    ILog.SEVERE(this.getClass(), (String)string, (Throwable)exception);
                }
            }
            this.a.removeConnector((Connector)serverConnector);
        }
    }
}

