/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.push;

import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.prop.editor.StringPropEditor;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.StringProp;
import com.iizix.push.VAPIDKeys;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class VAPIDKeyPropEditor
extends StringPropEditor {
    @Override
    protected void create() {
        this.parseOptions();
        this.createGridLayout(2, 0);
        this.createMoreButton("Generate new VAPID Key Pair");
        this.createText();
        this.more.addListener(3, event -> this.a());
    }

    private void a() {
        String string = this.getCurrentInput();
        string = string != null ? string.trim() : "";
        PropCnr propCnr = this.propController.getParents()[0];
        String string2 = propCnr.getString("VPubKey", "").trim();
        String string3 = "Generation of VAPID keys";
        if (!(string.isEmpty() && string2.isEmpty() || MessageDialog.openConfirm((Shell)this.shell, (String)string3, (String)"Please confirm overwriting existing VAPID keys."))) {
            return;
        }
        String[] stringArray = VAPIDKeys.generateKeys();
        string2 = stringArray[0];
        string = stringArray[1];
        ComplexOperation complexOperation = new ComplexOperation(string3, null, this.controller.getUndoRedo());
        try {
            Atom atom = Atom.get((String)"VPubKey");
            GProp gProp = propCnr.getProp(atom);
            if (gProp != null) {
                complexOperation.removeProp(gProp);
            }
            complexOperation.addProp(propCnr, (GProp<?>)new StringProp(atom, string2));
            Atom atom2 = Atom.get((String)"VPrivKey");
            gProp = propCnr.getProp(atom2);
            if (gProp != null) {
                complexOperation.removeProp(gProp);
            }
            complexOperation.addProp(propCnr, (GProp<?>)new StringProp(atom2, string));
            PropHelper.executeOperation(this.shell, complexOperation);
            MessageDialog.openInformation((Shell)this.shell, (String)string3, (String)"The VAPID keys were generated successfully.");
        }
        catch (PropValidateException propValidateException) {
            ILog.SEVERE(this.getClass(), (String)"Failed setting generated VAPID keys", (Throwable)propValidateException);
        }
    }
}

