/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.acme;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.server.ServerShell;
import com.iizix.server.acme.a;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import org.shredzone.acme4j.AccountBuilder;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Challenge;
import org.shredzone.acme4j.challenge.Dns01Challenge;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.util.CSRBuilder;
import org.shredzone.acme4j.util.KeyPairUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LetsEncrypt {
    private final String a;
    private final Type a;
    private final File a;
    private final File b;
    private final File c;
    private final File d;
    private final File e;
    private final File f;
    private final File g;
    private final File h;
    private File i;
    private final String b;
    private final String c;
    private static volatile /* synthetic */ int[] a;
    private static volatile /* synthetic */ int[] b;

    private LetsEncrypt(String string, String string2, Type type, String string3, String string4) throws IOException {
        if (string3 == null) {
            string3 = "iizi";
        }
        if (string4 == null) {
            string4 = "changeit";
        }
        this.a = new File(string).getCanonicalFile();
        if (!this.a.isDirectory()) {
            throw new FileNotFoundException("WebRoot " + this.a.getPath() + " directory is not found");
        }
        this.a = string2;
        this.a = type;
        this.b = string3;
        this.c = string4;
        ILog.INFO(this.getClass(), (String)("Let's Encrypt: requesting certificate for domain " + string2 + " using web server directory root " + this.a.getPath()));
        this.b = new File(".acmeCertificates").getCanonicalFile();
        if (!this.b.exists()) {
            if (!this.b.mkdir()) {
                throw new IOException("Failed creating Let's Encrypt certificate support directory " + this.b.getPath());
            }
        } else if (!this.b.isDirectory()) {
            throw new IOException("Let's Encrypt certificate support directory " + this.b.getPath() + " is not a directory");
        }
        this.c = new File(this.a, ".well-known/acme-challenge");
        if (!(this.c.isDirectory() || this.c.mkdirs() && this.c.isDirectory())) {
            throw new IOException("Failed creating the Let's Encrypt challenge support directory " + this.c.getPath());
        }
        String string5 = string2.startsWith("*.") ? "@" + string2.substring(1) : string2;
        this.d = new File(this.b, string5 + "-user.key");
        this.e = new File(this.b, string5 + "-domain.key");
        this.f = new File(this.b, string5 + "-domainCertificate.pem");
        this.g = new File(this.b, string5 + "-domain.csr");
        this.h = new File(this.b, string5 + "-identity.p12");
    }

    private void a() {
        if (this.d.exists() && !this.d.delete()) {
            ILog.WARNING(this.getClass(), (String)("Failed deleting file " + this.d.getPath()));
        }
        if (this.e.exists() && !this.e.delete()) {
            ILog.WARNING(this.getClass(), (String)("Failed deleting file " + this.e.getPath()));
        }
        if (this.f.exists() && !this.f.delete()) {
            ILog.WARNING(this.getClass(), (String)("Failed deleting file " + this.f.getPath()));
        }
        if (this.g.exists() && !this.g.delete()) {
            ILog.WARNING(this.getClass(), (String)("Failed deleting file " + this.g.getPath()));
        }
        try {
            this.b();
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), (String)("Failed deleting Let's Encrypt domain " + this.a + " challenge file " + this.i.getPath()));
        }
    }

    private void b() throws IOException {
        if (this.i != null) {
            if (!this.i.delete()) {
                throw new IOException("Failed deleting challenge file " + this.i.getPath());
            }
            this.i = null;
        }
    }

    private Reply a(String string, URI uRI) throws IOException, AcmeException {
        char[] cArray;
        CSRBuilder cSRBuilder2;
        URI uRI2;
        Proxy proxy;
        Session session = new Session("acme://letsencrypt.org");
        URL uRL = session.provider().resolve(session.getServerUri());
        try {
            proxy = ServerShell.getInstance().getProxy(uRL);
        }
        catch (Throwable throwable) {
            ILog.WARNING(this.getClass(), (String)"Server is not started, ignoring Let's Encrypt certificate request", (Object[])new Object[]{uRL, throwable});
            return new Reply(string, Code.NO_CHANGE);
        }
        if (!Proxy.NO_PROXY.equals(proxy)) {
            session.networkSettings().setProxySelector((ProxySelector)new a(this));
        }
        KeyPair keyPair = this.a();
        Optional optional = session.getMetadata().getTermsOfService();
        if (optional.isPresent()) {
            uRI2 = (URI)optional.get();
            if (!uRI2.equals(uRI)) {
                ILog.WARNING(this.getClass(), (String)("ACTION REQUIRED:\n\nLet's Encrypt domain " + string + ": Accept " + (uRI != null ? "newly updated " : "") + "Terms of Service to be accepted at " + String.valueOf(uRI2) + "\n"));
                return new Reply(string, uRI2);
            }
            ILog.INFO(this.getClass(), (String)("Let's Encrypt domain " + string + " Terms of Service at " + String.valueOf(uRI2)));
        }
        uRI2 = new AccountBuilder().agreeToTermsOfService().useKeyPair(keyPair).create(session);
        ILog.INFO(this.getClass(), (String)("User registered account for Let's Encrypt domain " + string + " at URL " + String.valueOf(uRI2.getLocation())));
        KeyPair keyPair2 = this.b();
        Order order = uRI2.newOrder().domain(string).create();
        try {
            for (CSRBuilder cSRBuilder2 : order.getAuthorizations()) {
                this.a((Authorization)cSRBuilder2);
            }
            cSRBuilder2 = new CSRBuilder();
            cSRBuilder2.addDomain(string);
            cSRBuilder2.sign(keyPair2);
            Object object = null;
            cArray = null;
            try (FileWriter fileWriter = new FileWriter(this.g);){
                cSRBuilder2.write((Writer)fileWriter);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            order.execute(cSRBuilder2.getEncoded());
            long l = System.currentTimeMillis();
            try {
                int n = 10;
                while (order.getStatus() != Status.VALID && --n >= 0) {
                    if (order.getStatus() == Status.INVALID) {
                        Optional optional2 = order.getError();
                        String string2 = optional2.isPresent() ? ": " + String.valueOf(optional2.get()) : "";
                        throw new AcmeException("Let's Encrypt order for domain " + string + " failed after " + Utilities.formatEnglishDuration((long)(System.currentTimeMillis() - l)) + ")" + string2);
                    }
                    Thread.sleep(3000L);
                    order.fetch();
                }
            }
            catch (InterruptedException interruptedException) {
                ILog.SEVERE(this.getClass(), (String)("Let's Encrypt order for domain " + string + " got interrupted"), (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
            if (order.getStatus() != Status.VALID) {
                Optional optional3 = order.getError();
                String string3 = optional3.isPresent() ? ": " + String.valueOf(optional3.get()) : "";
                throw new AcmeException("Let's Encrypt order for domain " + string + " failed, giving up after " + Utilities.formatEnglishDuration((long)(System.currentTimeMillis() - l)) + ")" + string3);
            }
        }
        finally {
            this.b();
        }
        cSRBuilder2 = order.getCertificate();
        ILog.INFO((String)("Let's Encrypt certificate for domain " + string + " has been generated successfully, certificate is found at URL = " + String.valueOf(cSRBuilder2.getLocation())));
        Object object = "Create PKCS#12 identity KeyStore failed for Let's Encrypt domain " + string;
        cArray = this.c.toCharArray();
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            List list = order.getCertificate().getCertificateChain();
            keyStore.setKeyEntry(this.b, keyPair2.getPrivate(), cArray, list.toArray(new X509Certificate[list.size()]));
            object = "Create PKCS#12 identity KeyStore failed";
            Object object2 = null;
            Object var17_32 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.h);){
                keyStore.store(fileOutputStream, cArray);
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                if (object2 == null) {
                    object2 = throwable;
                } else if (object2 != throwable) {
                    ((Throwable)object2).addSuppressed(throwable);
                }
                throw object2;
            }
            object2 = this.c.equals("changeit") ? "and password \"changeit\"" : "with configured password";
            ILog.INFO(this.getClass(), (String)"Created Let's Encrypt domain {} PKCS#12 identity file \"{}\", certificate chain alias \"{}\" {}", (Object[])new Object[]{string, this.h, this.b, object2});
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException generalSecurityException) {
            ILog.SEVERE(this.getClass(), (String)object, (Throwable)generalSecurityException);
        }
        return new Reply(string, Code.OK);
    }

    private KeyPair a() throws IOException {
        KeyPair keyPair;
        if (this.d.exists()) {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileReader fileReader = new FileReader(this.d);){
                keyPair = KeyPairUtils.readKeyPair((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ILog.INFO(this.getClass(), (String)("Loaded existing Let's Encrypt domain " + this.a + " key pair from file: " + String.valueOf(Utilities.getCanonicalFile((File)this.d))));
        } else {
            keyPair = KeyPairUtils.createKeyPair((int)2048);
            Throwable throwable = null;
            Object var3_7 = null;
            try (FileWriter fileWriter = new FileWriter(this.d);){
                KeyPairUtils.writeKeyPair((KeyPair)keyPair, (Writer)fileWriter);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            ILog.INFO(this.getClass(), (String)("Created a new Let's Encrypt domain " + this.a + " key pair from file: " + String.valueOf(Utilities.getCanonicalFile((File)this.d))));
        }
        return keyPair;
    }

    private KeyPair b() throws IOException {
        if (this.e.exists()) {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileReader fileReader = new FileReader(this.e);){
                return KeyPairUtils.readKeyPair((Reader)fileReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        KeyPair keyPair = KeyPairUtils.createKeyPair((int)2048);
        Throwable throwable = null;
        Object var3_9 = null;
        try (FileWriter fileWriter = new FileWriter(this.e);){
            KeyPairUtils.writeKeyPair((KeyPair)keyPair, (Writer)fileWriter);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return keyPair;
    }

    private void a(Authorization authorization) throws AcmeException, IOException {
        if (authorization.getStatus() == Status.VALID) {
            ILog.INFO(this.getClass(), (String)("The Let's Encrypt domain " + this.a + " is already authorized"));
            return;
        }
        ILog.INFO(this.getClass(), (String)("Authorizing Let's Encrypt domain " + this.a));
        Challenge challenge = null;
        switch (LetsEncrypt.a()[this.a.ordinal()]) {
            case 1: {
                challenge = this.a(authorization);
                break;
            }
            case 2: {
                challenge = this.b(authorization);
                break;
            }
            default: {
                throw new InternalError("Unknown challenge type " + String.valueOf((Object)this.a));
            }
        }
        if (challenge == null) {
            throw new AcmeException("No challenge specified");
        }
        if (challenge.getStatus() == Status.VALID) {
            ILog.INFO(this.getClass(), (String)("The Let's Encrypt domain " + this.a + " challenge is already verified"));
            return;
        }
        challenge.trigger();
        long l = System.nanoTime();
        try {
            int n = 10;
            while (challenge.getStatus() != Status.VALID && --n >= 0) {
                if (challenge.getStatus() == Status.INVALID) {
                    Optional optional = challenge.getError();
                    String string = optional.isPresent() ? ": " + String.valueOf(optional.get()) : "";
                    throw new AcmeException("Let's Encrypt challenge failed for domain " + this.a + " after " + Utilities.formatEnglishNanoDuration((long)(System.nanoTime() - l)) + " and " + (10 - n) + " attempts each 3 seconds)" + string);
                }
                Thread.sleep(3000L);
                challenge.fetch();
            }
        }
        catch (InterruptedException interruptedException) {
            ILog.SEVERE(this.getClass(), (String)("Let's Encrypt challenge for domain " + this.a + " got interrupted"), (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        if (challenge.getStatus() != Status.VALID) {
            Optional optional = challenge.getError();
            String string = optional.isPresent() ? ": " + String.valueOf(optional.get()) : "";
            throw new AcmeException("Challenge failed to pass for Let's Encrypt domain " + this.a + ", giving up after " + Utilities.formatEnglishNanoDuration((long)(System.nanoTime() - l)) + ")" + string);
        }
        ILog.INFO(this.getClass(), (String)("Let's Encrypt challenge completed successfully for domain " + this.a));
    }

    private Challenge a(Authorization authorization) throws AcmeException, IOException {
        this.b();
        Optional optional = authorization.findChallenge(Http01Challenge.class);
        if (!optional.isPresent()) {
            throw new AcmeException("Challenge type http-01 not found");
        }
        Http01Challenge http01Challenge = (Http01Challenge)optional.get();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileWriter fileWriter = new FileWriter(new File(this.c, http01Challenge.getToken()));){
            fileWriter.write(http01Challenge.getAuthorization());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return http01Challenge;
    }

    private Challenge b(Authorization authorization) throws AcmeException {
        Optional optional = authorization.findChallenge("dns-01");
        if (!optional.isPresent()) {
            throw new AcmeException("Challenge type \"dns-01\" not found");
        }
        Dns01Challenge dns01Challenge = (Dns01Challenge)optional.get();
        ILog.WARNING((String)("ACTION REQUIRED IN DNS DOMAIN \"" + this.a + "\":\n\nFor the Let's Encrypt \"dns-01\" challenge for domain " + this.a + ", please create a DNS TXT record as: \"" + dns01Challenge.getRRName(authorization.getIdentifier()) + " IN TXT " + dns01Challenge.getDigest() + "\"\n"));
        return dns01Challenge;
    }

    public static File createCertificateChallenge(String string, String string2, Type type, StringBuilder stringBuilder, String string3, String string4, X509Certificate[] x509CertificateArray) throws IOException, Exception {
        URI uRI;
        if (type.equals((Object)Type.HTTP) && string2.startsWith("*")) {
            throw new IOException("Wildcard domains are not allowed for Let's Encrypt HTTP-01 challenges");
        }
        try {
            uRI = stringBuilder.length() > 0 ? new URI(stringBuilder.toString()) : null;
        }
        catch (Throwable throwable) {
            throw new InternalError("Shouldn't be", throwable);
        }
        LetsEncrypt letsEncrypt = new LetsEncrypt(string, string2, type, string3, string4);
        Reply reply = letsEncrypt.a(string2, uRI);
        switch (LetsEncrypt.b()[reply.a.ordinal()]) {
            case 1: 
            case 2: {
                letsEncrypt.a();
                if (x509CertificateArray != null) {
                    x509CertificateArray[0] = reply.a;
                }
                if (reply.a != null) {
                    stringBuilder.setLength(0);
                    stringBuilder.append(reply.a.toString());
                }
                return letsEncrypt.h;
            }
        }
        letsEncrypt.b();
        if (reply.a != null) {
            stringBuilder.setLength(0);
            stringBuilder.append(reply.a.toString());
        }
        return null;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Type.values().length];
        try {
            nArray[Type.DNS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Type.HTTP.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[Code.values().length];
        try {
            nArray[Code.CREATE_DNS_RECORD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Code.NO_CHANGE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Code.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Code.TOS_NEEDS_ACCEPTANCE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }

    public static enum Code {
        OK,
        NO_CHANGE,
        TOS_NEEDS_ACCEPTANCE,
        CREATE_DNS_RECORD;

    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Reply {
        private final String a;
        private final Code a;
        private URI a;
        private String b;
        private X509Certificate a;

        private Reply(String string, Code code) {
            this.a = string;
            this.a = code;
        }

        private Reply(String string, URI uRI) {
            this.a = string;
            this.a = uRI;
            this.a = Code.TOS_NEEDS_ACCEPTANCE;
        }

        public URI getToS() {
            return this.a;
        }

        public String getDNSRecord() {
            return this.b;
        }

        public Code getReturnCode() {
            return this.a;
        }

        public String getDomain() {
            return this.a;
        }
    }

    public static enum Type {
        HTTP,
        DNS;

    }
}

