/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SynchronizeModelElementLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Map<ImageDescriptor, Image> fgImageCache;
    CompareConfiguration compareConfig = new CompareConfiguration();
    private final WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private Font busyFont;

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        ISynchronizeModelElement node;
        if (element instanceof ISynchronizeModelElement && (node = (ISynchronizeModelElement)element).getProperty("org.eclipse.team.ui.busy")) {
            if (this.busyFont == null) {
                FontData[] data;
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] fontDataArray = data = defaultFont.getFontData();
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData d = fontDataArray[n2];
                    d.setStyle(2);
                    ++n2;
                }
                this.busyFont = new Font((Device)TeamUIPlugin.getStandardDisplay(), data);
            }
            return this.busyFont;
        }
        return null;
    }

    public Image getImage(Object element) {
        Image base = this.workbenchLabelProvider.getImage(element);
        if (base != null && element instanceof ISynchronizeModelElement) {
            ISynchronizeModelElement syncNode = (ISynchronizeModelElement)element;
            int kind = syncNode.getKind();
            Image decoratedImage = this.getCompareImage(base, kind);
            return this.propagateConflicts(decoratedImage, syncNode);
        }
        return base;
    }

    public String getText(Object element) {
        int kind;
        String base = this.workbenchLabelProvider.getText(element);
        if (element instanceof DiffNode && TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.view_syncinfo_in_label") && (kind = ((DiffNode)element).getKind()) != 0) {
            String syncKindString = SyncInfo.kindToString((int)kind);
            return NLS.bind((String)TeamUIMessages.TeamSubscriberSyncPage_labelWithSyncKind, (Object)base, (Object)syncKindString);
        }
        return base;
    }

    protected Image getCompareImage(Image base, int kind) {
        switch (kind & 0xC) {
            case 4: {
                kind = kind & 0xFFFFFFFB | 8;
                break;
            }
            case 8: {
                kind = kind & 0xFFFFFFF7 | 4;
                break;
            }
        }
        return this.compareConfig.getImage(base, kind);
    }

    private Image propagateConflicts(Image base, ISynchronizeModelElement element) {
        int kind;
        ImageDescriptor[] overlayImages = new ImageDescriptor[4];
        boolean hasOverlay = false;
        if (element.getProperty("org.eclipse.team.ui.busy")) {
            overlayImages[0] = TeamUIPlugin.getImageDescriptor("ovr/waiting_ovr.gif");
            hasOverlay = true;
        }
        if (((kind = element.getKind()) & 0xC) != 12 && this.hasDecendantConflicts(element)) {
            overlayImages[3] = TeamUIPlugin.getImageDescriptor("ovr/confchg_ov.gif");
            hasOverlay = true;
        }
        if (this.hasErrorMarker(element)) {
            overlayImages[2] = TeamUIPlugin.getImageDescriptor("ovr/error_co.gif");
            hasOverlay = true;
        } else if (this.hasWarningMarker(element)) {
            overlayImages[2] = TeamUIPlugin.getImageDescriptor("ovr/warning_co.gif");
            hasOverlay = true;
        }
        if (hasOverlay) {
            Image conflictDecoratedImage;
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(base, overlayImages, new Point(base.getBounds().width, base.getBounds().height));
            if (this.fgImageCache == null) {
                this.fgImageCache = new HashMap<ImageDescriptor, Image>(10);
            }
            if ((conflictDecoratedImage = this.fgImageCache.get(overlay)) == null) {
                conflictDecoratedImage = overlay.createImage();
                this.fgImageCache.put((ImageDescriptor)overlay, conflictDecoratedImage);
            }
            return conflictDecoratedImage;
        }
        return base;
    }

    private boolean hasDecendantConflicts(ISynchronizeModelElement node) {
        return node.getProperty("org.eclipse.team.ui.conflict");
    }

    private boolean hasErrorMarker(ISynchronizeModelElement node) {
        return node.getProperty("org.eclipse.team.ui.error");
    }

    private boolean hasWarningMarker(ISynchronizeModelElement node) {
        return node.getProperty("org.eclipse.team.ui.warning");
    }

    public void dispose() {
        this.workbenchLabelProvider.dispose();
        if (this.busyFont != null) {
            this.busyFont.dispose();
        }
        this.compareConfig.dispose();
        if (this.fgImageCache != null) {
            for (Image element : this.fgImageCache.values()) {
                element.dispose();
            }
        }
    }
}

