/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoringCore;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFixCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;

public final class CreatePackageInfoWithDefaultNullnessProposalCore
extends ChangeCorrectionProposalCore {
    public final int fProblemId;
    public final ICompilationUnit fUnit;

    public static CreatePackageInfoWithDefaultNullnessProposalCore createFor(int problemId, String name, IPackageFragment pack) throws CoreException {
        int relevance = 5;
        String nonNullByDefaultAnnotationName = NullAnnotationsFixCore.getNonNullByDefaultAnnotationName((IJavaElement)pack, false);
        String lineDelimiter = StubUtility.getLineDelimiterUsed(pack.getJavaProject());
        StringBuilder content = new StringBuilder();
        String fileComment = CreatePackageInfoWithDefaultNullnessProposalCore.getFileComment("package-info.java", pack, lineDelimiter);
        String typeComment = CreatePackageInfoWithDefaultNullnessProposalCore.getTypeComment("package-info.java", pack, lineDelimiter);
        if (fileComment != null) {
            content.append(fileComment);
            content.append(lineDelimiter);
        }
        if (typeComment != null) {
            content.append(typeComment);
            content.append(lineDelimiter);
        } else if (fileComment != null) {
            content.append("/**");
            content.append(lineDelimiter);
            content.append(" *");
            content.append(lineDelimiter);
            content.append(" */");
            content.append(lineDelimiter);
        }
        content.append("@");
        content.append(nonNullByDefaultAnnotationName);
        content.append(lineDelimiter);
        content.append("package ");
        content.append(pack.getElementName());
        content.append(";");
        content.append(lineDelimiter);
        String source = content.toString();
        ICompilationUnit unit = pack.getCompilationUnit("package-info.java");
        CreateCompilationUnitChange change = new CreateCompilationUnitChange(unit, source, null);
        CreatePackageInfoWithDefaultNullnessProposalCore proposal = new CreatePackageInfoWithDefaultNullnessProposalCore(problemId, name, (Change)change, relevance, unit);
        return proposal;
    }

    private static String getFileComment(String fileName, IPackageFragment pack, String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = pack.getCompilationUnit(fileName);
        return CodeGeneration.getFileComment(cu, lineDelimiterUsed);
    }

    private static String getTypeComment(String fileName, IPackageFragment pack, String lineDelimiterUsed) throws CoreException {
        ICompilationUnit cu = pack.getCompilationUnit(fileName);
        String typeName = fileName.substring(0, fileName.length() - ".java".length());
        return CodeGeneration.getTypeComment(cu, typeName, lineDelimiterUsed);
    }

    public CreatePackageInfoWithDefaultNullnessProposalCore(int problemId, String name, Change change, int relevance, ICompilationUnit unit) {
        super(name, change, relevance);
        this.fProblemId = problemId;
        this.fUnit = unit;
    }

    public void resolve(CleanUpRefactoringCore.MultiFixTarget[] problems, IProgressMonitor monitor) throws CoreException {
        HashMap packageToTarget = new HashMap();
        ArrayList<IPackageFragment> removeList = new ArrayList<IPackageFragment>();
        CleanUpRefactoringCore.MultiFixTarget[] multiFixTargetArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            CleanUpRefactoringCore.MultiFixTarget problem = multiFixTargetArray[n2];
            IPackageFragment packageFragment = (IPackageFragment)problem.getCompilationUnit().getParent();
            ArrayList<CleanUpRefactoringCore.MultiFixTarget> list = (ArrayList<CleanUpRefactoringCore.MultiFixTarget>)packageToTarget.get(packageFragment.getElementName());
            if (list == null) {
                list = new ArrayList<CleanUpRefactoringCore.MultiFixTarget>();
                list.add(problem);
                packageToTarget.put(packageFragment.getElementName(), list);
            } else {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)packageFragment.getParent();
                boolean needToAdd = true;
                int i = 0;
                while (i < list.size()) {
                    CleanUpRefactoringCore.MultiFixTarget previous = (CleanUpRefactoringCore.MultiFixTarget)list.get(i);
                    IPackageFragmentRoot previousPackageFragmentRoot = (IPackageFragmentRoot)previous.getCompilationUnit().getParent().getParent();
                    if (Objects.equals(packageFragmentRoot.getJavaProject(), previousPackageFragmentRoot.getJavaProject())) {
                        if (packageFragmentRoot.getResource().getProjectRelativePath().toString().compareTo(previousPackageFragmentRoot.getResource().getProjectRelativePath().toString()) < 0) {
                            list.remove(i);
                            --i;
                        } else {
                            needToAdd = false;
                        }
                    } else if (packageFragmentRoot.getJavaProject().isOnClasspath((IJavaElement)previousPackageFragmentRoot.getJavaProject())) {
                        needToAdd = false;
                        removeList.add(packageFragment);
                    } else if (previousPackageFragmentRoot.getJavaProject().isOnClasspath((IJavaElement)packageFragmentRoot.getJavaProject())) {
                        list.remove(i);
                        --i;
                        removeList.add((IPackageFragment)previous.getCompilationUnit().getParent());
                    }
                    ++i;
                }
                if (needToAdd) {
                    list.add(problem);
                }
            }
            ++n2;
        }
        CompositeChange compositeChange = new CompositeChange(this.getName());
        for (Map.Entry entry : packageToTarget.entrySet()) {
            ArrayList list = (ArrayList)entry.getValue();
            for (CleanUpRefactoringCore.MultiFixTarget multiFixTarget : list) {
                CreatePackageInfoWithDefaultNullnessProposalCore createPackageInfoProposal = CreatePackageInfoWithDefaultNullnessProposalCore.createFor(this.fProblemId, this.getName(), (IPackageFragment)multiFixTarget.getCompilationUnit().getParent());
                compositeChange.add(createPackageInfoProposal.getChange());
            }
        }
        PerformChangeOperation operation = new PerformChangeOperation((Change)compositeChange);
        operation.setUndoManager(RefactoringCore.getUndoManager(), compositeChange.getName());
        operation.run(monitor);
        for (IPackageFragment packageFragment : removeList) {
            packageFragment.getResource().deleteMarkers("org.eclipse.jdt.core.problem", false, 0);
        }
    }
}

