/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractMethodDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.StatementRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.SnippetFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessorCore;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_EXCEPTIONS = "exceptions";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_SYNCHRONIZED = "synchronized";
    private ICompilationUnit fCUnit;
    private CompilationUnit fRoot;
    private ImportRewrite fImportRewriter;
    private int fSelectionStart;
    private int fSelectionLength;
    private AST fAST;
    private ASTRewrite fRewriter;
    private ExtractMethodAnalyzer fAnalyzer;
    private int fVisibility;
    private boolean fMakeFinal;
    private boolean fMakeSynchronized;
    private String fMethodName;
    private boolean fThrowRuntimeExceptions;
    private List<ParameterInfo> fParameterInfos;
    private Set<String> fUsedNames;
    private boolean fGenerateJavadoc;
    private boolean fReplaceDuplicates;
    private List<SnippetFinder.Match> fDuplicates;
    private int fDestinationIndex = 0;
    private ASTNode fDestination;
    private ASTNode[] fDestinations;
    private LinkedProposalModelCore fLinkedProposalModel;
    private Map<String, String> fFormatterOptions;
    private boolean fHasYield;
    private List<SimpleName> fFieldAccesses = new ArrayList<SimpleName>();
    private String fPassedTypeName;
    private static final String EMPTY = "";
    private static final String KEY_TYPE = "type";
    private static final String KEY_NAME = "name";

    public ExtractMethodRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this(unit, selectionStart, selectionLength, null);
    }

    public ExtractMethodRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength, Map<String, String> formatterOptions) {
        this.fCUnit = unit;
        this.fRoot = null;
        this.fMethodName = "extracted";
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fVisibility = -1;
        this.fMakeFinal = false;
        this.fMakeSynchronized = false;
        this.fFormatterOptions = formatterOptions;
    }

    public ExtractMethodRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public ExtractMethodRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength, Map<String, String> formatterOptions) {
        this((ICompilationUnit)astRoot.getTypeRoot(), selectionStart, selectionLength, formatterOptions);
        this.fRoot = astRoot;
    }

    public ExtractMethodRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        this((ICompilationUnit)astRoot.getTypeRoot(), selectionStart, selectionLength);
        this.fRoot = astRoot;
    }

    public void setLinkedProposalModel(LinkedProposalModelCore linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractMethodRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(EMPTY, 100);
        if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
            return this.mergeTextSelectionStatus(result);
        }
        IFile[] changedFiles = ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit});
        result.merge(Checks.validateModifiesFiles(changedFiles, this.getValidationContext(), pm));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])changedFiles, (IProgressMonitor)Progress.subMonitor(pm, 1)));
        if (this.fRoot == null) {
            this.fRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCUnit, true, Progress.subMonitor(pm, 99));
        }
        this.fImportRewriter = StubUtility.createImportRewrite(this.fRoot, true);
        this.fAST = this.fRoot.getAST();
        this.fRoot.accept(this.createVisitor());
        this.fSelectionStart = this.fAnalyzer.getSelection().getOffset();
        this.fSelectionLength = this.fAnalyzer.getSelection().getLength();
        result.merge(this.fAnalyzer.checkInitialConditions(this.fImportRewriter));
        if (this.fAnalyzer.isSelectionChanged()) {
            this.fRoot.accept((ASTVisitor)this.fAnalyzer);
            this.fSelectionStart = this.fAnalyzer.getSelection().getOffset();
            this.fSelectionLength = this.fAnalyzer.getSelection().getLength();
            result.merge(this.fAnalyzer.checkInitialConditions(this.fImportRewriter));
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fVisibility == -1) {
            this.setVisibility(2);
        }
        this.initializeParameterInfos();
        this.initializeUsedNames();
        this.initializeDuplicates();
        this.initializeDestinations();
        return result;
    }

    private ASTVisitor createVisitor() throws CoreException {
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        return this.fAnalyzer;
    }

    public void setMethodName(String name) {
        this.fMethodName = name;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setFinal(boolean isFinal) {
        this.fMakeFinal = isFinal;
    }

    public void setSynchronized(boolean isSynchronized) {
        this.fMakeSynchronized = isSynchronized;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getMakeFinal() {
        return this.fMakeFinal;
    }

    public boolean getMakeSynchronized() {
        return this.fMakeSynchronized;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setThrowRuntimeExceptions(boolean throwRuntimeExceptions) {
        this.fThrowRuntimeExceptions = throwRuntimeExceptions;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkMethodName(this.fMethodName, (IJavaElement)this.fCUnit);
    }

    public ASTNode[] getDestinations() {
        return this.fDestinations;
    }

    public void setDestination(int index) {
        this.fDestination = this.fDestinations[index];
        this.fDestinationIndex = index;
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        for (ParameterInfo parameter : this.fParameterInfos) {
            result.merge(Checks.checkIdentifier(parameter.getNewName(), (IJavaElement)this.fCUnit));
            for (ParameterInfo other : this.fParameterInfos) {
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_sameParameter, BasicElementLabels.getJavaElementName(other.getNewName())));
                return result;
            }
            if (!parameter.isRenamed() || !this.fUsedNames.contains(parameter.getNewName())) continue;
            result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_nameInUse, BasicElementLabels.getJavaElementName(parameter.getNewName())));
            return result;
        }
        return result;
    }

    public RefactoringStatus checkVarargOrder() {
        Iterator<ParameterInfo> iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = iter.next();
            if (!info.isOldVarargs() || !iter.hasNext()) continue;
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_vararg_ordering, BasicElementLabels.getJavaElementName(info.getOldName())));
        }
        return new RefactoringStatus();
    }

    public Set<String> getUsedNames() {
        return this.fUsedNames;
    }

    private void search(SearchPattern searchPattern, IJavaSearchScope scope, SearchRequestor requestor) throws CoreException {
        new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected RefactoringStatus checkForMethodOverride() {
        RefactoringStatus status = new RefactoringStatus();
        ITypeBinding type = null;
        if (this.fDestination instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)this.fDestination;
            type = decl.resolveBinding();
        } else if (this.fDestination instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fDestination;
            type = decl.resolveBinding();
        }
        if (type == null) {
            return status;
        }
        String typeName = type.getQualifiedName();
        SearchPattern pattern = SearchPattern.createPattern((String)typeName, (int)0, (int)1, (int)8);
        if (pattern == null) {
            return status;
        }
        TypeExtendsSearchRequestor requestor = new TypeExtendsSearchRequestor();
        try {
            this.search(pattern, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type.getJavaElement().getJavaProject()}), requestor);
        }
        catch (CoreException e) {
            return status;
        }
        List<SearchMatch> results = requestor.getResults();
        for (SearchMatch result : results) {
            Object obj = result.getElement();
            if (!(obj instanceof IType)) continue;
            IType resultType = (IType)obj;
            try {
                ASTNode typeDecl = null;
                if (resultType.isLocal() || resultType.isAnonymous() || resultType.isMember()) {
                    ICompilationUnit icu = resultType.getCompilationUnit();
                    typeDecl = this.getTypeDeclaration(resultType, icu);
                }
                if (typeDecl == null) continue;
                CheckMethodConflictVisitor visitor = new CheckMethodConflictVisitor(this.fMethodName);
                try {
                    typeDecl.accept((ASTVisitor)visitor);
                }
                catch (AbortSearchException e) {
                    status.merge(RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_method_will_override_call_in_subclass, resultType.getFullyQualifiedName('.'))));
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return status;
    }

    private ASTNode getTypeDeclaration(IType iType, ICompilationUnit icu) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(8);
        parser.setSource(icu);
        parser.setResolveBindings(true);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        ASTNode perform = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)iType.getSourceRange());
        if (perform instanceof TypeDeclaration && ((TypeDeclaration)perform).resolveBinding() != null) {
            return perform;
        }
        if (perform instanceof AnonymousClassDeclaration && ((AnonymousClassDeclaration)perform).resolveBinding() != null) {
            return perform;
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ExtractMethodRefactoring_checking_new_name, 2);
        pm.subTask(EMPTY);
        RefactoringStatus result = this.checkMethodName();
        result.merge(this.checkParameterNames());
        result.merge(this.checkVarargOrder());
        result.merge(this.checkForMethodOverride());
        pm.worked(1);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        BodyDeclaration node = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (node != null) {
            this.fAnalyzer.checkInput(result, this.fMethodName, this.fDestination);
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fMethodName == null) {
            return null;
        }
        pm.beginTask(EMPTY, 2);
        try {
            this.fAnalyzer.aboutToCreateChange();
            BodyDeclaration declaration = this.fAnalyzer.getEnclosingBodyDeclaration();
            this.fRewriter = ASTRewrite.create((AST)declaration.getAST());
            CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.ExtractMethodRefactoring_change_name, this.fCUnit);
            result.setSaveMode(1);
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.getRefactoringDescriptor()));
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            ASTNode[] selectedNodes = this.fAnalyzer.getSelectedNodes();
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(selectedNodes, this.fCUnit.getBuffer(), this.fSelectionStart, this.fSelectionLength));
            TextEditGroup substituteDesc = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_substitute_with_call, BasicElementLabels.getJavaElementName(this.fMethodName)));
            result.addTextEditGroup(substituteDesc);
            MethodDeclaration mm = this.createNewMethod(selectedNodes, this.fCUnit.findRecommendedLineSeparator(), substituteDesc);
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroupCore typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
                typeGroup.addPosition(this.fRewriter.track((ASTNode)mm.getReturnType2()), false);
                ITypeBinding typeBinding = this.fAnalyzer.getReturnTypeBinding();
                if (typeBinding != null) {
                    ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes(this.fAST, typeBinding);
                    int i = 0;
                    while (i < relaxingTypes.length) {
                        typeGroup.addProposal(relaxingTypes[i], this.fCUnit, relaxingTypes.length - i);
                        ++i;
                    }
                }
                LinkedProposalPositionGroupCore nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
                nameGroup.addPosition(this.fRewriter.track((ASTNode)mm.getName()), false);
                ModifierCorrectionSubProcessorCore.installLinkedVisibilityProposals(this.fLinkedProposalModel, this.fRewriter, mm.modifiers(), false);
            }
            TextEditGroup insertDesc = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_add_method, BasicElementLabels.getJavaElementName(this.fMethodName)));
            result.addTextEditGroup(insertDesc);
            if (this.fDestination == ASTResolving.findParentType(declaration.getParent())) {
                ChildListPropertyDescriptor desc = (ChildListPropertyDescriptor)declaration.getLocationInParent();
                ListRewrite container = this.fRewriter.getListRewrite(declaration.getParent(), desc);
                container.insertAfter((ASTNode)mm, (ASTNode)declaration, insertDesc);
            } else {
                BodyDeclarationRewrite container = BodyDeclarationRewrite.create(this.fRewriter, this.fDestination);
                container.insert((BodyDeclaration)mm, insertDesc);
            }
            this.replaceDuplicates(result, mm.getModifiers());
            this.replaceBranches(result);
            if (this.fImportRewriter.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewriter.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.ExtractMethodRefactoring_organize_imports, new TextEdit[]{edit}));
            }
            try {
                Map formatter = this.fFormatterOptions == null ? this.fCUnit.getOptions(true) : this.fFormatterOptions;
                Document document = new Document(this.fCUnit.getSource());
                root.addChild(this.fRewriter.rewriteAST((IDocument)document, formatter));
            }
            catch (JavaModelException e) {
                root.addChild(this.fRewriter.rewriteAST());
            }
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void replaceBranches(final CompilationUnitChange result) {
        ASTNode[] aSTNodeArray = this.fAnalyzer.getSelectedNodes();
        int n = aSTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode astNode = aSTNodeArray[n2];
            astNode.accept(new ASTVisitor(){
                private LinkedList<String> fOpenLoopLabels = new LinkedList();

                private void registerLoopLabel(Statement node) {
                    String identifier;
                    if (node.getParent() instanceof LabeledStatement) {
                        LabeledStatement labeledStatement = (LabeledStatement)node.getParent();
                        identifier = labeledStatement.getLabel().getIdentifier();
                    } else {
                        identifier = null;
                    }
                    this.fOpenLoopLabels.add(identifier);
                }

                public boolean visit(ForStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(ForStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(WhileStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(WhileStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(EnhancedForStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(EnhancedForStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(DoStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(DoStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public void endVisit(ContinueStatement node) {
                    SimpleName label = node.getLabel();
                    if (this.fOpenLoopLabels.isEmpty() || label != null && !this.fOpenLoopLabels.contains(label.getIdentifier())) {
                        TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.ExtractMethodRefactoring_replace_continue);
                        result.addTextEditGroup(description);
                        ReturnStatement rs = ExtractMethodRefactoring.this.fAST.newReturnStatement();
                        IVariableBinding returnValue = ExtractMethodRefactoring.this.fAnalyzer.getReturnValue();
                        if (returnValue != null) {
                            rs.setExpression((Expression)ExtractMethodRefactoring.this.fAST.newSimpleName(ExtractMethodRefactoring.this.getName(returnValue)));
                        }
                        ExtractMethodRefactoring.this.fRewriter.replace((ASTNode)node, (ASTNode)rs, description);
                    }
                }
            });
            ++n2;
        }
    }

    private ExtractMethodDescriptor getRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCUnit.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        ITypeBinding type = null;
        if (this.fDestination instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)this.fDestination;
            type = decl.resolveBinding();
        } else if (this.fDestination instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fDestination;
            type = decl.resolveBinding();
        }
        IMethodBinding method = null;
        BodyDeclaration enclosing = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (enclosing instanceof MethodDeclaration) {
            MethodDeclaration node = (MethodDeclaration)enclosing;
            method = node.resolveBinding();
        }
        int flags = 786434;
        String description = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fMethodName));
        String label = method != null ? BindingLabelProviderCore.getBindingLabel((IBinding)method, 2235681801344L) : "{...}";
        String header = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.getSignature()), label, BindingLabelProviderCore.getBindingLabel((IBinding)type, 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_name_pattern, BasicElementLabels.getJavaElementName(this.fMethodName)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_destination_pattern, BindingLabelProviderCore.getBindingLabel((IBinding)type, 2235681801344L)));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if (EMPTY.equals(visibility)) {
            visibility = RefactoringCoreMessages.ExtractMethodRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_visibility_pattern, visibility));
        if (this.fThrowRuntimeExceptions) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_declare_thrown_exceptions);
        }
        if (this.fReplaceDuplicates) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_replace_occurrences);
        }
        if (this.fGenerateJavadoc) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_generate_comment);
        }
        ExtractMethodDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractMethodDescriptor(project, description, comment.asString(), arguments, 786434);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCUnit));
        arguments.put(KEY_NAME, this.fMethodName);
        arguments.put("selection", Integer.toString(this.fSelectionStart) + " " + Integer.toString(this.fSelectionLength));
        arguments.put(ATTRIBUTE_VISIBILITY, Integer.toString(this.fVisibility));
        arguments.put(ATTRIBUTE_FINAL, Boolean.toString(this.fMakeFinal));
        arguments.put(ATTRIBUTE_SYNCHRONIZED, Boolean.toString(this.fMakeSynchronized));
        arguments.put(ATTRIBUTE_DESTINATION, Integer.toString(this.fDestinationIndex));
        arguments.put(ATTRIBUTE_EXCEPTIONS, Boolean.toString(this.fThrowRuntimeExceptions));
        arguments.put(ATTRIBUTE_COMMENTS, Boolean.toString(this.fGenerateJavadoc));
        arguments.put(ATTRIBUTE_REPLACE, Boolean.toString(this.fReplaceDuplicates));
        return descriptor;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String methodName) {
        MethodDeclaration methodDecl = this.createNewMethodDeclaration();
        methodDecl.setBody(null);
        String str = ASTNodes.asString((ASTNode)methodDecl);
        return str.substring(0, str.indexOf(59));
    }

    public int getNumberOfDuplicates() {
        if (this.fDuplicates == null) {
            return 0;
        }
        int result = 0;
        for (SnippetFinder.Match duplicate : this.fDuplicates) {
            if (duplicate.isInvalidNode()) continue;
            ++result;
        }
        return result;
    }

    public boolean getReplaceDuplicates() {
        return this.fReplaceDuplicates;
    }

    public void setReplaceDuplicates(boolean replace) {
        this.fReplaceDuplicates = replace;
    }

    public void setGenerateJavadoc(boolean generate) {
        this.fGenerateJavadoc = generate;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    public boolean isDestinationInterface() {
        return this.fDestination instanceof TypeDeclaration && ((TypeDeclaration)this.fDestination).isInterface();
    }

    private void initializeParameterInfos() {
        IVariableBinding[] arguments = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList<ParameterInfo>(arguments.length);
        BodyDeclaration root = this.fAnalyzer.getEnclosingBodyDeclaration();
        ParameterInfo vararg = null;
        int i = 0;
        while (i < arguments.length) {
            IVariableBinding argument = arguments[i];
            if (argument != null) {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration(argument, (ASTNode)root);
                boolean isVarargs = declaration instanceof SingleVariableDeclaration ? ((SingleVariableDeclaration)declaration).isVarargs() : false;
                ParameterInfo info = new ParameterInfo(argument, this.getType(declaration, isVarargs, false), argument.getName(), i);
                if (isVarargs) {
                    vararg = info;
                } else {
                    this.fParameterInfos.add(info);
                }
            }
            ++i;
        }
        if (vararg != null) {
            this.fParameterInfos.add(vararg);
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = UsedNamesCollector.perform(this.fAnalyzer.getSelectedNodes());
        for (ParameterInfo parameter : this.fParameterInfos) {
            this.fUsedNames.remove(parameter.getOldName());
        }
    }

    private void initializeDuplicates() {
        BodyDeclaration start = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (!(start instanceof AbstractTypeDeclaration)) {
            start = start.getParent();
        }
        this.fDuplicates = this.findValidDuplicates((ASTNode)start);
        this.fReplaceDuplicates = this.fDuplicates.size() > 0 && !this.fAnalyzer.isLiteralNodeSelected();
    }

    private List<SnippetFinder.Match> findValidDuplicates(ASTNode startNode) {
        List<SnippetFinder.Match> duplicates = SnippetFinder.perform(startNode, this.fAnalyzer.getSelectedNodes());
        ArrayList<SnippetFinder.Match> validDuplicates = new ArrayList<SnippetFinder.Match>();
        for (SnippetFinder.Match duplicate : duplicates) {
            if (duplicate == null || duplicate.isInvalidNode()) continue;
            try {
                boolean matches;
                ASTNode[] nodes = duplicate.getNodes();
                int duplicateStart = nodes[0].getStartPosition();
                ASTNode lastNode = nodes[nodes.length - 1];
                int duplicateEnd = lastNode.getStartPosition() + lastNode.getLength();
                int duplicateLength = duplicateEnd - duplicateStart;
                ExtractMethodAnalyzer analyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(duplicateStart, duplicateLength));
                this.fRoot.accept((ASTVisitor)analyzer);
                RefactoringStatus result = new RefactoringStatus();
                result.merge(analyzer.checkInitialConditions(this.fImportRewriter));
                if (result.hasFatalError()) continue;
                ITypeBinding originalReturnTypeBinding = this.fAnalyzer.getReturnTypeBinding();
                ITypeBinding duplicateReturnTypeBinding = analyzer.getReturnTypeBinding();
                if (originalReturnTypeBinding == null && duplicateReturnTypeBinding == null) {
                    validDuplicates.add(duplicate);
                    continue;
                }
                if (originalReturnTypeBinding == null || duplicateReturnTypeBinding == null) continue;
                if (!originalReturnTypeBinding.equals((Object)duplicateReturnTypeBinding)) {
                    if (!duplicateReturnTypeBinding.equals((Object)startNode.getAST().resolveWellKnownType("void"))) continue;
                    validDuplicates.add(duplicate);
                    continue;
                }
                IVariableBinding originalReturnValBinding = this.fAnalyzer.getReturnValue();
                IVariableBinding duplicateReturnValBinding = analyzer.getReturnValue();
                if (originalReturnValBinding == null && duplicateReturnValBinding == null) {
                    validDuplicates.add(duplicate);
                    continue;
                }
                if (originalReturnValBinding == null || duplicateReturnValBinding == null) continue;
                BodyDeclaration originalEnclosingBodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
                BodyDeclaration duplicateEnclosingBodyDeclaration = analyzer.getEnclosingBodyDeclaration();
                VariableDeclaration originalReturnNode = ASTNodes.findVariableDeclaration(originalReturnValBinding, (ASTNode)originalEnclosingBodyDeclaration);
                VariableDeclaration duplicateReturnNode = ASTNodes.findVariableDeclaration(duplicateReturnValBinding, (ASTNode)duplicateEnclosingBodyDeclaration);
                if (originalReturnNode == null || duplicateReturnNode == null || !(matches = !this.fAnalyzer.getSelection().covers((ASTNode)originalReturnNode) && !analyzer.getSelection().covers((ASTNode)duplicateReturnNode) ? true : this.matchesLocationInEnclosingBodyDecl(originalEnclosingBodyDeclaration, duplicateEnclosingBodyDeclaration, originalReturnNode, duplicateReturnNode))) continue;
                validDuplicates.add(duplicate);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return validDuplicates;
    }

    private boolean matchesLocationInEnclosingBodyDecl(BodyDeclaration originalEnclosingBodyDeclaration, BodyDeclaration duplicateEnclosingBodyDeclaration, VariableDeclaration originalReturnNode, VariableDeclaration duplicateReturnNode) {
        boolean matches = true;
        VariableDeclaration original = originalReturnNode;
        VariableDeclaration dupliacte = duplicateReturnNode;
        do {
            ASTNode originalParent = original.getParent();
            ASTNode duplicateParent = dupliacte.getParent();
            StructuralPropertyDescriptor originalLoc = original.getLocationInParent();
            StructuralPropertyDescriptor duplicateLoc = dupliacte.getLocationInParent();
            if (originalParent != null && duplicateParent != null && originalLoc.getNodeClass().equals(duplicateLoc.getNodeClass()) && originalLoc.getId().equals(duplicateLoc.getId())) {
                int indexOfDuplicate;
                int indexOfOriginal;
                if (originalLoc.isChildListProperty() && duplicateLoc.isChildListProperty() && (indexOfOriginal = ((List)originalParent.getStructuralProperty(originalLoc)).indexOf(original)) != (indexOfDuplicate = ((List)duplicateParent.getStructuralProperty(duplicateLoc)).indexOf(dupliacte))) {
                    matches = false;
                    break;
                }
            } else {
                matches = false;
                break;
            }
            original = originalParent;
            dupliacte = duplicateParent;
            if ((!originalEnclosingBodyDeclaration.equals((Object)original) || duplicateEnclosingBodyDeclaration.equals((Object)dupliacte)) && (originalEnclosingBodyDeclaration.equals((Object)original) || !duplicateEnclosingBodyDeclaration.equals((Object)dupliacte))) continue;
            matches = false;
            break;
        } while (!originalEnclosingBodyDeclaration.equals((Object)original) && !duplicateEnclosingBodyDeclaration.equals((Object)dupliacte));
        return matches;
    }

    private void initializeDestinations() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        BodyDeclaration decl = this.fAnalyzer.getEnclosingBodyDeclaration();
        ASTNode current = ASTResolving.findParentType(decl.getParent());
        if (this.fAnalyzer.isValidDestination(current)) {
            result.add(current);
        }
        if (current != null && (decl instanceof MethodDeclaration || decl instanceof Initializer || decl instanceof FieldDeclaration)) {
            ITypeBinding binding = ASTNodes.getEnclosingType(current);
            ASTNode next = ASTResolving.findParentType(current.getParent());
            while (next != null && binding != null && binding.isNested()) {
                if (this.fAnalyzer.isValidDestination(next)) {
                    result.add(next);
                }
                current = next;
                binding = ASTNodes.getEnclosingType(current);
                next = ASTResolving.findParentType(next.getParent());
            }
        }
        this.fDestinations = result.toArray(new ASTNode[result.size()]);
        this.fDestination = this.fDestinations[this.fDestinationIndex];
    }

    private RefactoringStatus mergeTextSelectionStatus(RefactoringStatus status) {
        status.addFatalError(RefactoringCoreMessages.ExtractMethodRefactoring_no_set_of_statements);
        return status;
    }

    private String getType(VariableDeclaration declaration, boolean isVarargs) {
        String type = ASTNodes.asString((ASTNode)ASTNodeFactory.newType(declaration.getAST(), declaration, this.fImportRewriter, new ContextSensitiveImportRewriteContext((ASTNode)declaration, this.fImportRewriter)));
        if (isVarargs) {
            return type + "...";
        }
        return type;
    }

    private String getType(VariableDeclaration declaration, boolean isVarargs, boolean isVarTypeAllowed) {
        if (isVarTypeAllowed) {
            return this.getType(declaration, isVarargs);
        }
        String type = ASTNodes.asString((ASTNode)ASTNodeFactory.newNonVarType(declaration.getAST(), declaration, this.fImportRewriter, new ContextSensitiveImportRewriteContext((ASTNode)declaration, this.fImportRewriter)));
        if (isVarargs) {
            return type + "...";
        }
        return type;
    }

    private ASTNode[] createCallNodes(SnippetFinder.Match duplicate, int modifiers) {
        ArrayList<Object> result = new ArrayList<Object>(2);
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getCallerLocals();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding local = iVariableBindingArray[n2];
            result.add(this.createDeclaration(local, null));
            ++n2;
        }
        MethodInvocation invocation = this.fAST.newMethodInvocation();
        invocation.setName(this.fAST.newSimpleName(this.fMethodName));
        ASTNode typeNode = ASTResolving.findParentType((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        RefactoringStatus status = new RefactoringStatus();
        while (this.fDestination != typeNode) {
            this.fAnalyzer.checkInput(status, this.fMethodName, typeNode);
            if (!status.isOK()) {
                SimpleName destinationTypeName = this.fAST.newSimpleName(ASTNodes.getEnclosingType(this.fDestination).getName());
                if ((modifiers & 8) == 0) {
                    ThisExpression thisExpression = this.fAST.newThisExpression();
                    thisExpression.setQualifier((Name)destinationTypeName);
                    invocation.setExpression((Expression)thisExpression);
                    break;
                }
                invocation.setExpression((Expression)destinationTypeName);
                break;
            }
            typeNode = typeNode.getParent();
        }
        List arguments = invocation.arguments();
        if (!this.fFieldAccesses.isEmpty()) {
            arguments.add(this.fAST.newThisExpression());
        }
        for (ParameterInfo parameter : this.fParameterInfos) {
            arguments.add(ASTNodeFactory.newName(this.fAST, this.getMappedName(duplicate, parameter)));
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroupCore nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(this.fRewriter.track((ASTNode)invocation.getName()), false);
        }
        int returnKind = this.fAnalyzer.getReturnKind();
        MethodInvocation call = switch (returnKind) {
            case 2 -> {
                IVariableBinding binding = this.fAnalyzer.getReturnLocal();
                if (binding != null) {
                    VariableDeclarationStatement decl = this.createDeclaration(this.getMappedBinding(duplicate, binding), (Expression)invocation);
                    yield decl;
                }
                Assignment assignment = this.fAST.newAssignment();
                assignment.setLeftHandSide((Expression)ASTNodeFactory.newName(this.fAST, this.getMappedBinding(duplicate, this.fAnalyzer.getReturnValue()).getName()));
                assignment.setRightHandSide((Expression)invocation);
                yield assignment;
            }
            case 4 -> {
                YieldStatementCheckerReplacer yieldChecker = new YieldStatementCheckerReplacer(this.fAnalyzer.getSelectedNodeRange());
                ASTNode[] var15_17 = this.fAnalyzer.getSelectedNodes();
                int var14_18 = var15_17.length;
                int var13_19 = 0;
                while (var13_19 < var14_18) {
                    ASTNode node = var15_17[var13_19];
                    node.accept((ASTVisitor)yieldChecker);
                    ++var13_19;
                }
                ReturnStatement rs = null;
                if (yieldChecker.hasYield() && !yieldChecker.hasReturn()) {
                    rs = this.fAST.newYieldStatement();
                    ((YieldStatement)rs).setExpression((Expression)invocation);
                    this.fHasYield = true;
                } else {
                    rs = this.fAST.newReturnStatement();
                    rs.setExpression((Expression)invocation);
                }
                yield rs;
            }
            default -> invocation;
        };
        if (call instanceof Expression && !this.fAnalyzer.isExpressionSelected()) {
            call = this.fAST.newExpressionStatement((Expression)call);
        }
        result.add(call);
        return result.toArray(new ASTNode[result.size()]);
    }

    private IVariableBinding getMappedBinding(SnippetFinder.Match duplicate, IVariableBinding org) {
        if (duplicate == null) {
            return org;
        }
        return duplicate.getMappedBinding(org);
    }

    private String getMappedName(SnippetFinder.Match duplicate, ParameterInfo paramter) {
        if (duplicate == null) {
            return paramter.getOldName();
        }
        return duplicate.getMappedName(paramter.getOldBinding()).getIdentifier();
    }

    /*
     * Unable to fully structure code
     */
    private void replaceDuplicates(CompilationUnitChange result, int modifiers) {
        numberOf = this.getNumberOfDuplicates();
        if (numberOf == 0 || !this.fReplaceDuplicates) {
            return;
        }
        label = null;
        label = numberOf == 1 ? Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_single, BasicElementLabels.getJavaElementName(this.fMethodName)) : Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_multi, BasicElementLabels.getJavaElementName(this.fMethodName));
        description = new TextEditGroup(label);
        result.addTextEditGroup(description);
        for (SnippetFinder.Match duplicate : this.fDuplicates) {
            if (duplicate.isInvalidNode() || !this.isDestinationReachable(duplicate.getEnclosingMethod())) continue;
            callNodes = this.createCallNodes(duplicate, modifiers);
            duplicateNodes = duplicate.getNodes();
            i = 0;
            ** GOTO lbl18
            {
                duplicateNodes[i] = duplicateNodes[i].getParent();
                do {
                    if (duplicateNodes[i].getParent() instanceof ParenthesizedExpression) continue block1;
                    ++i;
lbl18:
                    // 2 sources

                } while (i < duplicateNodes.length);
            }
            new StatementRewrite(this.fRewriter, duplicateNodes).replace(callNodes, description);
        }
    }

    private boolean forceStatic() {
        if (!this.fReplaceDuplicates) {
            return false;
        }
        for (SnippetFinder.Match duplicate : this.fDuplicates) {
            if (duplicate.isInvalidNode() || !duplicate.isNodeInStaticContext()) continue;
            return true;
        }
        return false;
    }

    private boolean isDestinationReachable(MethodDeclaration methodDeclaration) {
        MethodDeclaration start = methodDeclaration;
        while (start != null && start != this.fDestination) {
            start = start.getParent();
        }
        return start == this.fDestination;
    }

    private MethodDeclaration createNewMethod(ASTNode[] selectedNodes, String lineDelimiter, TextEditGroup substitute) throws CoreException {
        AbstractTypeDeclaration enclosingType;
        String string;
        MethodDeclaration result = this.createNewMethodDeclaration();
        result.setBody(this.createMethodBody(selectedNodes, substitute, result.getModifiers()));
        if (this.fGenerateJavadoc && (string = CodeGeneration.getMethodComment(this.fCUnit, (enclosingType = ASTNodes.getParent((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), AbstractTypeDeclaration.class)).getName().getIdentifier(), result, null, lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private MethodDeclaration createNewMethodDeclaration() {
        int n;
        ITypeBinding[] iTypeBindingArray;
        TypeParameter parameter;
        MethodDeclaration result = this.fAST.newMethodDeclaration();
        int modifiers = this.fVisibility;
        BodyDeclaration enclosingBodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        boolean isDestinationInterface = this.isDestinationInterface();
        if (!(!isDestinationInterface || enclosingBodyDeclaration instanceof MethodDeclaration && enclosingBodyDeclaration.getParent() == this.fDestination && Modifier.isPublic((int)enclosingBodyDeclaration.getModifiers()))) {
            modifiers = 0;
        }
        boolean shouldBeStatic = false;
        BodyDeclaration currentParent = enclosingBodyDeclaration;
        do {
            if (currentParent instanceof BodyDeclaration) {
                shouldBeStatic = shouldBeStatic || JdtFlags.isStatic(currentParent);
            }
            currentParent = currentParent.getParent();
        } while (!shouldBeStatic && currentParent != null && currentParent != this.fDestination);
        if (shouldBeStatic || this.fAnalyzer.getForceStatic() || this.forceStatic()) {
            modifiers |= 8;
        } else if (isDestinationInterface) {
            modifiers |= 0x10000;
        }
        if (this.fMakeFinal && !isDestinationInterface) {
            modifiers |= 0x10;
        }
        if (this.fMakeSynchronized && !isDestinationInterface) {
            modifiers |= 0x20;
        }
        List typeParameters = result.typeParameters();
        ITypeBinding[] iTypeBindingArray2 = this.computeLocalTypeVariables(modifiers);
        int n2 = iTypeBindingArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            ITypeBinding typeVariable = iTypeBindingArray2[n3];
            parameter = this.fAST.newTypeParameter();
            parameter.setName(this.fAST.newSimpleName(typeVariable.getName()));
            iTypeBindingArray = typeVariable.getTypeBounds();
            n = iTypeBindingArray.length;
            int n4 = 0;
            while (n4 < n) {
                ITypeBinding bound = iTypeBindingArray[n4];
                if (!"java.lang.Object".equals(bound.getQualifiedName())) {
                    parameter.typeBounds().add(this.fImportRewriter.addImport(bound, this.fAST));
                }
                ++n4;
            }
            typeParameters.add(parameter);
            ++n3;
        }
        result.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, modifiers));
        result.setReturnType2((Type)ASTNode.copySubtree((AST)this.fAST, (ASTNode)this.fAnalyzer.getReturnType()));
        result.setName(this.fAST.newSimpleName(this.fMethodName));
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)enclosingBodyDeclaration, this.fImportRewriter);
        ASTNode enclosingType = ASTNodes.getFirstAncestorOrNull((ASTNode)enclosingBodyDeclaration, AbstractTypeDeclaration.class, AnonymousClassDeclaration.class);
        if (enclosingType != this.fDestination && enclosingType instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)enclosingType;
            this.fFieldAccesses = this.fAnalyzer.findFieldReferencesForType(typeDeclaration);
        }
        List parameters = result.parameters();
        if (!this.fFieldAccesses.isEmpty()) {
            parameter = this.fAST.newSingleVariableDeclaration();
            ITypeBinding typeBinding = ((AbstractTypeDeclaration)enclosingType).resolveBinding();
            parameter.setType(this.fImportRewriter.addImport(typeBinding, this.fAST));
            this.fImportRewriter.removeImport(typeBinding.getQualifiedName());
            this.fPassedTypeName = "passed" + ((AbstractTypeDeclaration)enclosingType).getName().getFullyQualifiedName();
            parameter.setName(this.fAST.newSimpleName(this.fPassedTypeName));
            parameters.add(parameter);
        }
        for (ParameterInfo info : this.fParameterInfos) {
            VariableDeclaration infoDecl = this.getVariableDeclaration(info);
            SingleVariableDeclaration parameter2 = this.fAST.newSingleVariableDeclaration();
            parameter2.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, ASTNodes.getModifiers(infoDecl)));
            parameter2.setType(ASTNodeFactory.newNonVarType(this.fAST, infoDecl, this.fImportRewriter, context));
            parameter2.setName(this.fAST.newSimpleName(info.getNewName()));
            parameter2.setVarargs(info.isNewVarargs());
            parameters.add(parameter2);
        }
        List exceptions = result.thrownExceptionTypes();
        iTypeBindingArray = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions);
        n = iTypeBindingArray.length;
        int n5 = 0;
        while (n5 < n) {
            ITypeBinding exceptionType = iTypeBindingArray[n5];
            exceptions.add(this.fImportRewriter.addImport(exceptionType, this.fAST, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.EXCEPTION));
            ++n5;
        }
        return result;
    }

    private ITypeBinding[] computeLocalTypeVariables(int modifier) {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>(Arrays.asList(this.fAnalyzer.getTypeVariables()));
        for (ParameterInfo info : this.fParameterInfos) {
            this.processVariable(result, info.getOldBinding(), modifier);
        }
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getMethodLocals();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding methodLocal = iVariableBindingArray[n2];
            this.processVariable(result, methodLocal, modifier);
            ++n2;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void processVariable(List<ITypeBinding> result, IVariableBinding variable, int modifier) {
        if (variable == null) {
            return;
        }
        ITypeBinding binding = variable.getType();
        if (binding != null && binding.isParameterizedType()) {
            ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding arg = iTypeBindingArray[n2];
                if (arg.isTypeVariable() && !result.contains(arg)) {
                    ASTNode parent;
                    ASTNode decl = this.fRoot.findDeclaringNode((IBinding)arg);
                    if (decl != null && ((parent = decl.getParent()) instanceof MethodDeclaration || parent instanceof TypeDeclaration && Modifier.isStatic((int)modifier))) {
                        result.add(arg);
                    }
                } else {
                    ASTNode parent;
                    ASTNode decl;
                    ITypeBinding bound = arg.getBound();
                    if (arg.isWildcardType() && bound != null && !result.contains(bound) && (decl = this.fRoot.findDeclaringNode((IBinding)bound)) != null && ((parent = decl.getParent()) instanceof MethodDeclaration || parent instanceof TypeDeclaration && Modifier.isStatic((int)modifier))) {
                        result.add(bound);
                    }
                }
                ++n2;
            }
        }
    }

    private Block createMethodBody(ASTNode[] selectedNodes, TextEditGroup substitute, int modifiers) {
        int n;
        SimpleName simpleName;
        int needed;
        SimpleName firstNode;
        Block result = this.fAST.newBlock();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)result, Block.STATEMENTS_PROPERTY);
        IRegion selectedNodeRange = this.fAnalyzer.getSelectedNodeRange();
        int endOfSelectedNodes = selectedNodeRange.getOffset() + selectedNodeRange.getLength();
        IVariableBinding[] iVariableBindingArray = this.fAnalyzer.getMethodLocals();
        int n2 = iVariableBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IVariableBinding methodLocal = iVariableBindingArray[n3];
            if (methodLocal != null) {
                result.statements().add(this.createDeclaration(methodLocal, null));
                SimpleName[] nodes = LinkedNodeFinder.findByBinding((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), (IBinding)methodLocal);
                firstNode = nodes[0];
                VariableDeclarationStatement vdecl = ASTNodes.getFirstAncestorOrNull((ASTNode)firstNode, VariableDeclarationStatement.class);
                if (vdecl != null) {
                    needed = 0;
                    int i = 1;
                    while (i < nodes.length) {
                        SimpleName refNode = nodes[i];
                        if (refNode.getStartPosition() < selectedNodeRange.getOffset() || refNode.getStartPosition() > endOfSelectedNodes) {
                            needed = 1;
                            break;
                        }
                        ++i;
                    }
                    if (needed == 0) {
                        this.fRewriter.remove((ASTNode)vdecl, null);
                    }
                }
            }
            ++n3;
        }
        for (ParameterInfo parameter : this.fParameterInfos) {
            if (!parameter.isRenamed()) continue;
            firstNode = selectedNodes;
            int nodes = ((ASTNode[])firstNode).length;
            int n4 = 0;
            while (n4 < nodes) {
                SimpleName selectedNode = firstNode[n4];
                simpleName = LinkedNodeFinder.findByBinding((ASTNode)selectedNode, (IBinding)parameter.getOldBinding());
                n = ((SimpleName[])simpleName).length;
                needed = 0;
                while (needed < n) {
                    SimpleName oldName = simpleName[needed];
                    this.fRewriter.replace((ASTNode)oldName, (ASTNode)this.fAST.newSimpleName(parameter.getNewName()), null);
                    ++needed;
                }
                ++n4;
            }
        }
        for (SimpleName fieldAccess : this.fFieldAccesses) {
            FieldAccess newFieldAccess = this.fAST.newFieldAccess();
            newFieldAccess.setExpression((Expression)this.fAST.newSimpleName(this.fPassedTypeName));
            newFieldAccess.setName((SimpleName)this.fRewriter.createCopyTarget((ASTNode)fieldAccess));
            this.fRewriter.replace((ASTNode)fieldAccess, (ASTNode)newFieldAccess, null);
        }
        boolean extractsExpression = this.fAnalyzer.isExpressionSelected();
        ASTNode[] callNodes = this.createCallNodes(null, modifiers);
        ASTNode replacementNode = callNodes.length == 1 ? callNodes[0] : this.fRewriter.createGroupNode(callNodes);
        if (extractsExpression) {
            ITypeBinding binding = this.fAnalyzer.getExpressionBinding();
            if (!(binding == null || binding.isPrimitive() && "void".equals(binding.getName()))) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fRewriter.createMoveTarget(ASTNodes.getUnparenthesedExpression((ASTNode)selectedNodes[0])));
                statements.insertLast((ASTNode)rs, null);
            } else {
                ExpressionStatement st = this.fAST.newExpressionStatement((Expression)this.fRewriter.createMoveTarget((ASTNode)selectedNodes[0]));
                statements.insertLast((ASTNode)st, null);
            }
            SimpleName parenthesizedNode = selectedNodes[0];
            while (parenthesizedNode.getParent() instanceof ParenthesizedExpression) {
                parenthesizedNode = parenthesizedNode.getParent();
            }
            this.fRewriter.replace((ASTNode)parenthesizedNode, replacementNode, substitute);
        } else {
            boolean isReturnVoid;
            boolean bl = isReturnVoid = selectedNodes[((SimpleName)selectedNodes).length - 1] instanceof ReturnStatement && this.fAnalyzer.getReturnTypeBinding().equals((Object)this.fAST.resolveWellKnownType("void"));
            if (((SimpleName)selectedNodes).length == 1) {
                if (!isReturnVoid) {
                    if (this.fHasYield) {
                        YieldStatementCheckerReplacer yieldChecker = new YieldStatementCheckerReplacer(this.fRewriter, this.fAnalyzer.getSelectedNodeRange());
                        selectedNodes[0].accept((ASTVisitor)yieldChecker);
                    }
                    if (selectedNodes[0] instanceof Block) {
                        Block block = (Block)selectedNodes[0];
                        ListRewrite source = this.fRewriter.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                        List blockStatements = block.statements();
                        ASTNode toMove = source.createMoveTarget((ASTNode)blockStatements.get(0), (ASTNode)blockStatements.get(blockStatements.size() - 1));
                        statements.insertLast(toMove, substitute);
                    } else {
                        statements.insertLast(this.fRewriter.createMoveTarget((ASTNode)selectedNodes[0]), substitute);
                    }
                }
                if (selectedNodes[0].getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
                    if (replacementNode instanceof ExpressionStatement) {
                        this.fRewriter.replace((ASTNode)selectedNodes[0], (ASTNode)((ExpressionStatement)replacementNode).getExpression(), substitute);
                    } else if (replacementNode instanceof ReturnStatement) {
                        this.fRewriter.replace((ASTNode)selectedNodes[0], (ASTNode)((ReturnStatement)replacementNode).getExpression(), substitute);
                    }
                } else {
                    this.fRewriter.replace((ASTNode)selectedNodes[0], replacementNode, substitute);
                }
            } else if (((SimpleName)selectedNodes).length > 1) {
                int index;
                if (isReturnVoid) {
                    this.fRewriter.remove((ASTNode)selectedNodes[((SimpleName)selectedNodes).length - 1], substitute);
                }
                ListRewrite source = this.fRewriter.getListRewrite(selectedNodes[0].getParent(), (ChildListPropertyDescriptor)selectedNodes[0].getLocationInParent());
                int n5 = index = isReturnVoid ? ((SimpleName)selectedNodes).length - 2 : ((SimpleName)selectedNodes).length - 1;
                if (this.fHasYield) {
                    simpleName = selectedNodes;
                    n = ((SimpleName)simpleName).length;
                    int n6 = 0;
                    while (n6 < n) {
                        SimpleName selectedNode = simpleName[n6];
                        YieldStatementCheckerReplacer yieldChecker = new YieldStatementCheckerReplacer(this.fRewriter, this.fAnalyzer.getSelectedNodeRange());
                        selectedNode.accept((ASTVisitor)yieldChecker);
                        ++n6;
                    }
                }
                ASTNode toMove = source.createMoveTarget((ASTNode)selectedNodes[0], (ASTNode)selectedNodes[index], replacementNode, substitute);
                statements.insertLast(toMove, substitute);
            }
            IVariableBinding returnValue = this.fAnalyzer.getReturnValue();
            if (returnValue != null) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fAST.newSimpleName(this.getName(returnValue)));
                statements.insertLast((ASTNode)rs, null);
            }
        }
        return result;
    }

    private String getName(IVariableBinding binding) {
        for (ParameterInfo info : this.fParameterInfos) {
            if (!Bindings.equals((IBinding)binding, (IBinding)info.getOldBinding())) continue;
            return info.getNewName();
        }
        return binding.getName();
    }

    private VariableDeclaration getVariableDeclaration(ParameterInfo parameter) {
        return ASTNodes.findVariableDeclaration(parameter.getOldBinding(), (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
    }

    private VariableDeclarationStatement createDeclaration(IVariableBinding binding, Expression intilizer) {
        VariableDeclaration original = ASTNodes.findVariableDeclaration(binding, (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        VariableDeclarationFragment fragment = this.fAST.newVariableDeclarationFragment();
        fragment.setName((SimpleName)ASTNode.copySubtree((AST)this.fAST, (ASTNode)original.getName()));
        fragment.setInitializer(intilizer);
        VariableDeclarationStatement result = this.fAST.newVariableDeclarationStatement(fragment);
        result.modifiers().addAll(ASTNode.copySubtrees((AST)this.fAST, ASTNodes.getModifiers(original)));
        result.setType(ASTNodeFactory.newType(this.fAST, original, this.fImportRewriter, new ContextSensitiveImportRewriteContext((ASTNode)original, this.fImportRewriter)));
        return result;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String replace;
        String name;
        String selection = arguments.getAttribute("selection");
        if (selection == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.parseInt(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.parseInt(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.extract.method");
        }
        this.fCUnit = (ICompilationUnit)element;
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && visibility.length() != 0) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((name = arguments.getAttribute(KEY_NAME)) == null || name.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
        }
        this.fMethodName = name;
        String destination = arguments.getAttribute(ATTRIBUTE_DESTINATION);
        if (destination != null && destination.length() == 0) {
            int index = 0;
            try {
                index = Integer.parseInt(destination);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DESTINATION));
            }
            this.fDestinationIndex = index;
        }
        if ((replace = arguments.getAttribute(ATTRIBUTE_REPLACE)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceDuplicates = Boolean.parseBoolean(replace);
        String makeFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (makeFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fMakeFinal = Boolean.parseBoolean(makeFinal);
        String makeSynchronized = arguments.getAttribute(ATTRIBUTE_SYNCHRONIZED);
        if (makeSynchronized == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SYNCHRONIZED));
        }
        this.fMakeSynchronized = Boolean.parseBoolean(makeSynchronized);
        String comments = arguments.getAttribute(ATTRIBUTE_COMMENTS);
        if (comments == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
        }
        this.fGenerateJavadoc = Boolean.parseBoolean(comments);
        String exceptions = arguments.getAttribute(ATTRIBUTE_EXCEPTIONS);
        if (exceptions == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXCEPTIONS));
        }
        this.fThrowRuntimeExceptions = Boolean.parseBoolean(exceptions);
        return new RefactoringStatus();
    }

    private class CheckMethodConflictVisitor
    extends ASTVisitor {
        private final String fMethodNameToCheck;

        public CheckMethodConflictVisitor(String methodName) {
            this.fMethodNameToCheck = methodName;
        }

        public boolean visit(MethodInvocation node) {
            if (node.getName().getFullyQualifiedName().equals(this.fMethodNameToCheck) && node.getExpression() == null) {
                throw new AbortSearchException();
            }
            return true;
        }
    }

    private class TypeExtendsSearchRequestor
    extends SearchRequestor {
        public List<SearchMatch> results = new ArrayList<SearchMatch>();

        private TypeExtendsSearchRequestor() {
        }

        public List<SearchMatch> getResults() {
            return this.results;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() == 0) {
                this.results.add(match);
            }
        }
    }

    private static class UsedNamesCollector
    extends ASTVisitor {
        private Set<String> result = new HashSet<String>();
        private Set<SimpleName> fIgnore = new HashSet<SimpleName>();

        private UsedNamesCollector() {
        }

        public static Set<String> perform(ASTNode[] nodes) {
            UsedNamesCollector collector = new UsedNamesCollector();
            ASTNode[] aSTNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode node = aSTNodeArray[n2];
                node.accept((ASTVisitor)collector);
                ++n2;
            }
            return collector.result;
        }

        public boolean visit(FieldAccess node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(FieldAccess node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(MethodInvocation node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(MethodInvocation node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(QualifiedName node) {
            this.fIgnore.add(node.getName());
            return true;
        }

        public void endVisit(QualifiedName node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(SimpleName node) {
            if (!this.fIgnore.contains(node)) {
                this.result.add(node.getIdentifier());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        private boolean visitType(AbstractTypeDeclaration node) {
            this.result.add(node.getName().getIdentifier());
            return false;
        }
    }

    private class YieldStatementCheckerReplacer
    extends ASTVisitor {
        private boolean hasYield;
        private boolean hasReturn;
        private final IRegion fSelectedRange;
        private final ASTRewrite fReplaceRewriter;

        public YieldStatementCheckerReplacer(IRegion selectedRange) {
            this.fSelectedRange = selectedRange;
            this.fReplaceRewriter = null;
        }

        public YieldStatementCheckerReplacer(ASTRewrite rewriter, IRegion selectedRange) {
            this.fSelectedRange = selectedRange;
            this.fReplaceRewriter = rewriter;
        }

        public boolean hasYield() {
            return this.hasYield;
        }

        public boolean hasReturn() {
            return this.hasReturn;
        }

        public boolean visit(YieldStatement node) {
            ASTNode parent;
            if (node.getStartPosition() < this.fSelectedRange.getOffset() + this.fSelectedRange.getLength() && (parent = node.getParent()) != null) {
                while (parent != null && !(parent instanceof SwitchExpression)) {
                    parent = parent.getParent();
                }
                if (parent.getStartPosition() < this.fSelectedRange.getOffset()) {
                    this.hasYield = true;
                    if (this.fReplaceRewriter != null) {
                        ReturnStatement rs = this.fReplaceRewriter.getAST().newReturnStatement();
                        rs.setExpression((Expression)this.fReplaceRewriter.createCopyTarget((ASTNode)node.getExpression()));
                        this.fReplaceRewriter.replace((ASTNode)node, (ASTNode)rs, null);
                    }
                }
            }
            return true;
        }

        public boolean visit(ReturnStatement node) {
            if (node.getStartPosition() < this.fSelectedRange.getOffset() + this.fSelectedRange.getLength()) {
                this.hasReturn = true;
            }
            return true;
        }
    }
}

