/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.launch;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizigo.project.ProjectManager;
import com.iizigo.server.NewServerConfigWizard;
import com.iizigo.server.ServerConfigComposite;
import com.iizigo.server.ServerConfigFile;
import com.iizigo.server.config.EditorServerConfigEnvProps;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.server.launch.a;
import com.iizigo.swt.WizardDialog;
import com.iizigo.validator.ControlValidator;
import com.iizigo.validator.IValidationMessage;
import com.iizigo.validator.ValidatorManager;
import com.iizix.ILog;
import com.iizix.prop.PropException;
import com.iizix.server.JettyRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DevelServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IValidationMessage {
    private static File a;
    private static File b;
    private ValidatorManager a;
    private String a;
    private String b;
    private Combo a;
    private Combo b;
    private Button a;
    private Combo c;
    private String c;
    private Label a;
    private ServerConfigComposite a;
    private Composite a;
    private Composite b;
    private ArrayList<String> a;

    public static File getDefaultServerDirectory() throws IOException {
        File file;
        if (a == null && (file = Activator.getStateLocationFile(".iiziServer")) != null) {
            a = file;
        }
        if (!a.exists() && !a.mkdir()) {
            throw new IOException("Failed creating default iiziServer home directory " + a.getPath());
        }
        if (!a.isDirectory()) {
            throw new IOException("The default iiziServer home directory " + a.getPath() + " is not a directory");
        }
        return a;
    }

    private static String a() throws IOException {
        if (b == null) {
            b = new File(DevelServerLaunchConfigurationTab.getDefaultServerDirectory(), "config.iiziServer");
        }
        if (!b.exists()) {
            NewServerConfigWizard.createDefault(b);
        }
        return b.getPath();
    }

    DevelServerLaunchConfigurationTab() {
    }

    public void dispose() {
        this.e();
    }

    private IJavaElement a() {
        IWorkbenchPage iWorkbenchPage = JDIDebugUIPlugin.getActivePage();
        if (iWorkbenchPage != null) {
            Object object;
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = iWorkbenchPage.getSelection();
            if (iSelection instanceof IStructuredSelection && !(iStructuredSelection = (IStructuredSelection)iSelection).isEmpty()) {
                object = iStructuredSelection.getFirstElement();
                if (object instanceof IJavaElement) {
                    return (IJavaElement)object;
                }
                if (object instanceof IResource) {
                    IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)object));
                    if (iJavaElement == null) {
                        IProject iProject = ((IResource)object).getProject();
                        iJavaElement = JavaCore.create((IProject)iProject);
                    }
                    if (iJavaElement != null) {
                        return iJavaElement;
                    }
                }
            }
            if ((iStructuredSelection = iWorkbenchPage.getActiveEditor()) != null) {
                object = iStructuredSelection.getEditorInput();
                return (IJavaElement)object.getAdapter(IJavaElement.class);
            }
        }
        return null;
    }

    private String b() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JDIDebugUIPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof PropEditorPart) {
            return ((PropEditorPart)iEditorPart).getModuleModel().getProject().getName();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        Object object;
        String string = "";
        String string2 = "";
        IJavaElement iJavaElement = this.a();
        if (iJavaElement != null) {
            object = iJavaElement.getJavaProject().getProject();
            string = object.getName();
            if (ProjectManager.getInstance().isRegistered((IProject)object)) {
                string2 = string;
            }
        }
        if ((string2.isEmpty() || string.isEmpty()) && (object = this.b()) != null) {
            string2 = object;
            if (string.isEmpty()) {
                string = object;
            }
        }
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, string);
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.moduleProject", string2);
        object = "";
        try {
            object = DevelServerLaunchConfigurationTab.a();
        }
        catch (IOException iOException) {
            ILog.SEVERE(this.getClass(), (String)"Failed creating default iiziServer configuration file", (Throwable)iOException);
        }
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.develserver.serverConfigFile", (String)object);
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.develserver.serverEnv", "default");
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, JettyRunConfiguration.class.getCanonicalName());
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, true);
        try {
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray;
            boolean bl = false;
            IPath iPath = IzClasspathContainer.Type.SERVER.getPath();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            int n2 = iRuntimeClasspathEntryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray2[n3];
                if (iRuntimeClasspathEntry.getType() == 4 && iPath.equals((Object)iRuntimeClasspathEntry.getPath())) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                int n4 = iRuntimeClasspathEntryArray.length;
                iRuntimeClasspathEntryArray = Arrays.copyOf(iRuntimeClasspathEntryArray, n4 + 1);
                iRuntimeClasspathEntryArray[n4] = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)iPath, (int)1);
                ArrayList<String> arrayList = new ArrayList<String>(iRuntimeClasspathEntryArray.length);
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray3 = iRuntimeClasspathEntryArray;
                int n5 = iRuntimeClasspathEntryArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray3[n6];
                    arrayList.add(iRuntimeClasspathEntry.getMemento());
                    ++n6;
                }
                iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, arrayList);
            }
        }
        catch (CoreException coreException) {
            ILog.SEVERE(this.getClass(), (String)"Failed updating launch configuration classpath", (Throwable)coreException);
        }
    }

    public void createControl(Composite composite) {
        String string2;
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        int n2 = applicationUI.s10();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = gridLayout.verticalSpacing = n2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        this.a = new ValidatorManager(this, "Select Server Configuration file name and specify the server configuration");
        Label label = new Label(composite2, 0);
        label.setText("Select Module project to load in the development server.");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        label = new Label(composite2, 0);
        label.setText("&Module project:");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ProjectManager projectManager = ProjectManager.getInstance();
        this.a = new Combo(composite2, 2052);
        this.a.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ControlValidator controlValidator2 = this.a.newValidator(this.a, "Module project", true);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            String string2 = projectManager.getModuleModel(string) != null ? null : "IIZI Module project not found";
            controlValidator.setErrorMessage(string2);
            return string2 == null;
        });
        String[] stringArray = projectManager.getLoadedModuleProjects();
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            string2 = stringArray[n4];
            this.a.add(string2);
            ++n4;
        }
        this.a.addListener(24, event -> this.b());
        string2 = new GridData(4, 128, true, false, 3, 1);
        ((GridData)string2).verticalIndent = n2;
        new Label(composite2, 258).setLayoutData((Object)string2);
        string2 = new GridData(16384, 128, false, false, 3, 1);
        ((GridData)string2).verticalIndent = n2;
        Link link = new Link(composite2, 0);
        link.setText("Select the IIZI Server Configuration to use. Click the links to <a href=\"new\">create</a> a new file or <a href=\"browse\">browse</a> for an existing file.");
        link.setLayoutData((Object)string2);
        link.addListener(13, event -> this.a(event));
        label = new Label(composite2, 0);
        label.setText("&File name:");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.b = new Combo(composite2, 2052);
        this.b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.b.setToolTipText("The Server Configuration file name with file extension \".iiziServer\"");
        controlValidator2 = this.a.newValidator(this.b, "File name", true);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            Object object = null;
            if (!string.endsWith(".iiziServer")) {
                object = "File name must end with \".iiziServer\"";
            } else {
                File file = new File(string);
                if (!file.isFile()) {
                    object = "The Server Configuration file \"" + string + "\" is not found";
                }
            }
            controlValidator.setErrorMessage((String)object);
            return object == null;
        });
        this.a((String)null);
        this.b.addListener(24, event -> this.b());
        string2 = new GridData(4, 0x1000000, false, false);
        ((GridData)string2).widthHint = applicationUI.cx(90);
        this.a = new Button(composite2, 8);
        this.a.setLayoutData((Object)string2);
        this.a.setText("&Open");
        this.a.addListener(13, event -> {
            boolean bl = this.a(this.b.getText(), true);
        });
        this.a = new Label(composite2, 0);
        this.a.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.a.setText("&Environment:");
        this.a.setVisible(false);
        this.c = new Combo(composite2, 2052);
        this.c.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.c.setToolTipText("Defines the environment to use in the Server");
        this.c.setVisible(false);
        controlValidator2 = this.a.newValidator(this.c, "Server environment", false);
        controlValidator2.setValidatorCallback((controlValidator, string) -> {
            String string2 = null;
            if (this.a.isVisible()) {
                this.c = string;
                if (string.isEmpty()) {
                    controlValidator.setRequiredMessage(string2);
                    return false;
                }
                ServerConfigFile serverConfigFile = this.a.getServerConfigFile();
                if (serverConfigFile == null || serverConfigFile.getSettings().getServerConfigEnvironment(string) == null) {
                    string2 = "The Server Environment does not exist";
                }
            }
            controlValidator.setErrorMessage(string2);
            return string2 == null;
        });
        label = new Label(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 10;
        string2 = new GridData(4, 4, true, true, 3, 1);
        ((GridData)string2).exclude = true;
        this.a = new Composite(composite2, 0);
        this.a.setLayoutData((Object)string2);
        this.a.setLayout((Layout)gridLayout);
        this.a.setVisible(false);
        this.a = new a(this, null, this.a, null, () -> this.a());
        this.a.setLayoutData(new GridData(4, 4, true, true));
        this.a.createControls();
        this.b = new Composite(this.a, 0);
        this.b.setLayoutData((Object)new GridData(4, 4, true, false));
        this.a.addErrorComposite(this.b);
        composite2.pack();
        this.setControl((Control)composite2);
    }

    private void a() {
        this.c();
    }

    private void a(Event event) {
        switch (event.text) {
            case "new": {
                NewServerConfigWizard newServerConfigWizard = new NewServerConfigWizard();
                newServerConfigWizard.setServerConfigComposite(this.a);
                WizardDialog wizardDialog = new WizardDialog(this.getShell(), newServerConfigWizard);
                wizardDialog.setTitle(newServerConfigWizard.getWindowTitle());
                wizardDialog.setTitleImage(ApplicationUI.getInstance().getImage("new_server_config.png"));
                if (wizardDialog.open() != 0) break;
                String string = newServerConfigWizard.getFileName();
                this.b.setText(string);
                if (!this.a(string, true)) break;
                this.a(string);
                break;
            }
            case "browse": {
                FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
                fileDialog.setFileName(this.b.getText());
                fileDialog.setFilterExtensions(new String[]{"*.iiziServer"});
                String string = fileDialog.open();
                if (string == null) break;
                this.b.setText(string);
                if (!this.a.validate() || !this.a(string, true)) break;
                this.a(string);
            }
        }
    }

    private void a(String string) {
        this.b.removeAll();
        List<File> list = ServerConfigFile.getHistory();
        for (File file : list) {
            this.b.add(file.getPath());
        }
        if (string != null) {
            this.b.setText(string);
        }
    }

    private void b() {
        this.f();
        boolean bl = false;
        boolean bl2 = false;
        String string = this.b.getText();
        File file = new File(string);
        if (file.isFile()) {
            try {
                file = file.getCanonicalFile();
                string = file.getPath();
                if (string.endsWith(".iiziServer")) {
                    bl2 = true;
                    ServerConfigFile serverConfigFile = this.a.getServerConfigFile();
                    bl = serverConfigFile != null && serverConfigFile.getPath().equals(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.a(bl);
        this.a.setEnabled(bl2 && !bl);
        this.b = string;
        this.a = this.a.getText();
        this.c();
        this.a.validate();
        this.updateLaunchConfigurationDialog();
    }

    private void c() {
        if (this.a != null && this.a != null && !this.a.isDisposed() && !this.a.isDisposed() && this.a.isVisible() && this.a.isDirty()) {
            this.f();
        }
    }

    private boolean a(String string, boolean bl) {
        try {
            ServerConfigFile serverConfigFile = ServerConfigFile.open(string);
            this.e();
            this.a.setServerConfigFile(serverConfigFile, null);
            this.b();
            this.d();
            this.c = serverConfigFile.getSettings().getDefaultServerConfigurationEnvironmentName();
            this.c.setText(this.c);
            this.a.validate();
            this.f();
            return true;
        }
        catch (PropException | IOException throwable) {
            if (bl) {
                Activator.openError(this.getShell(), "Server Configuration", "Failed to open the Server Configuration file '" + string + "'.", throwable);
            }
            return false;
        }
    }

    private void d() {
        Object object;
        if (!this.a.isVisible()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        EditorServerSettings editorServerSettings = this.a.getSettings();
        if (editorServerSettings != null) {
            EditorServerConfigEnvProps[] editorServerConfigEnvPropsArray = editorServerSettings.getServerConfigEnvironments();
            int n2 = editorServerConfigEnvPropsArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = editorServerConfigEnvPropsArray[n3];
                arrayList.add(object.getPropName());
                ++n3;
            }
        }
        if (arrayList.equals(this.a)) {
            return;
        }
        this.a = arrayList;
        object = this.c.getText();
        this.c.removeAll();
        for (String string : arrayList) {
            this.c.add(string);
        }
        this.c.setText((String)object);
    }

    private void a(boolean bl) {
        if (this.a.isVisible() != bl) {
            Composite composite = this.a.getParent();
            ((GridData)this.a.getLayoutData()).exclude = !bl;
            this.a.setVisible(bl);
            this.a.setVisible(bl);
            this.c.setVisible(bl);
            composite.layout(true, true);
            composite.update();
            this.a.validate();
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            Object object;
            boolean bl = false;
            this.a = iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", "");
            if (this.a.isEmpty() && (object = this.a()) != null) {
                IProject iProject = object.getJavaProject().getProject();
                String string = iProject.getName();
                if (ProjectManager.getInstance().isRegistered(iProject)) {
                    this.a = string;
                    bl = true;
                }
            }
            if (this.a.isEmpty() && (object = this.b()) != null) {
                this.a = object;
                bl = true;
            }
            this.a.setText(this.a);
            this.b = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverConfigFile", "");
            if (this.b.isEmpty()) {
                try {
                    this.b = DevelServerLaunchConfigurationTab.a();
                    bl = true;
                }
                catch (IOException iOException) {
                    ILog.SEVERE(this.getClass(), (String)"Failed creating default iiziServer configuration file", (Throwable)iOException);
                }
            }
            this.b.setText(this.b);
            this.c = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverEnv", "default");
            this.c.setText(this.c);
            this.a(this.b, false);
            this.setDirty(bl);
            this.a.validate();
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreException) {
            ILog.SEVERE(this.getClass(), (String)("Failed retrieving values from configuration '" + iLaunchConfiguration.getName() + "'"), (Throwable)coreException);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.a);
        iLaunchConfigurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, JettyRunConfiguration.class.getCanonicalName());
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.moduleProject", this.a);
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.develserver.serverConfigFile", this.b);
        iLaunchConfigurationWorkingCopy.setAttribute("com.iizigo.develserver.serverEnv", this.c);
    }

    private void e() {
        if (this.a != null && !this.a.isDisposed() && this.a.isDirty()) {
            this.a.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        return DevelServerLaunchConfigurationTab.isConfigurationValid(iLaunchConfiguration);
    }

    public String getName() {
        return "iiziServer";
    }

    public Image getImage() {
        return ApplicationUI.getInstance().imageIizi;
    }

    @Override
    public void setMessage(String string, int n2) {
        switch (n2) {
            case 3: {
                this.setWarningMessage(null);
                this.setErrorMessage(string);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setWarningMessage(string);
                break;
            }
            default: {
                this.setErrorMessage(null);
                this.setWarningMessage(null);
                this.setMessage(string);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void onValidate(boolean bl) {
        this.c();
    }

    private void f() {
        if (!super.isDirty()) {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected boolean isDirty() {
        return super.isDirty() || this.a != null && this.a.isDirty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConfigurationValid(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string;
            IRuntimeClasspathEntry iRuntimeClasspathEntry;
            ServerConfigFile serverConfigFile;
            if (!iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_SOURCE_PATH, true)) {
                return false;
            }
            String string2 = iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", "");
            if (!ProjectManager.getInstance().isRegistered(string2)) {
                return false;
            }
            List list = iLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList());
            String string3 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverConfigFile", "");
            if (!string3.endsWith(".iiziServer")) {
                return false;
            }
            File file = new File(string3);
            if (!file.isFile()) {
                return false;
            }
            String string4 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverEnv", "");
            if (string4.isEmpty()) {
                return false;
            }
            try {
                serverConfigFile = ServerConfigFile.open(string3);
                boolean bl = serverConfigFile.getSettings().getServerConfigEnvironment(string4) != null;
                serverConfigFile.release();
                if (!bl) {
                    return false;
                }
            }
            catch (PropException | IOException throwable) {
                return false;
            }
            serverConfigFile = IzClasspathContainer.Type.SERVER.getPath();
            Iterator iterator = list.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((iRuntimeClasspathEntry = JavaRuntime.newRuntimeClasspathEntry((String)(string = (String)iterator.next()))).getType() != 4 || !serverConfigFile.equals(iRuntimeClasspathEntry.getPath()));
            return true;
        }
        catch (CoreException coreException) {
            ILog.WARNING(DevelServerLaunchConfigurationTab.class, (String)("Launch configuration '" + iLaunchConfiguration.getName() + "' error"), (Throwable)coreException);
        }
        return false;
    }
}

