/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.launch;

import com.iizigo.Activator;
import com.iizigo.Console;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizigo.plugin.PluginManager;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.server.ServerConfigFile;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.server.launch.DevelServerLaunchConfigurationTab;
import com.iizix.Utilities;
import com.iizix.js.JSFiles;
import com.iizix.prop.PropException;
import com.iizix.server.IServer;
import com.iizix.server.JettyRunConfiguration;
import com.iizix.server.prop.WebServerPortConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.util.NLS;

public class DevelServerLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static int a = -1;

    public static int getLastLaunchedServerConfigUnsecuredPort() {
        return a;
    }

    public boolean preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2 = iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", "");
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(string2);
        if (moduleModel == null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Project \"" + string2 + "\" is not an open IIZI Module project"));
        }
        return super.preLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        return super.buildForLaunch(iLaunchConfiguration, string, iProgressMonitor);
    }

    public boolean finalLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        EditorServerSettings editorServerSettings;
        String string2;
        String string3 = iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", "");
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(string3);
        if (moduleModel == null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Project \"" + string3 + "\" is not an open IIZI Module project"));
        }
        String[] stringArray = moduleModel.getModuleNameReferences();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            string2 = stringArray[n3];
            if (ProjectManager.getInstance().getModuleModel(string2) == null) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Dependent project \"" + string2 + "\" is not an open IIZI Module project"));
            }
            ++n3;
        }
        string2 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverConfigFile", "");
        File file = new File(string2).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
            editorServerSettings = ServerConfigFile.loadFile(file);
            WebServerPortConfig[] webServerPortConfigArray = editorServerSettings.getPortConfigurations();
            int n4 = webServerPortConfigArray.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                WebServerPortConfig webServerPortConfig = webServerPortConfigArray[n5];
                if (webServerPortConfig.getProtocol() <= 0 && (n6 = webServerPortConfig.getPort()) > 0 && n6 < 65535) {
                    a = n6;
                    break;
                }
                ++n5;
            }
        }
        catch (PropException | IOException throwable) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Failed loading server configuration file \"" + file.getPath() + "\"", throwable));
        }
        String string4 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverEnv", "");
        if (editorServerSettings.getServerConfigEnvironment(string4) == null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Server configuration file \"" + file.getPath() + "\" does not contain the environment \"" + string4 + "\""));
        }
        return super.finalLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        } else if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.beginTask(NLS.bind((String)"{0}...", (Object[])new String[]{iLaunchConfiguration.getName()}), 3);
        try {
            File file;
            Object object;
            File file2;
            iProgressMonitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Verifying_launch_attributes____1);
            String string2 = iLaunchConfiguration.getAttribute("com.iizigo.moduleProject", "");
            ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(string2);
            if (moduleModel == null) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Module project \"" + string2 + "\" is not found"));
            }
            try {
                file2 = DevelServerLaunchConfigurationTab.getDefaultServerDirectory();
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Failed getting server home directory", iOException));
            }
            String string3 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverConfigFile", "");
            ServerConfigFile serverConfigFile = ServerConfigFile.open(string3);
            EditorServerSettings editorServerSettings = serverConfigFile.getSettings();
            serverConfigFile.release();
            String string4 = iLaunchConfiguration.getAttribute("com.iizigo.develserver.serverEnv", "");
            String string5 = editorServerSettings.getString("$dbDirectory");
            if (string5 != null && !string5.isEmpty()) {
                try {
                    object = Activator.getUserPrivateDirectory();
                    file = Utilities.getCanonicalFile((File)((File)object).toPath().resolve(string5).toFile());
                    file = new File(file2, string5);
                }
                catch (Exception exception) {
                    throw new CoreException((IStatus)Activator.createErrorStatus("Failed getting database directory \"" + string5 + "\": " + exception.getMessage(), exception));
                }
            }
            try {
                file = Activator.getInstance().getDatabaseDirectory();
            }
            catch (Exception exception) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Failed getting database directory: " + exception.getMessage(), exception));
            }
            file = Utilities.getCanonicalFile((File)file);
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new CoreException((IStatus)Activator.createErrorStatus("Failed creating iiziServer database directory: " + file.getPath()));
            }
            if (!file.isDirectory()) {
                throw new CoreException((IStatus)Activator.createErrorStatus("iiziServer database directory \"" + file.getPath() + "\" is not found"));
            }
            object = "";
            boolean bl = true;
            char[] cArray = string2.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            while (n3 < n2) {
                char c2 = cArray[n3];
                if (c2 == ' ') {
                    c2 = '.';
                }
                if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || bl || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '_') {
                    // empty if block
                }
                object = ((String)object + c2).replace("..", ".");
                bl = false;
                if (((String)object).length() == 64) break;
                ++n3;
            }
            if (((String)object).endsWith(".")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (IServer.validateAppID((String)object) != null) {
                object = "iizi." + string;
            }
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("-jdbcdrivers", "private", "-config", Utilities.quoteStringWithSpaces((String)string3), "-dbautocreate", Boolean.toString(editorServerSettings.getBool("$dbAutoCreate", true)), "-dbautostart", Boolean.toString(editorServerSettings.getBool("$dbAutoStart", true)), "-dbdir", Utilities.quoteStringWithSpaces((String)file.getPath()), "-root", Utilities.quoteStringWithSpaces((String)JSFiles.getRoot(null).getPath()), "-defaultenv", Utilities.quoteStringWithSpaces((String)string4), "-app", object, "-env", Utilities.quoteStringWithSpaces((String)string4)));
            n3 = editorServerSettings.getInt("$dbPort", -1);
            if (n3 >= 0) {
                if (n3 == 0) {
                    n3 = 1527;
                }
                arrayList.add("-dbport");
                arrayList.add(Integer.toString(n3));
                String string6 = editorServerSettings.getString("$dbHost");
                if (string6 != null && string6.isEmpty()) {
                    arrayList.add("-dbhost");
                    arrayList.add(string6);
                }
            }
            Activator.getInstance().addServerLaunchOptions(arrayList);
            Object[] objectArray = moduleModel.getModuleProjectReferences();
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                ModuleModel moduleModel2 = objectArray[n5];
                arrayList.add("-project");
                arrayList.add(Utilities.quoteStringWithSpaces((String)moduleModel2.getProject().getLocation().toFile().getAbsolutePath()));
                ++n5;
            }
            String string7 = JettyRunConfiguration.class.getCanonicalName();
            IVMRunner iVMRunner = this.getVMRunner(iLaunchConfiguration, string);
            String string8 = file2.getPath();
            objectArray = this.getEnvironment(iLaunchConfiguration);
            String string9 = this.getVMArguments(iLaunchConfiguration);
            ExecutionArguments executionArguments = new ExecutionArguments(string9, "");
            Map map = this.getVMSpecificAttributesMap(iLaunchConfiguration);
            String[] stringArray = this.a(iLaunchConfiguration);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(List.of(executionArguments.getVMArgumentsArray()));
            linkedHashSet.add("-XX:+IgnoreUnrecognizedVMOptions");
            linkedHashSet.add("--enable-preview");
            VMRunnerConfiguration vMRunnerConfiguration = new VMRunnerConfiguration(string7, stringArray);
            vMRunnerConfiguration.setEnvironment((String[])objectArray);
            vMRunnerConfiguration.setVMArguments(linkedHashSet.toArray(new String[linkedHashSet.size()]));
            vMRunnerConfiguration.setProgramArguments(arrayList.toArray(new String[arrayList.size()]));
            vMRunnerConfiguration.setWorkingDirectory(string8);
            vMRunnerConfiguration.setVMSpecificAttributesMap(map);
            vMRunnerConfiguration.setBootClassPath(this.getBootpath(iLaunchConfiguration));
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            try {
                iProgressMonitor.worked(1);
                iProgressMonitor.subTask(LaunchingMessages.JavaLocalApplicationLaunchConfigurationDelegate_Creating_source_locator____2);
                this.setDefaultSourceLocator(iLaunch, iLaunchConfiguration);
                iProgressMonitor.worked(1);
                if (!iProgressMonitor.isCanceled()) {
                    iVMRunner.run(vMRunnerConfiguration, iLaunch, iProgressMonitor);
                }
            }
            catch (CoreException coreException) {
                throw coreException;
            }
            catch (Throwable throwable) {
                throw new CoreException((IStatus)Activator.createErrorStatus("iiziServer loading execution information", throwable));
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private String[] a(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(PluginManager.getServerCoreAndPluginClasspath());
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)iLaunchConfiguration);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = iRuntimeClasspathEntryArray = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])iRuntimeClasspathEntryArray, (ILaunchConfiguration)iLaunchConfiguration);
        int n2 = iRuntimeClasspathEntryArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray2[n3];
            switch (iRuntimeClasspathEntry.getClasspathProperty()) {
                case 3: 
                case 5: {
                    String string = iRuntimeClasspathEntry.getPath().toFile().getAbsolutePath();
                    if (string == null) break;
                    linkedHashSet.add(string);
                    break;
                }
                case 4: {
                    IzClasspathContainer.Type type = IzClasspathContainer.Type.fromPath(iRuntimeClasspathEntry.getPath());
                    if (type == null) break;
                    Console.println(3, "IGNORED: classpath for container " + String.valueOf((Object)type) + ", entry " + String.valueOf(iRuntimeClasspathEntry.getPath()));
                }
            }
            ++n3;
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }
}

