/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.quickfix.fixer;

import com.iizigo.Activator;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.quickfix.QuickFixAdapter;
import com.iizigo.quickfix.fixer.a;
import com.iizix.ILog;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class CreateModuleFolders
extends QuickFixAdapter {
    public static final String ID = "CreateModuleFoldersQuickFixer";

    @Override
    public void run(IMarker iMarker) {
        IProject iProject = iMarker.getResource().getProject();
        ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(iProject);
        if (moduleModel == null) {
            Activator.messageBox("Create Module project folders", "The project is not of IIZI Module Nature, cannot proceed.", 33);
        } else {
            IFolder[] iFolderArray = moduleModel.getQuickFixCreateFolders();
            if (iFolderArray == null) {
                Activator.messageBox("Create Module project folders", "IIZI Module project does not have missing resources.", 34);
            } else {
                CreateModuleFolders.a(Activator.getSomeShell(), "Create Module Folders", iFolderArray);
            }
        }
    }

    @Override
    public String getLabel() {
        return "Create Module project folders";
    }

    private static void a(Shell shell, String string, IFolder[] iFolderArray) {
        a a2 = new a(string, iFolderArray);
        try {
            ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                try {
                    IStatus iStatus = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)a2, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell));
                    if (!iStatus.isOK()) {
                        ILog.SEVERE(CreateModuleFolders.class, (String)"createFolders failed", (Object)iStatus);
                        throw new CoreException(iStatus);
                    }
                }
                catch (ExecutionException executionException) {
                    ILog.SEVERE(CreateModuleFolders.class, (String)"createFolders", (Throwable)executionException);
                    if (executionException.getCause() instanceof CoreException) {
                        throw (CoreException)executionException.getCause();
                    }
                    throw new CoreException((IStatus)new Status(4, "com.iizigo", executionException.getMessage(), (Throwable)executionException));
                }
            }, null, 1, null);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)coreException.getMessage(), (IStatus)coreException.getStatus());
        }
    }
}

