/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.acme;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.prop.PropException;
import com.iizix.server.IServer;
import com.iizix.server.IServerDisposeListener;
import com.iizix.server.ServerShell;
import com.iizix.server.acme.LetsEncrypt;
import com.iizix.server.acme.LetsEncryptDomain;
import com.iizix.server.acme.b;
import com.iizix.server.acme.c;
import com.iizix.virtual.VirtualThreads;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LetsEncryptRenewal {
    public static long RENEW_PERIOD = 1800000L;
    private final LetsEncryptDomain a;
    private final ServerShell a;
    private Timer a;
    private String a;
    private String b;
    private String c;
    private int a;
    private Date a;
    private boolean a;
    private final AtomicBoolean a;
    private final IServerDisposeListener a = new b(this);

    LetsEncryptRenewal(ServerShell serverShell, LetsEncryptDomain letsEncryptDomain) {
        this.a = serverShell;
        this.a = letsEncryptDomain;
        serverShell.addDisposeListener(this.a);
        letsEncryptDomain.addPropListener(gEvent -> {
            if (letsEncryptDomain.isDisposed()) {
                this.a();
            }
        });
        this.processSettingsChanges();
    }

    private synchronized void a() {
        this.a = true;
        this.b();
    }

    public synchronized boolean processSettingsChanges() {
        int n;
        String string;
        String string2;
        String string3;
        if (this.a) {
            return false;
        }
        boolean bl = false;
        String string4 = this.a.getDomain();
        if (!string4.equals(this.a)) {
            this.a = string4;
            bl = true;
        }
        if (!(string3 = "domain " + string4 + (String)((string2 = this.a.getDescription()) != null ? ", " + string2 : "")).equals(this.b)) {
            this.b = string3;
            bl = true;
        }
        if ((string = this.a.getTermsOfServiceURI()) != null && !string.equals(this.c)) {
            this.c = string;
            bl = true;
        }
        if ((n = this.a.getExpirationDayCount()) != this.a) {
            this.a = n;
            this.b();
            bl = true;
        }
        Date date = this.a.getExpirationDate();
        if (bl || date == null || this.a == null || !date.equals(this.a)) {
            this.a = date;
            this.b();
            bl = true;
            if (date != null) {
                date = new Date(date.getTime() - 86400000L * (long)n);
                ILog.INFO(this.getClass(), (String)("Let's Encrypt certificate for domain \"" + string4 + "\" is scheduled for renewal on " + Utilities.formatDate((Date)date).replace("  ", " at ") + " as it expires on " + Utilities.formatDate((Date)this.a).replace("  ", " at ")));
            } else {
                date = new Date();
            }
            this.a(date, RENEW_PERIOD);
        }
        return bl;
    }

    private synchronized void a(Date date, long l) {
        this.b();
        this.a = new Timer(true);
        c c2 = new c(this);
        this.a.scheduleAtFixedRate((TimerTask)c2, date, l);
    }

    private synchronized void b() {
        if (this.a != null) {
            this.a.cancel();
            this.a.purge();
            this.a = null;
        }
    }

    private void c() {
        if (!this.a.getAndSet(true)) {
            VirtualThreads.getVirtualThreads().startThread(() -> {
                try {
                    try {
                        this.performRenew();
                    }
                    catch (Throwable throwable) {
                        ILog.SEVERE(this.getClass(), (String)("Failed renewing Let's Encrypt certificate for domain \"" + this.a + "\""), (Throwable)throwable);
                        this.a.getAndSet(false);
                    }
                }
                finally {
                    this.a.getAndSet(false);
                }
            }, "LetsEncryptRenewal-" + this.a, 3);
        }
    }

    public boolean performRenew() throws Exception, IOException, URISyntaxException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, PropException {
        return this.a(false);
    }

    private boolean a(boolean bl) throws Exception, IOException, URISyntaxException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, PropException {
        Object object;
        X509Certificate[] x509CertificateArray;
        Serializable serializable;
        if (!this.a.getState().equals((Object)IServer.State.STARTED)) {
            throw new IOException("Server is not yet started");
        }
        URL uRL = null;
        Proxy proxy = null;
        String string = "http://" + this.a + "/";
        try {
            uRL = new URI(string).toURL();
            proxy = this.a.getProxy(uRL);
            serializable = null;
            x509CertificateArray = null;
            try {
                object = uRL.openConnection(proxy).getInputStream();
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (Throwable throwable) {
                if (serializable == null) {
                    serializable = throwable;
                } else if (serializable != throwable) {
                    ((Throwable)serializable).addSuppressed(throwable);
                }
                throw serializable;
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IOException("The URL " + string + " is not accessible", exception);
        }
        catch (Exception exception) {
            throw new IOException(proxy != null ? "The URL " + string + " is not accessible through proxy " + String.valueOf(proxy) : "The URL " + string + " is not accessible", exception);
        }
        serializable = new StringBuilder();
        if (this.c != null) {
            ((StringBuilder)serializable).append(this.c);
        }
        x509CertificateArray = new X509Certificate[1];
        object = this.a.getKeyStorePassword();
        File file = LetsEncrypt.createCertificateChallenge(this.a.getRootDirectory(), this.a, this.a.getChallengeType(), (StringBuilder)serializable, null, (String)object, x509CertificateArray);
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = ((StringBuilder)serializable).toString();
        if (!string2.equals(this.c)) {
            if (bl || this.a.isAutoAcceptTermsOfServiceEnabled()) {
                if (!bl) {
                    this.b(string2);
                    bl2 = true;
                }
                this.c = string2;
                bl3 = this.a.acceptTermsOfService(string2);
            } else {
                bl3 = this.a.setNeedToAcceptTermsOfServiceURI(string2);
                this.a(string2);
            }
        }
        if (file != null) {
            if (this.a.updateIdentity(file, (String)object)) {
                bl3 = true;
            }
            this.b();
            if (this.processSettingsChanges()) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.a.saveServerConfig();
        }
        return bl2 && this.a(true);
    }

    private void a(String string) {
        ILog.WARNING(this.getClass(), (String)("Let's Encrypt requires a new Terms of Service agreement to be accepted for domain \"" + this.a + "\". Open ServerAdmin and accept the agreement, URI = " + string));
    }

    private void b(String string) {
        ILog.INFO(this.getClass(), (String)("Let's Encrypt new Terms of Service agreement auto-accepted for domain \"" + this.a + "\", URI = " + string));
    }
}

