/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.prop.Atom;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ui.UIComp;

public interface ILayoutDataAlignX
extends IPropCnr {
    public static final String ALIGN_X_NAME = "alignX";
    public static final int ALIGN_X_LEFT = 1;
    public static final int ALIGN_X_CENTER = 2;
    public static final int ALIGN_X_RIGHT = 3;
    public static final int ALIGN_X_FILL = 4;

    default public IntProp getAlignPropX() {
        return this.getProp(ALIGN_X_NAME, IntProp.class);
    }

    default public int setAlignX(int n2) {
        return this.setAlignX(n2, null);
    }

    default public int setAlignX(int n2, IComplexOperation iComplexOperation) {
        UIComp uIComp = (UIComp)this.getParent();
        if (uIComp == null) {
            return -1;
        }
        if (uIComp.hasImplicitAlignFillX()) {
            return 4;
        }
        if (n2 <= 0 || n2 > 4) {
            n2 = this.getDefaultAlignX();
        } else {
            IntProp intProp = this.getProp(ALIGN_X_NAME, IntProp.class);
            if (intProp != null) {
                if ((Integer)intProp.getPropValue() != n2) {
                    IComplexOperation.setPropValue(iComplexOperation, intProp, n2);
                }
            } else if (n2 != this.getDefaultAlignX()) {
                try {
                    intProp = new IntProp(Atom.get(ALIGN_X_NAME), n2);
                }
                catch (PropValidateException propValidateException) {
                    throw new InternalError("Shouldn't be", propValidateException);
                }
                IComplexOperation.addProp(iComplexOperation, (PropCnr)((Object)this), intProp);
            }
        }
        return n2;
    }

    default public int getDefaultAlignX() {
        return 1;
    }

    default public int getAlignX() {
        UIComp uIComp = (UIComp)this.getParent();
        if (uIComp != null && uIComp.hasImplicitAlignFillX()) {
            return 4;
        }
        int n2 = this.getDefaultAlignX();
        IntProp intProp = this.getAlignPropX();
        return intProp != null ? intProp.getInt(n2) : n2;
    }

    default public boolean hasFillX() {
        return this.getAlignX() == 4;
    }

    default public void verifyAlignX(UIComp uIComp, PropVerification propVerification) {
        IntProp intProp = this.getAlignPropX();
        if (intProp != null) {
            int n2 = intProp.getInt(this.getDefaultAlignX());
            if (n2 == 4) {
                if (!uIComp.canFillX()) {
                    propVerification.add(new PropVerificationError("cant.fill.x", PropVerificationError.Severity.WARNING, "Horizontal align", intProp, "Component cannot have horizontal fill", new String[0]));
                }
            } else if (uIComp.hasImplicitAlignFillX()) {
                propVerification.add(new PropVerificationError("implicit.fill.x", PropVerificationError.Severity.WARNING, "Horizontal align", intProp, "Component has implicit horizontal fill", new String[0]));
            }
        }
    }
}

