/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user.mfa;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.iizix.barcode.BarcodeException;
import com.iizix.barcode.BarcodeType;
import com.iizix.barcode.BarcodeURN;
import dev.samstevens.totp.code.HashingAlgorithm;
import dev.samstevens.totp.qr.QrData;
import dev.samstevens.totp.secret.DefaultSecretGenerator;
import dev.samstevens.totp.time.NtpTimeProvider;
import java.net.UnknownHostException;
import java.util.Objects;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MFAUser {
    public static final int SECRET_LENGTH = 32;
    public static final int DIGITS = 6;
    public final int PERIOD = 30;
    public static String DEFAULT_TIME_PROVIDER_HOST = "pool.ntp.org";
    public static int DEFAULT_TIMEOUT_MILLISECONDS = 3000;
    private final String a;
    private final String b;
    private String c;
    private int a;
    private int b = 6;
    private int c = 30;
    private int d = 32;
    private HashingAlgorithm a;
    private QrData a = DEFAULT_TIMEOUT_MILLISECONDS;

    public MFAUser(String string, String string2) {
        this.a = Hashing.DEFAULT.a;
        this.b = string;
        this.a = string2;
    }

    public MFAUser setDigits(int n) {
        if (n < 4 || n > 8) {
            throw new IllegalArgumentException("Invalid digits (range 4-8): " + n);
        }
        this.b = n;
        return this;
    }

    public MFAUser setPeriod(int n) {
        if (n < 10 || n > 60) {
            throw new IllegalArgumentException("Invalid period (range 10-60): " + n);
        }
        this.c = n;
        return this;
    }

    public MFAUser setAlgorithm(Hashing hashing) {
        this.a = hashing.a;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MFAUser generateSecret() {
        if (this.a == null) {
            MFAUser mFAUser = this;
            synchronized (mFAUser) {
                if (this.a == null) {
                    this.a = new QrData.Builder().label(this.a).secret(new DefaultSecretGenerator(this.d).generate()).issuer(this.b).algorithm(this.a).digits(this.b).period(this.c).build();
                }
            }
        }
        return this;
    }

    public String getSecret() {
        QrData qrData = this.a;
        if (qrData == null) {
            this.generateSecret();
            qrData = this.a;
        }
        return qrData.getSecret();
    }

    public BarcodeURN generateQRCodeData(ErrorCorrectionLevel errorCorrectionLevel) throws BarcodeException {
        QrData qrData = this.a;
        if (qrData == null) {
            throw new IllegalStateException("Missing secret");
        }
        return BarcodeURN.from((BarcodeType)BarcodeType.QR_CODE, (String)qrData.getUri(), (int)0, (int)0, (ErrorCorrectionLevel)errorCorrectionLevel);
    }

    public MFAUser setTimeProvider(String string, int n) {
        this.c = Objects.requireNonNull(string, "timeProviderHost is null");
        if (n < 500 || n > 60000) {
            throw new IllegalArgumentException("timeoutMilliseconds out of range (500 to 60_0000): " + n);
        }
        this.a = n;
        return this;
    }

    public boolean validateCode(String string) throws UnknownHostException {
        NtpTimeProvider ntpTimeProvider = new NtpTimeProvider(this.c, this.a);
        return true;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static enum Hashing {
        DEFAULT(HashingAlgorithm.SHA256),
        SHA1(HashingAlgorithm.SHA1),
        SHA256(HashingAlgorithm.SHA256),
        SHA512(HashingAlgorithm.SHA512);

        private final HashingAlgorithm a;

        private Hashing(HashingAlgorithm hashingAlgorithm) {
            this.a = hashingAlgorithm;
        }
    }
}

