/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.editor;

import com.iizigo.dnd.ClipboardHelper;
import com.iizigo.editor.IClipboardSelection;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Point;

public abstract class SyntSelectionProvider
implements IClipboardSelection,
ISelectionProvider {
    private final ISelectionProvider a;

    private SyntSelectionProvider() {
        this(null);
    }

    private SyntSelectionProvider(ISelectionProvider iSelectionProvider) {
        this.a = iSelectionProvider;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        throw new InternalError("Not used");
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        throw new InternalError("Not used");
    }

    public ISelection getSelection() {
        Point point = this._getSelection();
        int n2 = Math.min(point.x, point.y);
        int n3 = Math.min(point.x, point.y);
        return new TextSelection(n2, n3 - n2);
    }

    public void setSelection(ISelection iSelection) {
        int n2 = 0;
        int n3 = 0;
        if (iSelection instanceof ITextSelection) {
            ITextSelection iTextSelection = (ITextSelection)iSelection;
            n2 = iTextSelection.getOffset();
            n3 = iTextSelection.getLength() + n2;
        } else if (!iSelection.isEmpty()) {
            return;
        }
        this._setSelection(n2, n3);
    }

    @Override
    public boolean canPaste() {
        return this.isEnabled() && ClipboardHelper.doesClipboardContainText(false);
    }

    @Override
    public boolean canCut() {
        if (this.isPassword()) {
            return false;
        }
        return this.canDelete();
    }

    @Override
    public boolean canCopy() {
        if (this.isPassword()) {
            return false;
        }
        Point point = this._getSelection();
        return point.x != point.y;
    }

    @Override
    public boolean canDelete() {
        if (!this.isEnabled()) {
            return false;
        }
        Point point = this._getSelection();
        return point.x != point.y;
    }

    @Override
    public void delete() {
        Point point = this._getSelection();
        if (point.x != point.y) {
            String string = this.getText();
            try {
                int n2 = Math.min(point.x, point.y);
                int n3 = Math.max(point.x, point.y);
                Object object = string.substring(0, n2);
                if (string.length() > n3 + 1) {
                    object = (String)object + string.substring(n3 + 1);
                }
                this.setText((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void selectAll() {
        int n2 = this.getText().length();
        this._setSelection(0, n2);
    }

    protected abstract boolean isEnabled();

    protected abstract String getText();

    protected abstract void setText(String var1);

    protected boolean isPassword() {
        return false;
    }

    @Override
    public abstract void copy();

    @Override
    public abstract void cut();

    @Override
    public abstract void paste();

    protected abstract void _setSelection(int var1, int var2);

    protected abstract Point _getSelection();

    public static class CCombo
    extends SyntSelectionProvider {
        private final org.eclipse.swt.custom.CCombo a;

        public CCombo(org.eclipse.swt.custom.CCombo cCombo) {
            this.a = cCombo;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        protected void setText(String string) {
            this.a.setText(string);
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
            this.a.setSelection(new Point(n2, n3));
        }

        @Override
        protected Point _getSelection() {
            return this.a.getSelection();
        }
    }

    public static class Combo
    extends SyntSelectionProvider {
        private final org.eclipse.swt.widgets.Combo a;

        public Combo(org.eclipse.swt.widgets.Combo combo) {
            this.a = combo;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        protected void setText(String string) {
            this.a.setText(string);
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
            this.a.setSelection(new Point(n2, n3));
        }

        @Override
        protected Point _getSelection() {
            return this.a.getSelection();
        }
    }

    public static class IZ_CCombo
    extends SyntSelectionProvider {
        private final com.iizix.swt.widget.IZ_CCombo a;

        public IZ_CCombo(com.iizix.swt.widget.IZ_CCombo iZ_CCombo) {
            this.a = iZ_CCombo;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        protected void setText(String string) {
            this.a.setText(string);
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
            this.a.setSelection(new Point(n2, n3));
        }

        @Override
        protected Point _getSelection() {
            return this.a.getSelection();
        }
    }

    public static class Spinner
    extends SyntSelectionProvider {
        private final org.eclipse.swt.widgets.Spinner a;

        public Spinner(org.eclipse.swt.widgets.Spinner spinner) {
            this.a = spinner;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
        }

        @Override
        protected Point _getSelection() {
            String string = Integer.toString(this.a.getSelection());
            return new Point(0, string.length());
        }

        @Override
        protected void setText(String string) {
            try {
                int n2 = Integer.parseInt(string.trim());
                this.a.setSelection(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class StyledText
    extends SyntSelectionProvider {
        private final org.eclipse.swt.custom.StyledText a;

        public StyledText(org.eclipse.swt.custom.StyledText styledText, ISelectionProvider iSelectionProvider) {
            super(iSelectionProvider);
            this.a = styledText;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        protected void setText(String string) {
            this.a.setText(string);
        }

        @Override
        protected boolean isPassword() {
            return (this.a.getStyle() & 0x400000) != 0;
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
            this.a.setSelection(n2, n3);
        }

        @Override
        protected Point _getSelection() {
            return this.a.getSelection();
        }
    }

    public static class Text
    extends SyntSelectionProvider {
        private final org.eclipse.swt.widgets.Text a;

        public Text(org.eclipse.swt.widgets.Text text) {
            this.a = text;
        }

        @Override
        protected boolean isEnabled() {
            return this.a.isEnabled();
        }

        @Override
        protected String getText() {
            return this.a.getText();
        }

        @Override
        protected void setText(String string) {
            this.a.setText(string);
        }

        @Override
        protected boolean isPassword() {
            return (this.a.getStyle() & 0x400000) != 0;
        }

        @Override
        public void copy() {
            this.a.copy();
        }

        @Override
        public void cut() {
            this.a.cut();
        }

        @Override
        public void paste() {
            this.a.paste();
        }

        @Override
        protected void _setSelection(int n2, int n3) {
            this.a.setSelection(n2, n3);
        }

        @Override
        protected Point _getSelection() {
            return this.a.getSelection();
        }
    }
}

