/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.url;

import com.iizix.urn.IURNProvider;
import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.NSSException;
import com.iizix.urn.URN;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResourceType;
import com.iizix.urn.url.URL_URN;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.List;

public class URL_URNFactory
implements IURNProvider {
    private static final URL_URNFactory a = new URL_URNFactory();

    public static void initialize(URNFactory uRNFactory) {
        uRNFactory.register(a);
    }

    public static URL_URNFactory getInstance() {
        return a;
    }

    private URL_URNFactory() {
    }

    @Override
    public NID getNID() {
        return NID.URL;
    }

    @Override
    public List<URNResourceType> getResourceTypes() {
        return Collections.emptyList();
    }

    @Override
    public URN parse(String string, String string2, String string3, String string4, String string5) throws URNException {
        URL uRL;
        if (string3 != null) {
            throw new NIDException("URL URN should not contain a request part '?+': " + string3, string, NID.URL);
        }
        Object object = string2;
        if (string4 != null) {
            object = (String)object + "?" + string4;
        }
        if (string5 != null) {
            object = (String)object + "#" + string5;
        }
        try {
            uRL = new URI((String)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new NSSException("Malformed URL in URN: " + malformedURLException.getMessage(), string, string2, malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new NSSException("Syntax exception in the URL of the URN: " + uRISyntaxException.getMessage(), string, string2, uRISyntaxException);
        }
        return new URL_URN(string, uRL);
    }
}

