/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.value;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.DateTimeProp;
import com.iizix.prop.GDateTime;
import com.iizix.prop.PropException;
import com.iizix.prop.ui.value.IUIDateTimeComponent;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Date;

public interface IUITimeValueComponent
extends IUIDateTimeComponent {
    @Override
    default public boolean isDateValueSupported() {
        return false;
    }

    @Override
    default public boolean isDateValueRequired() {
        return false;
    }

    @Override
    default public boolean isTimeValueSupported() {
        return true;
    }

    @Override
    default public boolean isTimeValueRequired() {
        return true;
    }

    @Override
    default public boolean setValue(GDateTime gDateTime) throws IllegalArgumentException {
        try {
            gDateTime = gDateTime.toTimeValue();
            DateTimeProp dateTimeProp = this.getProp(Atom.VALUE, DateTimeProp.class);
            if (dateTimeProp != null) {
                return dateTimeProp.setPropValue(gDateTime);
            }
            dateTimeProp = this.createValueProp();
            dateTimeProp.setPropValue(gDateTime);
            return this.setProp(dateTimeProp);
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed setting value: " + String.valueOf(gDateTime), propException);
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException("Value has no time component: " + String.valueOf(gDateTime), illegalStateException);
        }
    }

    default public boolean setValue(LocalTime localTime) throws IllegalArgumentException {
        return this.setValue(new GDateTime(localTime));
    }

    default public boolean setValue(Date date) throws IllegalArgumentException {
        return this.setValue(GDateTime.fromTime(date));
    }

    default public boolean setValue(Time time) throws IllegalArgumentException {
        return this.setValue(GDateTime.fromTime(time));
    }

    default public boolean setValue(Timestamp timestamp) throws IllegalArgumentException {
        return this.setValue(GDateTime.fromTime(timestamp));
    }

    default public LocalTime getLocalTime() {
        return this.getValue().toLocalTime();
    }

    default public Time getSQLTime() {
        return Time.valueOf(this.getValue().toLocalTime());
    }
}

