/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.NotFoundException;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.DateTimeProp;
import com.iizix.prop.GDateTime;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.value.IUIDateValueComponent;
import com.iizix.prop.vs.VSField;
import java.time.LocalDate;

public class UICalendar
extends UIComp
implements IUIContextMenuOwner,
IUIFocusComp,
IUIDateValueComponent {
    public UICalendar() {
    }

    public UICalendar(Atom atom) {
        super(atom);
    }

    public UICalendar(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return true;
    }

    @Override
    public boolean canFillX() {
        return false;
    }

    @Override
    public boolean canFillY() {
        return false;
    }

    @Override
    public int setComponentToVSField() {
        VSField vSField = this.vsField;
        if (this.enterVSProcessing(vSField)) {
            try {
                vSField.adjustValue(this.getLocalDate(), vSField);
                this.setVSFieldMessageToComponent(vSField, true);
                return 1;
            }
            catch (NotFoundException notFoundException) {
            }
            catch (ValueConversionException valueConversionException) {
                this.setErrorMessage(valueConversionException);
                return -1;
            }
            finally {
                this.exitVSProcessing();
            }
        }
        return 0;
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        if (vSField == this.vsField && this.enterVSProcessing(vSField)) {
            try {
                try {
                    this.setValue(vSField.get_LocalDate());
                }
                catch (ValueConversionException valueConversionException) {
                    this.setErrorMessage(valueConversionException);
                    this.exitVSProcessing();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.setErrorMessage(illegalArgumentException.getMessage());
                    this.exitVSProcessing();
                }
            }
            finally {
                this.exitVSProcessing();
            }
        }
    }

    @Override
    public GDateTime getDefaultValue() {
        return GDateTime.EPOCH_DATE;
    }

    public LocalDate getStartDate() {
        LocalDate localDate = null;
        GDateTime gDateTime = this.getPropValue("startDate", GDateTime.class);
        if (gDateTime != null) {
            localDate = gDateTime.getLocalDate();
        }
        return localDate;
    }

    public LocalDate getEndDate() {
        LocalDate localDate = null;
        GDateTime gDateTime = this.getPropValue("endDate", GDateTime.class);
        if (gDateTime != null) {
            localDate = gDateTime.getLocalDate();
        }
        return localDate;
    }

    public boolean setStartAndEndDates(LocalDate localDate, LocalDate localDate2) {
        if (localDate != null && localDate2 != null) {
            if (localDate2.isBefore(localDate)) {
                throw new IllegalArgumentException("start date " + String.valueOf(localDate) + " is after end date " + String.valueOf(localDate2));
            }
            if (localDate2.equals(localDate)) {
                throw new IllegalArgumentException("start date equals end date " + String.valueOf(localDate));
            }
        }
        GDateTime gDateTime = localDate != null ? new GDateTime(localDate) : null;
        boolean bl = this.setPropValue("startDate", gDateTime, DateTimeProp.class);
        gDateTime = localDate2 != null ? new GDateTime(localDate2) : null;
        return bl |= this.setPropValue("endDate", gDateTime, DateTimeProp.class);
    }

    public int getDayFormat() {
        int n2 = this.getInt("dayWidth", 0);
        return n2 < 0 ? 0 : (n2 > 2 ? 2 : n2);
    }

    public boolean setDayFormat(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("formatOrWidth range error (0-2): " + n2);
        }
        Integer n3 = n2 > 0 ? Integer.valueOf(n2) : null;
        return this.setPropValue("dayWidth", n3, IntProp.class);
    }

    @Override
    public Size getApproximateSize() {
        return new Size(400, 300);
    }
}

