/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.security;

import com.iizix.ILog;
import com.iizix.XMLUtilities;
import com.iizix.gyro.ISensitiveParameterHandler;
import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.server.ServerShell;
import com.iizix.server.security.ServerKey;
import com.iizix.server.security.ServerKeysProp;
import com.iizix.virtual.VirtualThreadGroup;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerSecurityManager
implements ISensitiveParameterHandler {
    private static ServerSecurityManager a;
    private static final String[] a;
    private long a;
    public static final String DEFAULT_SERVER_KEYS_FILENAME = "iiziServer.keys";
    private static String a;
    private File a;
    private boolean a;
    private final LinkedHashMap<String, ServerKey> a;
    private long b;
    private ServerKey a;
    private boolean b;
    private final VirtualThreadGroup a;
    private final ServerShell a;
    private PropFactory a;
    private PropMgr a = new LinkedHashMap();

    static {
        a = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA1", "MD5"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerSecurityManager getInstance() {
        ServerSecurityManager serverSecurityManager = a;
        if (serverSecurityManager != null) return serverSecurityManager;
        Class<ServerSecurityManager> clazz = ServerSecurityManager.class;
        synchronized (ServerSecurityManager.class) {
            serverSecurityManager = a;
            if (serverSecurityManager != null) return serverSecurityManager;
            a = new ServerSecurityManager();
            return a;
        }
    }

    public static byte[] digest(byte[] byArray) {
        MessageDigest messageDigest;
        if (a != null) {
            try {
                messageDigest = MessageDigest.getInstance(a);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("Shoudln't be", noSuchAlgorithmException);
            }
        }
        Class<ServerSecurityManager> clazz = ServerSecurityManager.class;
        synchronized (ServerSecurityManager.class) {
            block9: {
                String[] stringArray = a;
                int n = a.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    try {
                        messageDigest = MessageDigest.getInstance(string);
                        a = string;
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        break block9;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        ++n2;
                    }
                }
                throw new InternalError("No digest algorithms found among " + Arrays.toString(a));
            }
            return messageDigest.digest(byArray);
        }
    }

    private ServerSecurityManager() {
        this.b = this.a;
        this.a = ServerShell.getInstance();
        VirtualThreadGroup virtualThreadGroup = null;
        if (this.a != null) {
            virtualThreadGroup = this.a.getServerThreadGroup();
            int n = this.a.getServerSettings().getMaximumServerKeyAge();
            this.b = 86400000L * (long)n;
            ILog.INFO(this.getClass(), (String)("Maximum server key age initialized to " + n + " days"));
        }
        this.a = virtualThreadGroup;
    }

    public void setKeyTimeout(long l) {
        if (l < 3600000L) {
            throw new IllegalArgumentException("Timeout is too short (must be at least one hour): " + l + " ms");
        }
        this.b = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadKeys(File file) throws IOException, PropException {
        long l = 0L;
        ServerKey object = null;
        if (file.isFile()) {
            PropCnr propCnr = this.a != null ? this.a.loadFile(file) : this.a.loadPropTree(this.a, file, true);
            if (!(propCnr instanceof ServerKeysProp)) {
                throw new IOException("File " + file.getAbsolutePath() + " did not container a ServerKeysProp instance but: " + String.valueOf(propCnr));
            }
            List<ServerKey> list = ((ServerKeysProp)propCnr).getKeys();
            for (ServerKey serverKey : list) {
                long l2 = serverKey.a();
                if (l2 <= l) continue;
                object = serverKey;
                l = l2;
            }
            ServerSecurityManager serverSecurityManager = this.a;
            synchronized (serverSecurityManager) {
                ((LinkedHashMap)((Object)this.a)).clear();
                for (ServerKey serverKey : list) {
                    ((HashMap)((Object)this.a)).put(serverKey.getFingerPrint(), serverKey);
                }
            }
            ILog.INFO(this.getClass(), (String)("Loaded server keys file \"" + file.getAbsolutePath() + "\""));
        }
        this.a = true;
        this.a = object;
        this.a = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerKey getServerKey() {
        this.a();
        ServerSecurityManager serverSecurityManager = this.a;
        synchronized (serverSecurityManager) {
            long l;
            ServerKey serverKey = this.a;
            long l2 = l = serverKey != null ? serverKey.a() : 0L;
            if (serverKey == null || l + this.b > System.currentTimeMillis()) {
                serverKey = new ServerKey();
                ((HashMap)((Object)this.a)).put(serverKey.getFingerPrint(), serverKey);
                this.b();
            }
            return serverKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        ServerSecurityManager serverSecurityManager = this.a;
        synchronized (serverSecurityManager) {
            File file;
            if (!this.a && (file = this.a) != null) {
                try {
                    this.loadKeys(file);
                    this.a = true;
                    ILog.INFO(this.getClass(), (String)("Loaded server keys from file \"" + file.getAbsolutePath() + "\""));
                }
                catch (PropException | IOException throwable) {
                    ILog.SEVERE(this.getClass(), (String)("Failed loading the server keys file \"" + file.getAbsolutePath() + "\""));
                }
            }
        }
    }

    private void b() {
        File file = this.a;
        if (this.b || file == null) {
            return;
        }
        if (this.a != null) {
            this.a.startThread(() -> {
                if (this.b) {
                    return;
                }
                try {
                    this.a(file);
                }
                catch (PropException | IOException throwable) {
                    ILog.SEVERE(ServerSecurityManager.class, (String)("Failed saving server keys file \"" + String.valueOf(this.a) + "\""), (Throwable)throwable);
                }
            }, "ServerKeysSaver");
        } else {
            try {
                this.a(file);
            }
            catch (PropException | IOException throwable) {
                ILog.SEVERE(ServerSecurityManager.class, (String)("Failed saving server keys file \"" + String.valueOf(this.a) + "\""), (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) throws IOException, PropException {
        ServerKey[] serverKeyArray;
        ServerKeysProp serverKeysProp = new ServerKeysProp(Atom.SERVER);
        Object object = this.a;
        synchronized (object) {
            serverKeyArray = ((LinkedHashMap)((Object)this.a)).values().toArray(new ServerKey[((HashMap)((Object)this.a)).size()]);
        }
        ServerKey[] serverKeyArray2 = serverKeyArray;
        int n = serverKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = serverKeyArray2[n2];
            serverKeysProp.a((ServerKey)object);
            ++n2;
        }
        object = ServerShell.getInstance();
        if (object != null) {
            ((ServerShell)object).saveFile(file, serverKeysProp);
        } else {
            try {
                XMLUtilities.saveXMLDocument((Document)this.a.createDocument((PropCnr)serverKeysProp), (File)file);
            }
            catch (TransformerException transformerException) {
                throw new IOException("Failed transforming the XML document for file " + file.getAbsolutePath(), transformerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ServerSecurityManager serverSecurityManager = this.a;
        synchronized (serverSecurityManager) {
            if (this.b) {
                return;
            }
            this.b = true;
            ((LinkedHashMap)((Object)this.a)).clear();
        }
        if (this == a) {
            a = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decodeParameter(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, DigestException {
        ServerKey serverKey;
        this.a();
        int n = string.lastIndexOf(44);
        if (n < 0) {
            throw new NoSuchPaddingException("Missing ',': " + string);
        }
        String string2 = string.substring(n + 1);
        ServerSecurityManager serverSecurityManager = this.a;
        synchronized (serverSecurityManager) {
            serverKey = (ServerKey)((LinkedHashMap)((Object)this.a)).get(string2);
        }
        if (serverKey == null) {
            throw new NoSuchPaddingException("Server key fingerprint \"" + string2 + "\" not found");
        }
        return serverKey.a(string.substring(0, n));
    }

    public String encodeParameter(String string) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        ServerKey serverKey = this.getServerKey();
        return serverKey.b(string) + "," + serverKey.getFingerPrint();
    }
}

