/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.region;

import com.iizix.ILog;
import com.iizix.IWebServiceEngine;
import com.iizix.Utilities;
import com.iizix.geo.RegionLocation;
import com.iizix.geo.RegionLocationService;
import com.iizix.server.prop.ServerSettings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeoPlugin
extends RegionLocationService {
    private final String a;
    private final Proxy a = "http://www.geoplugin.net/json.gp";

    public GeoPlugin(IWebServiceEngine iWebServiceEngine, ServerSettings serverSettings) {
        super("GeoPlugin", 20000L);
        try {
            this.a = iWebServiceEngine.getProxy(new URI(this.a).toURL());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new InternalError("Shouldn't be", exception);
        }
    }

    protected RegionLocation request(String string) throws IOException, InterruptedIOException, InterruptedException, JSONException {
        URL uRL;
        String string2 = this.a + "?ip=" + Utilities.encodeURIComponent((String)string);
        try {
            uRL = new URI(string2).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IOException("Geolocation URI is in error: " + string2, exception);
        }
        JSONObject jSONObject = this.parse(uRL.openConnection(this.a));
        try {
            int n = -1;
            if (jSONObject.isNull("geoplugin_status") || (n = jSONObject.getInt("geoplugin_status")) < 200 || n > 299) {
                return new RegionLocation(string, "GeoPlugin: not found, status = " + n);
            }
            return new RegionLocation(string, jSONObject.optString("geoplugin_continentName", null), jSONObject.optString("geoplugin_continentCode", null), jSONObject.optString("geoplugin_countryName", null), jSONObject.optString("geoplugin_countryCode", null), -1, jSONObject.optString("geoplugin_regionName", null), jSONObject.optString("geoplugin_regionCode", null), jSONObject.optString("geoplugin_city", null), null, -1, null, -1, jSONObject.optDouble("geoplugin_longitude"), jSONObject.optDouble("geoplugin_latitude"), jSONObject.optDouble("geoplugin_locationAccuracyRadius", -1.0), null, RegionLocation.timezoneFrom((String)jSONObject.optString("geoplugin_timezone"), null, null), RegionLocation.currencyFrom((String)jSONObject.optString("geoplugin_currencyCode", null), null, null, (String)jSONObject.optString("geoplugin_currencySymbol", null), (String)jSONObject.optString("geoplugin_currencySymbol_UTF8", null)), null, null, null);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Failed extracting values from JSON for IP address " + string + ": " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return new RegionLocation(string, "Failed parsing JSON reply: " + jSONException.getMessage());
        }
    }
}

