/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.EnumeratorFromIterator;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.event.PropValueEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StringSetProp
extends GProp<Set<String>> {
    private static final Class<?>[] a = new Class[]{Set.class, Iterable.class, Iterator.class, Enumeration.class};
    private LinkedHashSet<String> a;
    private Set<String> a = Collections.synchronizedSet(this.a);

    protected StringSetProp() {
        this.setPropValueIncognito(this.a);
    }

    public StringSetProp(Atom atom) {
        super(atom);
        this.setPropValueIncognito(this.a);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    public StringSetProp clone() throws CloneNotSupportedException {
        StringSetProp stringSetProp = (StringSetProp)super.clone();
        stringSetProp.a = (LinkedHashSet)stringSetProp.a.clone();
        stringSetProp.a = Collections.synchronizedSet(stringSetProp.a);
        stringSetProp.setPropValueIncognito(stringSetProp.a);
        return stringSetProp;
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Set)) {
            throw new PropTypeException(this, "Not a Set<?>");
        }
        for (Object e2 : (Set)object) {
            if (e2 instanceof String) continue;
            throw new PropTypeException(this, "Not a Set<String>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int modifyPropValue(Object object, Object object2, PropMgr propMgr) throws PropException {
        try {
            Set set = (Set)object2;
            Class<?>[] classArray = this.a;
            synchronized (this.a) {
                if (this.equalValues((GProp<?>)this, (Set<String>)this.a, set, 0) == null) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return 0;
                }
                this.a.clear();
                this.a.addAll(set);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return 2;
            }
        }
        catch (Throwable throwable) {
            throw new PropException(this, "modifyPropertyValue error: " + String.valueOf(throwable), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object equalValues(GProp<?> gProp, Set<String> set, Set<String> set2, int n2) {
        if (set == null && set2 == null) {
            return null;
        }
        if (set == null || set2 == null) return this;
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            int n3 = this.a.size();
            if (n3 != set2.size()) return this;
            try {
                Iterator<String> iterator = set2.iterator();
                Iterator iterator2 = this.a.iterator();
                while (--n3 >= 0) {
                    if (iterator.next().equals(iterator2.next())) continue;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this;
                }
                if (!iterator.hasNext() && !iterator2.hasNext()) return null;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this;
            }
            catch (Exception exception) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            sendTransaction.appendUnsigned(this.a.size());
            for (String string : this.a) {
                sendTransaction.appendString(string);
            }
            // ** MonitorExit[classArray] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            int n2 = readTransaction.readUnsigned();
            boolean bl = n2 > 0 || this.a.size() != n2;
            this.a.clear();
            while (n2-- > 0) {
                this.a.add(readTransaction.readString());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bl;
        }
    }

    @Override
    public void initializeProp(Element element) throws PropException {
        this.throwIfReadOnly();
        boolean bl = this.a.size() > 0;
        this.a.clear();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && node.getNodeName().equals("string")) {
                Attr attr = ((Element)node).getAttributeNode("value");
                if (attr == null) {
                    throw new PropException(this, "<string> doesn't contain 'value' attribute");
                }
                this.a.add(attr.getNodeValue());
                bl = true;
            }
            node = node.getNextSibling();
        }
        if (bl) {
            this.setChanged();
            this.d();
        }
    }

    @Override
    protected void initializeElement(Element element) {
        while (element.hasChildNodes()) {
            element.removeChild(element.getLastChild());
        }
        Document document = element.getOwnerDocument();
        for (String string : this.a) {
            Element element2 = document.createElement("string");
            element2.setAttribute("value", string);
            element.appendChild(element2);
        }
    }

    private void d() {
        this.onEvent(new PropValueEvent(this, this.a, this.a));
    }

    public boolean addString(String string) throws PropTypeException {
        if (string == null) {
            throw new NullPointerException("string=null");
        }
        this.throwIfReadOnly();
        boolean bl = this.a.add(string);
        if (bl) {
            this.setChanged();
            this.d();
        }
        return bl;
    }

    public boolean hasString(String string) {
        return this.a.contains(string);
    }

    public boolean removeAll() throws PropTypeException {
        if (this.a.isEmpty()) {
            return false;
        }
        this.throwIfReadOnly();
        this.a.clear();
        this.setChanged();
        this.d();
        return true;
    }

    public boolean removeString(String string) throws PropTypeException {
        this.throwIfReadOnly();
        boolean bl = this.a.remove(string);
        if (bl) {
            this.setChanged();
            this.d();
        }
        return bl;
    }

    public Set<String> getSet() {
        return this.isPropReadOnly() ? Collections.unmodifiableSet(this.a) : this.a;
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        Set set = (Set)object;
        switch (n2) {
            case 1: {
                return set;
            }
            case 2: {
                return set.iterator();
            }
            case 3: {
                return EnumeratorFromIterator.createEnumerator(set.iterator());
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        LinkedHashSet<String> linkedHashSet;
        switch (n2) {
            case 1: {
                linkedHashSet = new LinkedHashSet<String>();
                Iterator iterator = ((Iterable)object).iterator();
                while (iterator.hasNext()) {
                    linkedHashSet.add((String)iterator.next());
                }
                break;
            }
            case 2: {
                linkedHashSet = new LinkedHashSet();
                Iterator iterator = (Iterator)object;
                while (iterator.hasNext()) {
                    linkedHashSet.add((String)iterator.next());
                }
                break;
            }
            case 3: {
                linkedHashSet = new LinkedHashSet();
                Enumeration enumeration = (Enumeration)object;
                while (enumeration.hasMoreElements()) {
                    linkedHashSet.add((String)enumeration.nextElement());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return linkedHashSet;
    }
}

