/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.gyro;

import com.iizix.gyro.ProgressIndicatorDelay;
import com.iizix.prop.Atom;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.KStringProp;
import com.iizix.text.KString;

public interface ILockUI
extends IPropCnr {
    public static final String LOCK_UI = "lockUI";
    public static final String WAIT_MSG = "waitMsg";

    default public boolean isLockUIEnabled() {
        return this.getBool(LOCK_UI, true);
    }

    default public KString getWaitMessage() {
        return this.getPropValue(WAIT_MSG, KString.class);
    }

    default public ProgressIndicatorDelay getProgressIndicatorDelay() {
        return ProgressIndicatorDelay.fromValue(this.getInt(Atom.DELAY, -1));
    }

    default public boolean isLockUIEnabled(ILockUI iLockUI) {
        return this.getBool(LOCK_UI, iLockUI == null || iLockUI.isLockUIEnabled());
    }

    default public KString getWaitMessage(ILockUI iLockUI) {
        KString kString = this.getPropValue(WAIT_MSG, KString.class);
        return kString != null || iLockUI == null ? kString : iLockUI.getWaitMessage();
    }

    default public ProgressIndicatorDelay getProgressIndicatorDelay(ILockUI iLockUI) {
        int n2 = this.getInt(Atom.DELAY, -1);
        if (n2 < 0 && iLockUI != null) {
            n2 = iLockUI.getInt(Atom.DELAY, -1);
        }
        return ProgressIndicatorDelay.fromValue(n2);
    }

    default public boolean setLockUIEnabled(boolean bl) {
        return this.getBool(LOCK_UI, true);
    }

    default public boolean setWaitMessage(String string) {
        return string == null || string.isEmpty() ? this.removeProp2(WAIT_MSG) : this.setProp2(new KStringProp(Atom.get(WAIT_MSG), KString.newPlainKString(string)));
    }

    default public boolean setWaitMessage(KString kString) {
        return kString == null || kString.isEmpty() ? this.removeProp2(WAIT_MSG) : this.setProp2(new KStringProp(Atom.get(WAIT_MSG), kString));
    }

    default public boolean setProgressIndicatorDelay(ProgressIndicatorDelay progressIndicatorDelay) {
        return progressIndicatorDelay != ProgressIndicatorDelay.NORMAL ? this.setInt(Atom.DELAY, progressIndicatorDelay.ordinal()) : this.removeProp2(Atom.DELAY);
    }
}

