/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.support;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.opentest4j.TestAbortedException;

class OpenTest4JAndJUnit4AwareThrowableCollector
extends ThrowableCollector {
    private static final Logger logger = LoggerFactory.getLogger(OpenTest4JAndJUnit4AwareThrowableCollector.class);
    private static final String ASSUMPTION_VIOLATED_EXCEPTION = "org.junit.internal.AssumptionViolatedException";
    private static final String COMMON_FAILURE_MESSAGE = "Failed to load class org.junit.internal.AssumptionViolatedException: only supporting " + TestAbortedException.class.getName() + " for aborted execution.";
    private static final Predicate<? super Throwable> abortedExecutionPredicate = OpenTest4JAndJUnit4AwareThrowableCollector.createAbortedExecutionPredicate();

    OpenTest4JAndJUnit4AwareThrowableCollector() {
        super(abortedExecutionPredicate);
    }

    private static Predicate<? super Throwable> createAbortedExecutionPredicate() {
        Predicate<Throwable> otaPredicate = TestAbortedException.class::isInstance;
        try {
            Class clazz = (Class)ReflectionSupport.tryToLoadClass((String)ASSUMPTION_VIOLATED_EXCEPTION).get();
            if (clazz != null) {
                return otaPredicate.or(clazz::isInstance);
            }
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
            Supplier<String> messageSupplier = throwable instanceof NoClassDefFoundError ? () -> COMMON_FAILURE_MESSAGE + " Note that org.junit.internal.AssumptionViolatedException requires that Hamcrest is on the classpath." : () -> COMMON_FAILURE_MESSAGE;
            logger.debug(throwable, messageSupplier);
        }
        return otaPredicate;
    }
}

