/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.app;

import com.iizigo.app.EclipseIPathDirectory;
import com.iizix.app.builder.IIFile;
import com.iizix.app.builder.IIResource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EclipseIPathFile
implements IIFile {
    private final IPath a;
    private final IFileStore a;
    private final IFileInfo a;
    private File a;

    public static IIResource newResource(IPath iPath) throws IOException {
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        if (iFileInfo.exists()) {
            throw new FileNotFoundException("Path not found: " + String.valueOf(iPath.makeAbsolute()));
        }
        return iFileInfo.isDirectory() ? new EclipseIPathDirectory(iPath, iFileStore) : new EclipseIPathFile(iPath, iFileStore);
    }

    public EclipseIPathFile(IPath iPath, IFileStore iFileStore) throws IOException {
        this.a = iPath.makeAbsolute();
        this.a = iFileStore != null ? iFileStore : EFS.getLocalFileSystem().getStore(iPath);
        this.a = this.a.fetchInfo();
        if (!this.a.exists()) {
            throw new FileNotFoundException("File '" + String.valueOf(iPath.makeAbsolute()) + "' is not found");
        }
        if (this.a.isDirectory()) {
            throw new IOException("File '" + String.valueOf(iPath.makeAbsolute()) + "' is a directory");
        }
    }

    public String getFullPath() {
        return this.a.toPortableString();
    }

    public File getFile(Object object) throws IOException {
        if (this.a == null) {
            try {
                this.a = this.a.toLocalFile(0, (IProgressMonitor)object).getCanonicalFile();
            }
            catch (CoreException coreException) {
                throw new IOException("Failed getting file '" + this.a.getName() + "'", coreException);
            }
        }
        return this.a;
    }

    public InputStream openInputStream(Object object) throws IOException {
        try {
            return this.a.openInputStream(0, (IProgressMonitor)object);
        }
        catch (CoreException coreException) {
            throw new IOException("Failed opening file '" + this.getFullPath() + "'", coreException);
        }
    }

    public boolean isDirectory() {
        return false;
    }

    public String getName() {
        return this.a.getName();
    }

    public boolean equals(Object object) {
        try {
            IIResource iIResource;
            return object instanceof IIResource && (iIResource = (IIResource)object).getFullPath().equals(this.getFullPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public long getFileSize() {
        return this.a != null ? this.a.length() : this.a.fetchInfo().getLength();
    }

    public long getLastModified() {
        return this.a != null ? this.a.lastModified() : this.a.fetchInfo().getLastModified();
    }
}

