/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.chart.axis2d;

import com.iizix.prop.Atom;
import com.iizix.prop.IPropCnrBooleanSettings;
import com.iizix.prop.IPropCnrChoiceSettings;
import com.iizix.prop.IPropCnrColorSettings;
import com.iizix.prop.IPropCnrFontSettings;
import com.iizix.prop.IPropCnrIntegerSettings;
import com.iizix.prop.IPropCnrKStringSettings;
import com.iizix.prop.IPropCnrNumberSettings;
import com.iizix.prop.IPropCnrStrokeSettings;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ui.chart.IChartContainer;
import com.iizix.prop.ui.chart.axis2d.AxisColor;
import com.iizix.prop.ui.chart.axis2d.AxisFixLower;
import com.iizix.prop.ui.chart.axis2d.AxisFixUpper;
import com.iizix.prop.ui.chart.axis2d.AxisFont;
import com.iizix.prop.ui.chart.axis2d.AxisInteger;
import com.iizix.prop.ui.chart.axis2d.AxisKString;
import com.iizix.prop.ui.chart.axis2d.AxisNumber;
import com.iizix.prop.ui.chart.axis2d.AxisOption;
import com.iizix.prop.ui.chart.axis2d.AxisPosition;
import com.iizix.prop.ui.chart.axis2d.AxisStroke;
import com.iizix.prop.ui.chart.axis2d.AxisTitleOrientation;
import com.iizix.prop.ui.chart.axis2d.IAxisChoiceOption;

public class Axis2D
extends PropCnr
implements IPropCnrBooleanSettings<AxisOption>,
IPropCnrChoiceSettings<IAxisChoiceOption>,
IPropCnrColorSettings<AxisColor>,
IPropCnrFontSettings<AxisFont>,
IPropCnrIntegerSettings<AxisInteger>,
IPropCnrKStringSettings<AxisKString>,
IPropCnrNumberSettings<AxisNumber>,
IPropCnrStrokeSettings<AxisStroke>,
IChartContainer {
    public Axis2D(String string) {
        this(Atom.get(string));
        if (string.startsWith("$")) {
            throw new IllegalArgumentException("Name cannot start with '$'");
        }
    }

    public Axis2D(String string, boolean bl) {
        this(Atom.get(string));
        if (string.startsWith("$")) {
            throw new IllegalArgumentException("Name cannot start with '$'");
        }
        if (bl) {
            this.setBool(AxisOption.VERTICAL.getPropName(), true);
        }
    }

    public Axis2D() {
    }

    public Axis2D(Atom atom) {
        super(atom);
    }

    @Override
    public final IChartContainer.Type getContainerType() {
        return IChartContainer.Type.AXIS;
    }

    @Override
    public Axis2D clone() {
        try {
            Axis2D axis2D = (Axis2D)super.clone();
            return axis2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public AxisFixLower getFixLower() {
        return (AxisFixLower)AxisFixLower.NONE.get(this);
    }

    public AxisFixUpper getFixUpper() {
        return (AxisFixUpper)AxisFixUpper.NONE.get(this);
    }

    public AxisPosition getPosition() {
        return (AxisPosition)AxisPosition.LEFT_OR_BOTTOM.get(this);
    }

    public AxisTitleOrientation getTitleOrientation() {
        return (AxisTitleOrientation)AxisTitleOrientation.AXIS.get(this);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        double d2;
        if (!super.verify(propVerification)) {
            return false;
        }
        NumberProp numberProp = this.getProp(AxisNumber.MINIMUM.getPropName(), NumberProp.class);
        NumberProp numberProp2 = this.getProp(AxisNumber.MAXIMUM.getPropName(), NumberProp.class);
        if (numberProp != null && numberProp2 != null) {
            double d3 = numberProp2.getDouble(Double.NaN);
            d2 = numberProp.getDouble(Double.NaN);
            if (!Double.isNaN(d3) && !Double.isNaN(d2)) {
                if (d3 < d2) {
                    propVerification.add(new PropVerificationError("min", PropVerificationError.Severity.ERROR, "Minimum value", numberProp, "Minimum value is greater than the maximum value", new String[0]));
                    propVerification.add(new PropVerificationError("max", PropVerificationError.Severity.ERROR, "Maximum value", numberProp2, "Maximum value is smaller than the minimum value", new String[0]));
                } else if (d3 == d2) {
                    propVerification.add(new PropVerificationError("min", PropVerificationError.Severity.ERROR, "Minimum value", numberProp, "Minimum value is equal to the maximum value", new String[0]));
                    propVerification.add(new PropVerificationError("max", PropVerificationError.Severity.ERROR, "Maximum value", numberProp2, "Maximum value is equal to the minimum value", new String[0]));
                }
            }
        }
        NumberProp numberProp3 = this.getProp(AxisNumber.FROM.getPropName(), NumberProp.class);
        NumberProp numberProp4 = this.getProp(AxisNumber.TO.getPropName(), NumberProp.class);
        if (numberProp3 != null && numberProp4 != null) {
            d2 = numberProp3.getDouble(Double.NaN);
            double d4 = numberProp4.getDouble(Double.NaN);
            if (!Double.isNaN(d2) && !Double.isNaN(d4)) {
                if (d4 < d2) {
                    propVerification.add(new PropVerificationError("from", PropVerificationError.Severity.ERROR, "From value", numberProp3, "Minimum value is greater than the maximum value", new String[0]));
                    propVerification.add(new PropVerificationError("to", PropVerificationError.Severity.ERROR, "To value", numberProp4, "Maximum value is smaller than the minimum value", new String[0]));
                } else if (d4 == d2) {
                    propVerification.add(new PropVerificationError("from", PropVerificationError.Severity.ERROR, "\"From\" value", numberProp3, "\"From\" value is equal to the \"To\" value", new String[0]));
                    propVerification.add(new PropVerificationError("to", PropVerificationError.Severity.ERROR, "\"To\" value", numberProp4, "\"To\" value is equal to the \"From\" value", new String[0]));
                }
            }
        }
        return true;
    }
}

