/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jdbc;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.jdbc.DerbyImpl;
import com.iizix.jdbc.IDBConnectionPool;
import com.iizix.jdbc.JDBCHelper;
import com.iizix.jdbc.b;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
class a
implements IDBConnectionPool {
    private static final String[] a = new String[]{"READ_UNCOMMITTED", "1", "READ_COMMITTED", "2", "REPEATABLE_READ", "4", "SERIALIZABLE", "8"};
    static final Map<String, Object> a;
    private final String a;
    private final BasicDataSource a;
    private final DerbyImpl a;
    private final IDBConnectionPool.Flavor a;

    static {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("description", "");
        hashMap.put("classpath", "");
        hashMap.put("driverClassName", "");
        hashMap.put("url", "jdbc:");
        hashMap.put("username", "");
        hashMap.put("password", "");
        hashMap.put("defaultAutoCommit", Boolean.FALSE);
        hashMap.put("enableAutoCommitOnReturn", Boolean.TRUE);
        hashMap.put("rollbackOnReturn", Boolean.TRUE);
        hashMap.put("defaultReadOnly", Boolean.FALSE);
        hashMap.put("cacheState", Boolean.TRUE);
        hashMap.put("lifo", Boolean.TRUE);
        hashMap.put("maxTotal", 8);
        hashMap.put("maxIdle", 8);
        hashMap.put("minIdle", 0);
        hashMap.put("initialSize", 0);
        hashMap.put("maxWaitMillis", -1L);
        hashMap.put("testOnCreate", Boolean.FALSE);
        hashMap.put("testOnBorrow", Boolean.TRUE);
        hashMap.put("testOnReturn", Boolean.FALSE);
        hashMap.put("timeBetweenEvictionRunsMillis", -1L);
        hashMap.put("numTestsPerEvictionRun", 3);
        hashMap.put("minEvictableIdleTimeMillis", 1800000L);
        hashMap.put("softMinEvictableIdleTimeMillis", -1L);
        hashMap.put("testWhileIdle", Boolean.FALSE);
        hashMap.put("validationQuery", "");
        hashMap.put("validationQueryTimeout", -1);
        hashMap.put("connectionInitSqls", "");
        hashMap.put("removeAbandonedOnBorrow", Boolean.FALSE);
        hashMap.put("removeAbandonedOnMaintenance", Boolean.FALSE);
        hashMap.put("removeAbandonedTimeout", 300);
        hashMap.put("abandonedUsageTracking", Boolean.FALSE);
        hashMap.put("logAbandoned", Boolean.FALSE);
        hashMap.put("poolPreparedStatements", Boolean.FALSE);
        hashMap.put("maxOpenPreparedStatements", -1);
        hashMap.put("maxConnLifetimeMillis", -1L);
        hashMap.put("logExpiredConnections", Boolean.TRUE);
        hashMap.put("defaultQueryTimeout", 30);
        hashMap.put("defaultTransactionIsolation", a);
        a = hashMap;
    }

    static Properties a(File file) throws IOException {
        if (!(file = Utilities.getCanonicalFile((File)file)).isDirectory()) {
            throw new FileNotFoundException("Directory \"" + file.getPath() + "\" does not exist");
        }
        File file2 = new File(file, "dbconf.properties");
        if (!file2.isFile()) {
            throw new FileNotFoundException("File \"" + file2.getPath() + "\" does not exist");
        }
        Properties properties = new Properties();
        Serializable serializable = null;
        Object var4_52 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), Utilities.UTF8));){
            properties.load(bufferedReader);
        }
        catch (Throwable throwable) {
            if (serializable == null) {
                serializable = throwable;
            } else if (serializable != throwable) {
                ((Throwable)serializable).addSuppressed(throwable);
            }
            throw serializable;
        }
        serializable = new Properties();
        for (Object e : properties.keySet()) {
            if (e instanceof String) {
                String string = (String)e;
                if (string.equalsIgnoreCase("debug")) {
                    JDBCHelper.a = true;
                    break;
                }
                Object object = properties.get(string);
                if (object instanceof String) {
                    String string2;
                    block31: {
                        Object object2;
                        string2 = (String)object;
                        if (string.startsWith("driver.")) {
                            string = string.substring(7);
                            object = ((Properties)serializable).remove("connectionProperties");
                            object2 = object instanceof String ? (String)object : "";
                            object2 = object2 + string + "=" + string2 + ";";
                            ((Properties)serializable).put("connectionProperties", object2);
                            continue;
                        }
                        object2 = a.get(string);
                        if (object2 == null) {
                            ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property '" + string + "' is not supported by IIZI, value: '" + string2 + "'"));
                            continue;
                        }
                        if (object2 instanceof Boolean) {
                            try {
                                Boolean.valueOf(string2);
                                break block31;
                            }
                            catch (Exception exception) {
                                ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property '" + string + "' value is not a Boolean, value: '" + string2 + "'"));
                                continue;
                            }
                        }
                        if (object2 instanceof Integer) {
                            try {
                                Integer.valueOf(string2);
                                break block31;
                            }
                            catch (Exception exception) {
                                ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property '" + string + "' value is not a Integer, value: '" + string2 + "'"));
                                continue;
                            }
                        }
                        if (object2 instanceof Long) {
                            try {
                                Long.valueOf(string2);
                                break block31;
                            }
                            catch (Exception exception) {
                                ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property '" + string + "' value is not a Long, value: '" + string2 + "'"));
                                continue;
                            }
                        }
                        if (object2 instanceof String[]) {
                            String[] exception = (String[])object2;
                            int n = 0;
                            while (n < exception.length) {
                                String string3 = exception[n++];
                                String string4 = exception[n++];
                                if (!string3.equalsIgnoreCase(string2) && !string4.equals(string2)) continue;
                                string2 = string4;
                                break;
                            }
                        } else if (!(object2 instanceof String)) {
                            throw new InternalError("supportedProperties key " + string + ": invalid value class = " + String.valueOf(object2.getClass()));
                        }
                    }
                    ((Properties)serializable).put(string, string2);
                    continue;
                }
                ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property '" + string + "' value is not a String: '" + String.valueOf(object) + "'"));
                continue;
            }
            ILog.WARNING(IDBConnectionPool.class, (String)("Database connection pool configuration file " + file2.getPath() + " property key is not a String: '" + String.valueOf(e) + "'"));
        }
        return serializable;
    }

    static IDBConnectionPool a(String string, File file, Properties properties, DerbyImpl derbyImpl) throws IOException, SQLException {
        Object object = properties.remove("initialSize");
        int n = object instanceof String ? Integer.parseInt((String)object) : 0;
        object = properties.remove("classpath");
        String string2 = object instanceof String ? (String)object : null;
        object = properties.remove("driverClassName");
        String string3 = object instanceof String ? (String)object : null;
        Object[] objectArray = JDBCHelper.getClassLoaderURLs(file, string2);
        BasicDataSource basicDataSource = null;
        try {
            basicDataSource = BasicDataSourceFactory.createDataSource((Properties)properties);
        }
        catch (Throwable throwable) {
            if (basicDataSource != null) {
                try {
                    basicDataSource.close();
                }
                catch (SQLException sQLException) {
                    throwable.addSuppressed(sQLException);
                }
            }
            throw new SQLException("Failed creating the database connection pool " + string + " data source", throwable);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader((URL[])objectArray, JDBCHelper.class.getClassLoader());
        basicDataSource.setDriverClassLoader((ClassLoader)uRLClassLoader);
        if (string3 == null || string3.isEmpty()) {
            uRLClassLoader.close();
            throw new SQLException("Driver class name not specified for the database connection pool " + string + " data source");
        }
        try {
            Driver driver = (Driver)Class.forName(string3, true, uRLClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            basicDataSource.setDriver(driver);
        }
        catch (Throwable throwable) {
            uRLClassLoader.close();
            throw new SQLException("Failed loading driver for the database connection pool " + string + " data source, URLs = " + Arrays.toString(objectArray) + ", Driver class name = " + string3, throwable);
        }
        if (n > 0) {
            basicDataSource.setInitialSize(n);
        }
        try {
            return new a(string, basicDataSource, string3, derbyImpl);
        }
        catch (SQLException sQLException) {
            try {
                basicDataSource.close();
            }
            catch (SQLException sQLException2) {
                sQLException.addSuppressed(sQLException2);
            }
            try {
                uRLClassLoader.close();
            }
            catch (IOException iOException) {
                sQLException.addSuppressed(iOException);
            }
            throw sQLException;
        }
    }

    private a(String string, BasicDataSource basicDataSource, String string2, DerbyImpl derbyImpl) throws SQLException {
        this.a = string;
        this.a = basicDataSource;
        this.a = derbyImpl;
        basicDataSource.setAbandonedLogWriter(new PrintWriter(this.a(2, "abandoned-", "-log"), true));
        basicDataSource.setLogWriter(new PrintWriter(this.a(3, "datasource-", "-log"), true));
        this.a = string2.contains(".derby.") ? IDBConnectionPool.Flavor.FLAVOR_DERBY : (string2.contains(".mysql.") ? IDBConnectionPool.Flavor.FLAVOR_MYSQL : IDBConnectionPool.Flavor.FLAVOR_UNKNOWN);
        ILog.INFO(this.getClass(), (String)("Database connection pool " + string + " created for driver " + string2));
    }

    @Override
    public IDBConnectionPool.Flavor getFlavor() {
        return this.a;
    }

    @Override
    public String getName() {
        return this.a;
    }

    private Writer a(int n, String string, String string2) {
        return new b(this, string, string2, n);
    }

    @Override
    public void dispose() throws SQLException {
        this.a(false);
    }

    void a(boolean bl) throws SQLException {
        if (JDBCHelper.a(this)) {
            try {
                this.a.close();
            }
            finally {
                ILog.INFO(this.getClass(), (String)("Database connection pool " + this.a + " closed"));
                ClassLoader classLoader = this.a.getDriverClassLoader();
                if (classLoader instanceof URLClassLoader) {
                    this.a.setDriverClassLoader(null);
                    try {
                        ((URLClassLoader)classLoader).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (this.a != null) {
                this.a.a(bl);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.a.getConnection();
    }

    @Override
    public boolean isDisposed() {
        return this.a.isClosed();
    }
}

