/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import java.util.Objects;

public final class TimeInterval {
    public static final TimeInterval[] NO_INTERVALS = new TimeInterval[0];
    private final long a;
    private final long b;

    public static TimeInterval startingAt(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("startTime is zero or negative: " + l2);
        }
        return new TimeInterval(l2, 0L);
    }

    public static TimeInterval endingAt(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("endTime is zero or negative: " + l2);
        }
        return new TimeInterval(0L, l2);
    }

    public static TimeInterval between(long l2, long l3) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("startTime is zero or negative: " + l2);
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("endTime is zero or negative: " + l3);
        }
        if (l2 >= l3) {
            throw new IllegalArgumentException("startTime is equal to or larger than endTime: " + l2 + " - " + l3);
        }
        return new TimeInterval(l2, l3);
    }

    private TimeInterval(long l2, long l3) {
        this.a = l2;
        this.b = l3;
    }

    public boolean isIncluded(long l2) {
        return !(this.a > 0L && l2 < this.a || this.b > 0L && l2 > this.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TimeInterval) {
            TimeInterval timeInterval = (TimeInterval)object;
            return timeInterval.a == this.a && timeInterval.b == this.b;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(42).append('[');
        if (this.a > 0L) {
            stringBuilder.append(this.a);
        }
        stringBuilder.append('-');
        if (this.b > 0L) {
            stringBuilder.append(this.b);
        }
        return stringBuilder.append(']').toString();
    }
}

