/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import com.iizix.ILog;
import com.iizix.RunMode;
import com.iizix.TemperatureUnit;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LocaleInfo
implements Cloneable {
    private static final String a = Locale.ENGLISH.getLanguage();
    private static final HashMap<String, LocaleInfo> a;
    public static final LocaleInfo ENGLISH_LOCALEINFO;
    public static final LocaleInfo DEFAULT_LOCALEINFO;
    private static LocaleInfo a;
    private final Locale a;
    private final boolean a;
    private final Currency a;
    private final DecimalFormatSymbols a;
    private final DateTimeFormatter[] a;
    private final DecimalFormat a;
    private final NumberFormat a;
    private final NumberFormat b;
    private final NumberFormat c;
    private final PeriodFormatter a;
    private TimeZone a;
    private ZoneOffset a;
    private ZoneId a;
    private final String b;
    private final Collator a = new DateTimeFormatter[FormatStyle.values().length];

    static {
        a = new HashMap();
        ENGLISH_LOCALEINFO = LocaleInfo.getLocaleInfo(Locale.ENGLISH);
        a = DEFAULT_LOCALEINFO = LocaleInfo.getLocaleInfo(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleInfo getLocaleInfo(String string) {
        LocaleInfo localeInfo;
        String string2 = a;
        synchronized (string2) {
            localeInfo = (LocaleInfo)((HashMap)((Object)a)).get(string);
            if (localeInfo == null) {
                localeInfo = new LocaleInfo(Locale.forLanguageTag(string), false);
                ((HashMap)((Object)a)).put(string, localeInfo);
            }
        }
        return localeInfo.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleInfo getLocaleInfo(Locale locale) {
        LocaleInfo localeInfo;
        String string = locale.toString();
        String string2 = a;
        synchronized (string2) {
            localeInfo = (LocaleInfo)((HashMap)((Object)a)).get(string);
            if (localeInfo == null) {
                localeInfo = new LocaleInfo(locale, false);
                ((HashMap)((Object)a)).put(string, localeInfo);
            }
        }
        return localeInfo.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocaleInfo getLocaleInfo(String string, String string2, String string3) {
        LocaleInfo localeInfo;
        String string4;
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = LocaleInfo.DEFAULT_LOCALEINFO.a.getCountry();
        }
        if (string == null || string.length() != 2) {
            string = "__";
        }
        if (string3 == null) {
            string3 = "";
        }
        if ((string4 = string2 + "\t" + string + "\t" + string3).equals("\t__\t")) {
            return a;
        }
        String string5 = a;
        synchronized (string5) {
            localeInfo = (LocaleInfo)((HashMap)((Object)a)).get(string4);
            if (localeInfo == null) {
                localeInfo = new LocaleInfo(string2, string, string3);
                ((HashMap)((Object)a)).put(string4, localeInfo);
            }
        }
        return localeInfo.clone();
    }

    public static void setCurrent(LocaleInfo localeInfo) {
        if (localeInfo == null) {
            throw new NullPointerException("localeInfo is null");
        }
        if (!RunMode.isDesignerRunMode()) {
            throw new IllegalStateException("Not Designer");
        }
        a = localeInfo;
    }

    public static LocaleInfo getNonNull(LocaleInfo localeInfo, boolean bl) {
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(bl);
        }
        return localeInfo;
    }

    public static LocaleInfo getCurrent(boolean bl) {
        LocaleInfo localeInfo;
        IClientSessionGyro iClientSessionGyro = IClientSessionGyro.getSessionInstance();
        if (iClientSessionGyro != null) {
            localeInfo = iClientSessionGyro.getEnvironment().getLocale();
        } else {
            IAppSessionGyro iAppSessionGyro = IAppSessionGyro.getSessionInstance();
            if (iAppSessionGyro != null) {
                localeInfo = iAppSessionGyro.getEnvironment().getLocale();
            } else {
                localeInfo = a;
                if (bl) {
                    ILog.WARNING(LocaleInfo.class, "Default locale information used, failed locating client session information", new Exception("Stack-Trace"));
                }
            }
        }
        return localeInfo;
    }

    private LocaleInfo(String string, String string2, String string3) {
        this(Locale.of(string, string2, string3), false);
    }

    private LocaleInfo(Locale locale, boolean bl) {
        Object object;
        this.a = locale;
        this.a = Collator.getInstance(locale);
        Object object2 = locale.getLanguage();
        this.a = bl || a.equals(object2);
        String string = locale.getCountry();
        if (string.length() == 2 && !string.equals("__")) {
            object2 = (String)object2 + "-" + string;
            object = locale.getVariant();
            if (!((String)object).isEmpty()) {
                object2 = (String)object2 + "-" + (String)object;
            }
        }
        this.b = object2;
        this.a = DecimalFormatSymbols.getInstance(locale);
        try {
            object = Currency.getInstance(locale);
        }
        catch (Exception exception) {
            object = Currency.getInstance("EUR");
        }
        this.a = object;
        this.a = new DecimalFormat();
        this.a.setCurrency((Currency)object);
        this.a.setDecimalFormatSymbols(this.a);
        this.a = NumberFormat.getIntegerInstance(locale);
        this.a.setCurrency((Currency)object);
        this.b = NumberFormat.getPercentInstance(locale);
        this.c = NumberFormat.getCurrencyInstance(locale);
        this.c.setCurrency(this.getCurrency());
        this.a = PeriodFormat.wordBased((Locale)locale);
    }

    public LocaleInfo clone() {
        try {
            LocaleInfo localeInfo = (LocaleInfo)super.clone();
            localeInfo.a = null;
            localeInfo.a = null;
            localeInfo.a = null;
            return localeInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public Locale getLocale() {
        return this.a;
    }

    public Collator getCollator() {
        return this.a;
    }

    public boolean isDefaultEnglish() {
        return this.a;
    }

    public String getLanguageCode() {
        return this.b;
    }

    public Currency getCurrency() {
        return this.a;
    }

    public NumberFormat createNumberFormat() {
        return NumberFormat.getNumberInstance(this.a);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.a;
    }

    public DecimalFormat createDecimalFormat() {
        return (DecimalFormat)this.a.clone();
    }

    public NumberFormat createIntegerFormat() {
        return (NumberFormat)this.a.clone();
    }

    public NumberFormat createPercentFormat() {
        return (NumberFormat)this.b.clone();
    }

    public NumberFormat createCurrencyFormat() {
        return (NumberFormat)this.c.clone();
    }

    public DateTimeFormatter getDateTimeFormatter(FormatStyle formatStyle) {
        int n2 = formatStyle.ordinal();
        DateTimeFormatter dateTimeFormatter = this.a[n2];
        if (dateTimeFormatter == null) {
            dateTimeFormatter = this.a[n2] = DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(this.a).withZone(this.getZoneId());
        }
        return dateTimeFormatter;
    }

    public DateTimeFormatter getDateTimeFormatter(String string) {
        return DateTimeFormatter.ofPattern(string, this.a);
    }

    public PeriodFormatter getPeriodFormatter() {
        return this.a;
    }

    public int initializeTimeZone(int n2, String string) {
        ZoneId zoneId;
        ZoneOffset zoneOffset;
        try {
            zoneOffset = ZoneOffset.ofTotalSeconds(n2 * 60);
        }
        catch (DateTimeException dateTimeException) {
            ILog.WARNING(this.getClass(), "Zone offset " + n2 + " minutes is out of range");
            return -1;
        }
        int n3 = 0;
        if (string == null || string.isEmpty()) {
            zoneId = ZoneId.ofOffset("GMT", zoneOffset);
            n3 = 1;
        } else {
            try {
                zoneId = ZoneId.of(string);
            }
            catch (DateTimeException dateTimeException) {
                if (!string.equals("GMT+0100 (Romance Standard Time)") && !string.equals("GMT+0200 (Romance Daylight Time)")) {
                    ILog.WARNING(this.getClass(), "Failed fetching Zone ID \"" + string + "\" from the Time Zone Database (TZDB): " + dateTimeException.getMessage());
                }
                zoneId = ZoneId.ofOffset("GMT", zoneOffset);
                n3 = 1;
            }
        }
        TimeZone timeZone = TimeZone.getTimeZone(zoneId);
        boolean bl = zoneOffset.equals(this.a) && zoneId.equals(this.a);
        this.a = zoneOffset;
        this.a = zoneId;
        this.a = timeZone;
        if (!bl) {
            int n4 = this.a.length;
            while (--n4 >= 0) {
                this.a[n4] = null;
            }
        }
        return n3;
    }

    public TimeZone getTimeZone() {
        if (this.a == null) {
            this.a = TimeZone.getDefault();
        }
        return this.a;
    }

    public ZoneId getZoneId() {
        if (this.a == null) {
            this.a = ZoneId.systemDefault();
        }
        return this.a;
    }

    public ZoneOffset getZoneOffset() {
        if (this.a == null) {
            ZoneId zoneId = ZoneId.systemDefault().normalized();
            this.a = zoneId instanceof ZoneOffset ? (ZoneOffset)zoneId : ZoneOffset.ofTotalSeconds(this.getTimeZone().getRawOffset() / 1000);
        }
        return this.a;
    }

    public String formatTemperature(double d2, int n2, TemperatureUnit temperatureUnit) {
        if (n2 <= 0) {
            return Long.toString(Math.round(d2));
        }
        DecimalFormat decimalFormat = this.createDecimalFormat();
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        return decimalFormat.format(d2) + temperatureUnit.suffix;
    }

    public String formatTemperature(float f2, int n2, TemperatureUnit temperatureUnit) {
        if (n2 <= 0) {
            return Integer.toString(Math.round(f2));
        }
        DecimalFormat decimalFormat = this.createDecimalFormat();
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        return decimalFormat.format(f2) + temperatureUnit.suffix;
    }
}

