/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;

public final class ThreeWayBaseTree
extends ResourceVariantTree {
    private final ThreeWaySubscriber subscriber;

    public ThreeWayBaseTree(ThreeWaySubscriber subscriber) {
        super(new BaseResourceVariantByteStore(subscriber));
        this.subscriber = subscriber;
    }

    @Override
    public IResource[] refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        return new IResource[0];
    }

    @Override
    protected IResourceVariant[] fetchMembers(IResourceVariant variant, IProgressMonitor progress) throws TeamException {
        return new IResourceVariant[0];
    }

    @Override
    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        return null;
    }

    @Override
    public IResource[] roots() {
        return this.getSubscriber().roots();
    }

    @Override
    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        return this.getSubscriber().getResourceVariant(resource, this.getByteStore().getBytes(resource));
    }

    private ThreeWaySubscriber getSubscriber() {
        return this.subscriber;
    }

    static class BaseResourceVariantByteStore
    extends ResourceVariantByteStore {
        private final ThreeWaySubscriber subscriber;

        public BaseResourceVariantByteStore(ThreeWaySubscriber subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void dispose() {
        }

        @Override
        public byte[] getBytes(IResource resource) throws TeamException {
            return this.subscriber.getSynchronizer().getBaseBytes(resource);
        }

        @Override
        public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
            return false;
        }

        @Override
        public boolean flushBytes(IResource resource, int depth) throws TeamException {
            return false;
        }

        @Override
        public boolean deleteBytes(IResource resource) throws TeamException {
            return false;
        }

        @Override
        public IResource[] members(IResource resource) throws TeamException {
            return this.subscriber.getSynchronizer().members(resource);
        }
    }
}

