/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ResourceApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class ProjectTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private final IContainer fRoot;
    private String[] fPackageNames;
    private final List<IPackageFragmentRoot> fPackageFragmentRoots = new CopyOnWriteArrayList<IPackageFragmentRoot>();

    public ProjectTypeContainer(IApiElement parent, IContainer container, IPackageFragmentRoot packageFragmentRoot) {
        super(parent, 3, container.getName());
        this.fRoot = container;
        if (packageFragmentRoot != null) {
            this.fPackageFragmentRoots.add(packageFragmentRoot);
        }
    }

    public void addPackageFragmentRoot(IPackageFragmentRoot root) {
        if (root != null && !this.fPackageFragmentRoots.contains(root)) {
            this.fPackageFragmentRoots.add(root);
            this.fPackageNames = null;
        }
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.doVisit(this.fRoot, "", visitor);
        }
        visitor.end(this);
    }

    @Override
    public void close() throws CoreException {
        this.fPackageNames = null;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Project Class File Container: " + this.getName());
        return buff.toString();
    }

    private void doVisit(IContainer container, String pkgName, ApiTypeContainerVisitor visitor) throws CoreException {
        IResource[] members = container.members();
        ArrayList<IContainer> dirs = new ArrayList<IContainer>();
        boolean visitPkg = visitor.visitPackage(pkgName);
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource file = iResourceArray[n2];
            switch (file.getType()) {
                case 2: {
                    dirs.add((IContainer)file);
                    break;
                }
                case 1: {
                    if (!visitPkg || !file.getName().endsWith(".class")) break;
                    String name = file.getName();
                    String typeName = name.substring(0, name.length() - 6);
                    if (pkgName.length() > 0) {
                        StringBuilder buf = new StringBuilder(pkgName);
                        buf.append('.');
                        buf.append(typeName);
                        typeName = buf.toString();
                    }
                    ResourceApiTypeRoot cf = new ResourceApiTypeRoot((IApiElement)this, (IFile)file, typeName);
                    visitor.visit(pkgName, cf);
                    visitor.end(pkgName, cf);
                    break;
                }
            }
            ++n2;
        }
        visitor.endVisitPackage(pkgName);
        for (IContainer child : dirs) {
            String nextName = null;
            if (pkgName.length() == 0) {
                nextName = child.getName();
            } else {
                StringBuilder buffer = new StringBuilder(pkgName);
                buffer.append('.');
                buffer.append(child.getName());
                nextName = buffer.toString();
            }
            this.doVisit(child, nextName, visitor);
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IFile file;
        IFolder folder;
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((folder = this.fRoot.getFolder(IPath.fromOSString((String)pkg.replace('.', '/')))).exists() && (file = folder.getFile(cfName + ".class")).exists()) {
            return new ResourceApiTypeRoot((IApiElement)this, file, qualifiedName);
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        if (this.fPackageNames == null) {
            TreeSet<String> names = new TreeSet<String>();
            for (IPackageFragmentRoot root : this.fPackageFragmentRoots) {
                if (!root.exists()) continue;
                ProjectTypeContainer.collectPackageNames(names, root);
            }
            this.fPackageNames = (String[])names.toArray(String[]::new);
        }
        return this.fPackageNames;
    }

    private static void collectPackageNames(Set<String> collector, IPackageFragmentRoot root) throws CoreException {
        IJavaElement[] children = root.getChildren();
        if (children != null) {
            IJavaElement[] iJavaElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (element instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    String name = fragment.getElementName();
                    if (name.length() == 0) {
                        name = "";
                    }
                    collector.add(name);
                }
                ++n2;
            }
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    @Override
    public int getContainerType() {
        return 3;
    }
}

