/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.style.prop;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.Startup;
import com.iizigo.editor.ContextMenuActionAdapter;
import com.iizigo.editor.ContextMenuItem;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.PropertyEditorSetup;
import com.iizigo.style.prop.CSSStyle;
import com.iizigo.style.prop.EditorStyles;
import com.iizigo.style.prop.IStylesFilter;
import com.iizigo.style.prop.c;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropUndoRedo;
import com.iizix.prop.PropCnr;
import com.iizix.prop.StylesStates;
import com.iizix.prop.ui.UIComp;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class StylesDesignerProp
extends DesignerProp {
    public static final ContextMenuActionAdapter addStateStylesAction = new c();

    static {
        Startup.callOnStart(() -> {
            ApplicationUI applicationUI = ApplicationUI.getInstance();
            ContextMenuItem contextMenuItem = new ContextMenuItem("Add State Styles", "S", applicationUI.getNewImageDescriptor(applicationUI.imageStateStyles), addStateStylesAction);
            contextMenuItem.setSeparatorBefore();
            StylesDesignerProp.addCommandContributionItem(contextMenuItem, EditorStyles.class);
        });
    }

    private static void a(EditorStyles editorStyles, IPropUndoRedo iPropUndoRedo) {
        Object object = iPropUndoRedo.getTargetViewer();
        if (object instanceof StructuredViewer) {
            StructuredViewer structuredViewer = (StructuredViewer)object;
            structuredViewer.getControl().setFocus();
            if (iPropUndoRedo instanceof PropEditorPart) {
                PropEditorPart propEditorPart = (PropEditorPart)iPropUndoRedo;
                propEditorPart.doOpen((GProp<?>)editorStyles, -1, "states");
            }
        }
    }

    StylesDesignerProp(EditorStyles editorStyles) {
        super((PropCnr)editorStyles);
    }

    @Override
    protected PropertyEditorSetup getPropertyEditorSetup() {
        return Activator.setupStyle;
    }

    @Override
    public int getCNCategory() {
        return -1;
    }

    @Override
    public Image getCNImage(int n2) {
        return ((EditorStyles)this.propertyContainer).isStateStyles() ? ApplicationUI.getInstance().imageStateStyles : ApplicationUI.getInstance().imageStyles;
    }

    @Override
    public String getCNText(int n2) {
        PropCnr propCnr = this.propertyContainer.getParent();
        if (propCnr instanceof EditorStyles) {
            int n3 = ((EditorStyles)this.propertyContainer).getStateMask();
            return "States - " + StylesStates.getDescription((int)n3);
        }
        if (propCnr instanceof IStylesFilter) {
            return ((IStylesFilter)propCnr).getStylesName((EditorStyles)this.propertyContainer);
        }
        if (this.propertyContainer instanceof EditorStyles && propCnr instanceof FilePropCnr) {
            return this.getParent().getCNText(n2);
        }
        if (propCnr instanceof UIComp) {
            return this.propertyContainer.getPropAtom().equals((Object)Atom.STYLES) ? "Styles" : "Styles " + this.propertyContainer.getPropName();
        }
        return super.getCNText(n2);
    }

    @Override
    public StyledString getCNStyledText(int n2) {
        if (((EditorStyles)this.propertyContainer).isStateStyles()) {
            int n3 = ((EditorStyles)this.propertyContainer).getStateMask();
            StyledString styledString = new StyledString("States - ");
            styledString.append(StylesStates.getDescription((int)n3), StyledString.COUNTER_STYLER);
            return styledString;
        }
        String string = this.getCNText(0);
        if (string != null) {
            return new StyledString(string);
        }
        return super.getCNStyledText(n2);
    }

    @Override
    public String getCNDescriptionType() {
        return "Styles";
    }

    @Override
    public String canPerform(int n2) {
        switch (n2) {
            case 1: {
                if (this.propertyContainer.getParent() instanceof EditorStyles) break;
                return "Cannot move main Styles property container";
            }
            case 2: {
                if (this.propertyContainer.getParent() instanceof EditorStyles) break;
                return "Cannot delete main Styles property container";
            }
        }
        return super.canPerform(n2);
    }

    @Override
    public boolean hasCNToolTip(ViewerCell viewerCell) {
        return !this.propertyContainer.isDisposed();
    }

    @Override
    public Point getCNToolTipShift(ViewerCell viewerCell) {
        return null;
    }

    @Override
    public int getCNToolTipTimeDisplayed(ViewerCell viewerCell) {
        return -1;
    }

    @Override
    public Composite createCNToolTip(Event event, ViewerCell viewerCell, Composite composite) {
        if (this.propertyContainer.isDisposed()) {
            return null;
        }
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = applicationUI.s2();
        gridLayout.horizontalSpacing = gridLayout.marginWidth = applicationUI.s8();
        gridLayout.marginHeight = applicationUI.s4();
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = this.appendStylesComposite(composite2);
        this.appendTooltipPropErrors(composite2);
        return composite3;
    }

    public Composite appendStylesComposite(Composite composite) {
        return this.appendStylesComposite(composite, false);
    }

    public Composite appendStylesComposite(Composite composite, boolean bl) {
        ArrayList<CSSStyle> arrayList;
        if (bl) {
            new Label(composite, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        CLabel cLabel = new CLabel(composite, 0);
        cLabel.setText(this.getCNText(0) + ":");
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        Font font = applicationUI.getBoldFont();
        cLabel.setFont(font);
        cLabel.setImage(applicationUI.getDecoratedImage(this.getCNImage(0), this.getErrorSeverity()));
        cLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        if (!bl) {
            new Label(composite, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        if ((arrayList = ((EditorStyles)this.propertyContainer).getStyles(false)).isEmpty()) {
            GridData gridData = new GridData(4, 128, true, false, 2, 1);
            gridData.verticalIndent = applicationUI.s4();
            Label label = new Label(composite, 16384);
            label.setLayoutData((Object)gridData);
            label.setText("(Empty)");
            label.setEnabled(false);
        } else {
            Collections.sort(arrayList, (cSSStyle, cSSStyle2) -> cSSStyle.cssName.compareTo(cSSStyle2.cssName));
            int n2 = ApplicationUI.autoScaleUp(800);
            int n3 = applicationUI.s5();
            for (CSSStyle cSSStyle3 : arrayList) {
                GridData gridData = new GridData(16384, 0x1000000, false, false);
                gridData.verticalIndent = n3;
                Label label = new Label(composite, 16384);
                label.setText(cSSStyle3.cssName.toLowerCase());
                label.setLayoutData((Object)gridData);
                gridData = new GridData(16384, 0x1000000, false, false);
                gridData.verticalIndent = n3;
                cLabel = new CLabel(composite, 16384);
                cLabel.setText(cSSStyle3.value);
                cLabel.setFont(applicationUI.getFixedFont());
                cLabel.setLayoutData((Object)gridData);
                if (cLabel.computeSize((int)-1, (int)-1).x > n2) {
                    gridData.widthHint = n2;
                }
                n3 = 0;
            }
        }
        return composite;
    }
}

