/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.Deflater;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DeflaterPool
implements AutoCloseable {
    private final ConcurrentLinkedDeque<Deflater> a;
    private final AtomicInteger a;
    private final int a;
    private volatile boolean a = new AtomicInteger(0);

    public DeflaterPool(int n, int n2) {
        this.a = n2;
        int n3 = 0;
        while (n3 < n) {
            this.a.offer(new Deflater(9));
            this.a.incrementAndGet();
            ++n3;
        }
    }

    public Deflater acquire() {
        if (this.a) {
            throw new IllegalStateException("Pool is closed");
        }
        Deflater deflater = this.a.poll();
        if (deflater != null) {
            return deflater;
        }
        this.a.incrementAndGet();
        return new Deflater(9);
    }

    public void release(Deflater deflater) {
        if (this.a || deflater == null) {
            if (deflater != null) {
                deflater.end();
            }
            return;
        }
        deflater.reset();
        if (this.a.get() > this.a) {
            if (this.a.decrementAndGet() >= this.a) {
                deflater.end();
                return;
            }
            this.a.incrementAndGet();
        }
        this.a.offer(deflater);
    }

    public <R> R withDeflater(Function<Deflater, R> function) {
        Deflater deflater = this.acquire();
        try {
            R r = function.apply(deflater);
            return r;
        }
        finally {
            this.release(deflater);
        }
    }

    public void withDeflater(Consumer<Deflater> consumer) {
        Deflater deflater = this.acquire();
        try {
            consumer.accept(deflater);
        }
        finally {
            this.release(deflater);
        }
    }

    @Override
    public void close() {
        Deflater deflater;
        this.a = true;
        while ((deflater = this.a.poll()) != null) {
            deflater.end();
        }
    }

    public int getPoolSize() {
        return this.a.size();
    }

    public int getTotalSize() {
        return this.a.get();
    }

    public static byte[] compress(DeflaterPool deflaterPool, byte[] byArray) {
        return deflaterPool.withDeflater((Deflater deflater) -> {
            deflater.setInput(byArray);
            deflater.finish();
            byte[] byArray2 = new byte[byArray.length + 64];
            int n = deflater.deflate(byArray2);
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            return byArray3;
        });
    }
}

